/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.DropDownFile;
import codechicken.nei.ItemHash;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemPanelStack;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.SubSetRangeTag;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.forge.GuiContainerManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ItemList {
    public static ArrayList items = new ArrayList();
    private static boolean matching = false;
    private static boolean loading = false;
    private static boolean research = false;
    private static boolean reload = false;

    public static ItemMatcher getSearchMatcher() {
        String matchstring = NEIClientConfig.getSearchExpression();
        SubSetRangeTag tagMatch = null;
        Pattern patternMatch = null;
        if (matchstring.startsWith("@") && matchstring.length() > 1) {
            tagMatch = DropDownFile.dropDownInstance.getTag(matchstring.substring(1), false);
        } else {
            matchstring = matchstring.replace(".", "");
            matchstring = matchstring.replace("?", ".");
            matchstring = matchstring.replace("*", ".+?");
            matchstring = matchstring.toLowerCase();
            try {
                patternMatch = Pattern.compile(matchstring);
            }
            catch (PatternSyntaxException e) {
                patternMatch = Pattern.compile("");
                LayoutManager.searchField.setText(matchstring.substring(0, matchstring.length() - 1));
            }
        }
        return new ItemMatcher(patternMatch, tagMatch);
    }

    public static boolean itemMatchesSearch(rj item) {
        return ItemList.getSearchMatcher().matches(item);
    }

    public static boolean isMatching() {
        return matching;
    }

    public static void updateSearch() {
        if (matching) {
            research = true;
        } else {
            new ThreadMatchSearch().start();
        }
    }

    public static void loadItems() {
        if (loading) {
            reload = true;
        } else {
            new ThreadLoadItems().start();
        }
    }

    public static class ItemMatcher {
        Pattern patternMatch;
        SubSetRangeTag tagMatch;

        public ItemMatcher(Pattern pattern, SubSetRangeTag tag) {
            this.patternMatch = pattern;
            this.tagMatch = tag;
        }

        public boolean matches(rj item) {
            if (this.tagMatch != null) {
                return this.tagMatch.isItemInRange(item.c, 0);
            }
            return this.patternMatch == null || this.patternMatch.toString().equals("") || this.patternMatch.matcher(GuiContainerManager.concatenatedDisplayName(item, true).toLowerCase()).find();
        }
    }

    public static class ThreadLoadItems
    extends Thread {
        public ThreadLoadItems() {
            super("NEI Item Loading Thread");
        }

        @Override
        public void run() {
            loading = true;
            block2: while (loading) {
                ArrayList<rj> items = new ArrayList<rj>();
                ArrayList sublist = new ArrayList();
                DropDownFile.dropDownInstance.resetHashes();
                int itemID = 0;
                while (itemID < rh.e.length) {
                    block14: {
                        ArrayList damageranges;
                        rh item;
                        block15: {
                            if (reload) {
                                reload = false;
                                continue block2;
                            }
                            item = rh.e[itemID];
                            if (item == null || ItemInfo.isHidden(item.bT)) break block14;
                            sublist.clear();
                            item.a(itemID, item.w(), sublist);
                            damageranges = ItemInfo.getItemDamageVariants(item.bT);
                            if (sublist.size() <= 0) break block15;
                            boolean finishSearch = false;
                            ArrayList<Integer> discreteDamages = new ArrayList<Integer>();
                            for (rj stack : sublist) {
                                if (stack.o()) {
                                    finishSearch = true;
                                    stack = stack.l();
                                    items.add(stack);
                                    DropDownFile.dropDownInstance.addItemIfInRange(itemID, stack.j(), stack.d);
                                    continue;
                                }
                                discreteDamages.add(stack.j());
                            }
                            if (finishSearch) break block14;
                            damageranges = damageranges == ItemInfo.defaultDamageRange ? NEIClientUtils.concatIntegersToRanges(discreteDamages) : NEIClientUtils.addIntegersToRanges(damageranges, discreteDamages);
                        }
                        boolean skipDamage0 = false;
                        ArrayList datalist = ItemInfo.getItemCompounds(itemID);
                        if (datalist != null && datalist.size() > 0 && NEIClientConfig.isActionPermissable("nbt")) {
                            skipDamage0 = true;
                            for (rj stack : datalist) {
                                stack = stack.l();
                                items.add(stack);
                                DropDownFile.dropDownInstance.addItemIfInRange(itemID, stack.j(), stack.d);
                            }
                        }
                        HashSet<String> damageIconSet = new HashSet<String>();
                        for (int[] damagerange : damageranges) {
                            int damage = damagerange[0];
                            while (damage <= damagerange[1]) {
                                rj itemstack = new rj(item, 1, damage);
                                try {
                                    int l = item.f(itemstack);
                                    String name = GuiContainerManager.concatenatedDisplayName(itemstack, false);
                                    String s = String.valueOf(name) + "@" + l;
                                    if (!damageIconSet.contains(s)) {
                                        damageIconSet.add(s);
                                        if (damage != 0 || !skipDamage0) {
                                            items.add(itemstack);
                                            DropDownFile.dropDownInstance.addItemIfInRange(itemID, itemstack.j(), null);
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ++damage;
                            }
                        }
                    }
                    ++itemID;
                }
                loading = false;
                ItemList.items = items;
            }
            DropDownFile.dropDownInstance.updateState();
            ItemList.updateSearch();
        }
    }

    public static class ThreadMatchSearch
    extends Thread {
        public ThreadMatchSearch() {
            super("NEI Item Searching Thread");
        }

        @Override
        public void run() {
            matching = true;
            block0: while (matching) {
                ArrayList<ItemPanelStack> visibleitems = new ArrayList<ItemPanelStack>();
                ItemMatcher matcher = ItemList.getSearchMatcher();
                for (rj item : items) {
                    if (research) {
                        research = false;
                        continue block0;
                    }
                    if (!item.o() ? NEIClientConfig.vishash.isItemHidden(item.c, item.j()) : NEIClientConfig.vishash.isItemHidden(item.c, item.d)) continue;
                    if (!NEIClientConfig.canGetItem(new ItemHash(item)) || !matcher.matches(item)) continue;
                    visibleitems.add(new ItemPanelStack(item));
                }
                ItemPanel.visibleitems = visibleitems;
                matching = false;
            }
        }
    }
}

