/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIClientUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class FastTransferManger {
    public LinkedList slotZones = new LinkedList();
    public HashMap slotZoneMap = new HashMap();

    public FastTransferManger(ov container) {
        this.generateSlotMap(container);
    }

    private void generateSlotMap(ov container) {
        int slotNo = 0;
        while (slotNo < container.b.size()) {
            if (!this.slotZoneMap.containsKey(slotNo) && container.a(slotNo).a(new rj(rh.n, 1))) {
                HashSet connectedSlots = new HashSet();
                this.findConnectedSlots(container, slotNo, connectedSlots);
                LinkedList zoneSlots = new LinkedList(connectedSlots);
                Collections.sort(zoneSlots, new SlotPositionComparator(container));
                this.slotZones.add(zoneSlots);
                Iterator iterator = zoneSlots.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    this.slotZoneMap.put(i, this.slotZones.size() - 1);
                }
            }
            ++slotNo;
        }
    }

    private void findConnectedSlots(ov container, int slotNo, HashSet connectedSlots) {
        connectedSlots.add(slotNo);
        pr slot = container.a(slotNo);
        int threshold = 18;
        int i = 0;
        while (i < container.b.size()) {
            if (!connectedSlots.contains(i)) {
                pr slot1 = container.a(i);
                if (Math.abs(slot.e - slot1.e) <= 18 && Math.abs(slot.f - slot1.f) <= 18) {
                    this.findConnectedSlots(container, i, connectedSlots);
                }
            }
            ++i;
        }
    }

    public static int findSlotWithItem(ov container, rj teststack) {
        int slotNo = 0;
        while (slotNo < container.b.size()) {
            rj stack = container.a(slotNo).c();
            if (stack != null && NEIClientUtils.areStacksSameType(stack, teststack)) {
                return slotNo;
            }
            ++slotNo;
        }
        return -1;
    }

    public static void clearSlots(ov container) {
        int slotNo = 0;
        while (slotNo < container.b.size()) {
            ((pr)container.b.get(slotNo)).d(null);
            ++slotNo;
        }
    }

    public void performMassTransfer(aqh window, int fromSlot, int toSlot, rj heldStack) {
        Integer fromZone = (Integer)this.slotZoneMap.get(fromSlot);
        Integer toZone = (Integer)this.slotZoneMap.get(toSlot);
        if (fromZone == null || toZone == null || fromZone == toZone) {
            return;
        }
        if (NEIClientUtils.getHeldItem() != null && !NEIClientUtils.areStacksSameType(heldStack, NEIClientUtils.getHeldItem())) {
            return;
        }
        if (!this.fillZoneWithHeldItem(window, toZone)) {
            return;
        }
        Iterator iterator = ((LinkedList)this.slotZones.get(fromZone)).iterator();
        while (iterator.hasNext()) {
            int transferFrom = (Integer)iterator.next();
            rj transferStack = window.d.a(transferFrom).c();
            if (!NEIClientUtils.areStacksSameType(heldStack, transferStack)) continue;
            this.clickSlot(window, transferFrom);
            if (this.fillZoneWithHeldItem(window, toZone)) continue;
            this.clickSlot(window, transferFrom);
            return;
        }
    }

    public int findShiftClickDestinationSlot(ov container, int fromSlot) {
        LinkedList save = this.saveContainer(container);
        pr slot = container.a(fromSlot);
        rj stack = slot.c();
        if (stack == null) {
            return -1;
        }
        stack.a = 1;
        slot.d(stack.l());
        LinkedList compareBefore = this.saveContainer(container);
        container.a(fromSlot, 0, true, (og)NEIClientUtils.getMinecraft().g);
        LinkedList compareAfter = this.saveContainer(container);
        try {
            int i = 0;
            while (i < compareBefore.size()) {
                if (i != fromSlot && !NEIClientUtils.areStacksIdentical((rj)compareBefore.get(i), (rj)compareAfter.get(i)) && compareAfter.get(i) != null && (compareBefore.get(i) == null && NEIClientUtils.areStacksSameType(stack, (rj)compareAfter.get(i)) || NEIClientUtils.areStacksSameType(stack, (rj)compareAfter.get(i)) && ((rj)compareAfter.get((int)i)).a - ((rj)compareBefore.get((int)i)).a > 0)) {
                    int n = i;
                    return n;
                }
                ++i;
            }
            return -1;
        }
        finally {
            this.restoreContainer(container, save);
        }
    }

    public LinkedList saveContainer(ov container) {
        LinkedList<rj> stacks = new LinkedList<rj>();
        int i = 0;
        while (i < container.b.size()) {
            stacks.add(NEIClientUtils.copyStack(container.a(i).c()));
            ++i;
        }
        return stacks;
    }

    public void restoreContainer(ov container, LinkedList items) {
        int i = 0;
        while (i < container.b.size()) {
            container.a(i).d((rj)items.get(i));
            ++i;
        }
        container.a(-999, 0, false, (og)NEIClientUtils.getMinecraft().g);
    }

    public void transferItem(aqh window, int fromSlot) {
        System.out.println("Starting Transfer");
        long transferStart = System.currentTimeMillis();
        int toSlot = this.findShiftClickDestinationSlot(window.d, fromSlot);
        if (toSlot == -1) {
            System.out.println("Transfer Complete: " + (System.currentTimeMillis() - transferStart) + "ms");
            return;
        }
        if (!window.d.a(fromSlot).a(null)) {
            this.moveOutputSet(window, fromSlot, toSlot);
        } else {
            this.moveOneItem(window, fromSlot, toSlot);
        }
        System.out.println("Transfer Complete: " + (System.currentTimeMillis() - transferStart) + "ms");
    }

    public void moveOutputSet(aqh window, int fromSlot, int toSlot) {
        if (NEIClientUtils.getHeldItem() != null) {
            return;
        }
        this.clickSlot(window, fromSlot);
        if (NEIClientUtils.getHeldItem() == null) {
            return;
        }
        this.clickSlot(window, toSlot);
    }

    public void moveOneItem(aqh window, int fromSlot, int toSlot) {
        this.clickSlot(window, fromSlot);
        this.clickSlot(window, toSlot, 1);
        this.clickSlot(window, fromSlot);
    }

    public void retrieveItem(aqh window, int toSlot) {
        Integer integer;
        pr slot = window.d.a(toSlot);
        rj slotStack = slot.c();
        if (slotStack == null || slotStack.a == slot.a() || slotStack.a == slotStack.d()) {
            return;
        }
        Integer destZone = (Integer)this.slotZoneMap.get(toSlot);
        if (destZone == null) {
            return;
        }
        int firstZoneSlot = this.findShiftClickDestinationSlot(window.d, toSlot);
        int firstZone = -1;
        if (firstZoneSlot != -1 && (integer = (Integer)this.slotZoneMap.get(firstZoneSlot)) != null && this.retrieveItemFromZone(window, firstZone = integer.intValue(), toSlot)) {
            return;
        }
        int zone = 0;
        while (zone < this.slotZones.size()) {
            if (zone != destZone && zone != firstZone && this.retrieveItemFromZone(window, zone, toSlot)) {
                return;
            }
            ++zone;
        }
        this.retrieveItemFromZone(window, destZone, toSlot);
    }

    private boolean retrieveItemFromZone(aqh window, int zone, int toSlot) {
        pr slot;
        rj stack1;
        int i;
        rj stack = window.d.a(toSlot).c();
        Iterator iterator = ((LinkedList)this.slotZones.get(zone)).iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            if (i == toSlot || !NEIClientUtils.areStacksSameType(stack, stack1 = (slot = window.d.a(i)).c()) || stack1.a == slot.a() || stack1.a == stack1.d()) continue;
            this.moveOneItem(window, i, toSlot);
            return true;
        }
        iterator = ((LinkedList)this.slotZones.get(zone)).iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            if (i == toSlot || !NEIClientUtils.areStacksSameType(stack, stack1 = (slot = window.d.a(i)).c())) continue;
            this.moveOneItem(window, i, toSlot);
            return true;
        }
        return false;
    }

    public void clickSlot(aqh window, int slotIndex) {
        this.clickSlot(window, slotIndex, 0);
    }

    public void clickSlot(aqh window, int slotIndex, int button) {
        this.clickSlot(window, slotIndex, button, false);
    }

    public void clickSlot(aqh window, int slotIndex, int button, boolean shift) {
        ov container = window.d;
        pr slot = null;
        if (slotIndex >= 0 && slotIndex < container.b.size()) {
            slot = container.a(slotIndex);
        }
        window.a(slot, slotIndex, button, shift);
    }

    public boolean fillZoneWithHeldItem(aqh window, int zoneIndex) {
        rj inToSlot;
        rj held;
        int transferTo;
        Iterator iterator = ((LinkedList)this.slotZones.get(zoneIndex)).iterator();
        while (iterator.hasNext()) {
            transferTo = (Integer)iterator.next();
            held = NEIClientUtils.getHeldItem();
            if (held == null) break;
            inToSlot = window.d.a(transferTo).c();
            if (!NEIClientUtils.areStacksSameType(inToSlot, held)) continue;
            this.clickSlot(window, transferTo);
        }
        iterator = ((LinkedList)this.slotZones.get(zoneIndex)).iterator();
        while (iterator.hasNext()) {
            transferTo = (Integer)iterator.next();
            held = NEIClientUtils.getHeldItem();
            if (held == null) break;
            inToSlot = window.d.a(transferTo).c();
            if (inToSlot != null) continue;
            this.clickSlot(window, transferTo);
        }
        return NEIClientUtils.getHeldItem() == null;
    }

    public void throwAll(aqh window, int pickedUpFromSlot) {
        rj held = NEIClientUtils.getHeldItem();
        if (held == null) {
            return;
        }
        this.clickSlot(window, -999);
        Iterator iterator = ((LinkedList)this.slotZones.get((Integer)this.slotZoneMap.get(pickedUpFromSlot))).iterator();
        while (iterator.hasNext()) {
            int slotIndex = (Integer)iterator.next();
            pr slot = window.d.a(slotIndex);
            if (!NEIClientUtils.areStacksSameType(held, slot.c())) continue;
            this.clickSlot(window, slotIndex);
            this.clickSlot(window, -999);
        }
    }

    public static class SlotPositionComparator
    implements Comparator {
        ov container;

        public SlotPositionComparator(ov c) {
            this.container = c;
        }

        public int compare(Integer arg0, Integer arg1) {
            pr slot1 = this.container.a(arg0.intValue());
            pr slot2 = this.container.a(arg1.intValue());
            if (slot2.f != slot1.f) {
                return slot1.f - slot2.f;
            }
            return slot1.e - slot2.e;
        }
    }
}

