/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.ObfuscationManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InstructionComparator {
    public static boolean varInsnEqual(AbstractInsnNode absnode, VarInsnNode varnode) {
        if (!(absnode instanceof VarInsnNode) || absnode.getOpcode() != varnode.getOpcode()) {
            return false;
        }
        return ((VarInsnNode)absnode).var == varnode.var;
    }

    public static boolean methodInsnEqual(AbstractInsnNode absnode, int Opcode, ObfuscationManager.MethodMapping method) {
        if (!(absnode instanceof MethodInsnNode) || absnode.getOpcode() != Opcode) {
            return false;
        }
        return method.matches((MethodInsnNode)absnode);
    }

    public static boolean methodInsnEqual(AbstractInsnNode absnode, MethodInsnNode methodnode) {
        if (!(absnode instanceof MethodInsnNode) || absnode.getOpcode() != methodnode.getOpcode()) {
            return false;
        }
        MethodInsnNode absmethodnode = (MethodInsnNode)absnode;
        return absmethodnode.owner.equals(methodnode.owner) && absmethodnode.name.equals(methodnode.name) && absmethodnode.desc.equals(methodnode.desc);
    }

    public static boolean ldcInsnEqual(AbstractInsnNode absnode, LdcInsnNode ldcnode) {
        if (!(absnode instanceof LdcInsnNode) || absnode.getOpcode() != ldcnode.getOpcode()) {
            return false;
        }
        LdcInsnNode absldcnode = (LdcInsnNode)absnode;
        if (absldcnode.cst.equals("~") || ldcnode.cst.equals("~")) {
            return true;
        }
        return absldcnode.cst.equals(ldcnode.cst);
    }

    public static boolean typeInsnEqual(AbstractInsnNode absnode, TypeInsnNode typenode) {
        if (!(absnode instanceof TypeInsnNode) || absnode.getOpcode() != typenode.getOpcode()) {
            return false;
        }
        TypeInsnNode abstypenode = (TypeInsnNode)absnode;
        if (abstypenode.desc.equals("~") || typenode.desc.equals("~")) {
            return true;
        }
        return abstypenode.desc.equals(typenode.desc);
    }

    public static boolean insnEqual(AbstractInsnNode node1, AbstractInsnNode node2) {
        if (node2 instanceof VarInsnNode) {
            return InstructionComparator.varInsnEqual(node1, (VarInsnNode)node2);
        }
        if (node2 instanceof MethodInsnNode) {
            return InstructionComparator.methodInsnEqual(node1, (MethodInsnNode)node2);
        }
        if (node2 instanceof LdcInsnNode) {
            return InstructionComparator.ldcInsnEqual(node1, (LdcInsnNode)node2);
        }
        if (node2 instanceof TypeInsnNode) {
            return InstructionComparator.typeInsnEqual(node1, (TypeInsnNode)node2);
        }
        return node1.getOpcode() == node2.getOpcode();
    }

    public static InsnList getImportantList(InsnList list) {
        if (list.size() == 0) {
            return list;
        }
        HashMap<LabelNode, LabelNode> labelMap = new HashMap<LabelNode, LabelNode>();
        AbstractInsnNode insnnode = list.getFirst();
        while (insnnode.getNext() != null) {
            if (insnnode instanceof LabelNode) {
                labelMap.put((LabelNode)insnnode, (LabelNode)insnnode);
            }
            insnnode = insnnode.getNext();
        }
        InsnList importantNodeList = new InsnList();
        AbstractInsnNode insnnode2 = list.getFirst();
        while (insnnode2.getNext() != null) {
            if (!(insnnode2 instanceof LabelNode) && !(insnnode2 instanceof LineNumberNode)) {
                importantNodeList.add(insnnode2.clone(labelMap));
            }
            insnnode2 = insnnode2.getNext();
        }
        return importantNodeList;
    }

    public static boolean insnListMatches(InsnList search, InsnList find, int start) {
        if (search.size() - start < find.size()) {
            return false;
        }
        int i = 0;
        while (i < find.size()) {
            if (!InstructionComparator.insnEqual(search.get(i + start), find.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static List insnListFind(InsnList search, InsnList find) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        int start = 0;
        while (start < search.size() - find.size()) {
            if (InstructionComparator.insnListMatches(search, find, start)) {
                list.add(start);
            }
            ++start;
        }
        return list;
    }
}

