/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.CodeChickenAccessTransformer;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import cpw.mods.fml.relauncher.RelaunchClassLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

@IFMLLoadingPlugin.TransformerExclusions(value={"codechicken.core.asm"})
public class CodeChickenCorePlugin
implements IFMLLoadingPlugin,
IFMLCallHook {
    public static RelaunchClassLoader cl;
    public static File minecraftDir;

    public String[] getLibraryRequestClass() {
        return null;
    }

    public String[] getASMTransformerClass() {
        return new String[]{"codechicken.core.asm.ClassHeirachyManager", "codechicken.core.asm.CodeChickenAccessTransformer"};
    }

    public String getModContainerClass() {
        return "codechicken.core.asm.CodeChickenCoreModContainer";
    }

    public String getSetupClass() {
        return "codechicken.core.asm.CodeChickenCorePlugin";
    }

    public void injectData(Map data) {
        cl = (RelaunchClassLoader)data.get("classLoader");
        if (data.containsKey("mcLocation")) {
            minecraftDir = (File)data.get("mcLocation");
        }
    }

    public Void call() throws Exception {
        CodeChickenAccessTransformer.addTransformerMap("codechickencore_at.cfg");
        this.scanCodeChickenMods();
        return null;
    }

    private void scanCodeChickenMods() {
        File modsDir = new File(minecraftDir, "mods");
        File[] fileArray = modsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(".jar");
            }
        });
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                JarFile jar = new JarFile(file);
                try {
                    String mapFile;
                    Attributes attr;
                    Manifest manifest = jar.getManifest();
                    if (manifest != null && (attr = manifest.getMainAttributes()) != null && (mapFile = attr.getValue("AccessTransformer")) != null) {
                        CodeChickenAccessTransformer.addTransformerMap(mapFile);
                    }
                }
                finally {
                    jar.close();
                }
            }
            catch (Exception e) {
                System.err.println("CodeChickenCore: Failed to read jar file: " + file.getName());
            }
            ++n2;
        }
    }
}

