/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.BlockCoord;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;

public final class PacketCustom {
    private String channel;
    private int type;
    private boolean isChunkDataPacket;
    private boolean incoming;
    private ByteArrayOutputStream dataarrayout;
    private DataOutputStream dataout;
    private DataInputStream datain;
    private static HashMap clienthandlermap = new HashMap();
    private static HashMap serverhandlermap = new HashMap();

    private PacketCustom(ce packet) {
        this.incoming = true;
        this.channel = packet.a;
        this.datain = new DataInputStream(new ByteArrayInputStream(packet.c));
        this.type = this.readUnsignedByte();
    }

    public PacketCustom(String channel, int type) {
        this.channel = channel;
        this.type = type;
        this.incoming = false;
        this.isChunkDataPacket = false;
        this.dataarrayout = new ByteArrayOutputStream();
        this.dataout = new DataOutputStream(this.dataarrayout);
        this.writeByte(type);
    }

    public int getType() {
        return this.type;
    }

    public void setChunkDataPacket() {
        this.isChunkDataPacket = true;
    }

    public ce toPacket() {
        if (this.type == 0) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)new IllegalStateException("Type not set"));
            return null;
        }
        if (this.incoming) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)new IllegalStateException("Tried to write an incoming packet"));
            return null;
        }
        ce payload = new ce();
        payload.a = this.channel;
        payload.r = this.isChunkDataPacket;
        payload.c = this.dataarrayout.toByteArray();
        payload.b = payload.c.length;
        return payload;
    }

    public void writeBoolean(boolean b) {
        try {
            this.dataout.writeBoolean(b);
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
        }
    }

    public void writeByte(int b) {
        try {
            this.dataout.writeByte(b);
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
        }
    }

    public void writeShort(int s) {
        try {
            this.dataout.writeShort(s);
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
        }
    }

    public void writeInt(int i) {
        try {
            this.dataout.writeInt(i);
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
        }
    }

    public void writeFloat(float f) {
        try {
            this.dataout.writeFloat(f);
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
        }
    }

    public void writeDouble(double d) {
        try {
            this.dataout.writeDouble(d);
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
        }
    }

    public void writeLong(long l2) {
        try {
            this.dataout.writeLong(l2);
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
        }
    }

    public void writeByteArray(byte[] barray) {
        try {
            this.dataout.write(barray);
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
        }
    }

    public void writeCoord(int x, int y, int z) {
        this.writeInt(x);
        this.writeByte(y);
        this.writeInt(z);
    }

    public void writeCoord(BlockCoord coord) {
        this.writeCoord(coord.a, coord.b, coord.c);
    }

    public void writeString(String s) {
        try {
            if (s.length() > 65535) {
                throw new IOException("String length: " + s.length() + "too long.");
            }
            this.dataout.writeShort(s.length());
            this.dataout.writeChars(s);
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
        }
    }

    public void writeItemStack(rj spawnstack) {
        if (spawnstack == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(spawnstack.c);
            this.writeByte(spawnstack.a);
            this.writeShort(spawnstack.j());
            this.writeNBTTagCompound(spawnstack.d);
        }
    }

    public void writeNBTTagCompound(an compound) {
        try {
            if (compound == null) {
                this.writeShort(-1);
            } else {
                byte[] var3 = av.a((an)compound);
                this.writeShort((short)var3.length);
                this.writeByteArray(var3);
            }
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
        }
    }

    public boolean readBoolean() {
        try {
            return this.datain.readBoolean();
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
            return false;
        }
    }

    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    public byte readByte() {
        try {
            return this.datain.readByte();
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
            return 0;
        }
    }

    public short readShort() {
        try {
            return this.datain.readShort();
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
            return 0;
        }
    }

    public int readInt() {
        try {
            return this.datain.readInt();
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
            return 0;
        }
    }

    public float readFloat() {
        try {
            return this.datain.readFloat();
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
            return 0.0f;
        }
    }

    public double readDouble() {
        try {
            return this.datain.readDouble();
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
            return 0.0;
        }
    }

    public long readLong() {
        try {
            return this.datain.readLong();
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
            return 0L;
        }
    }

    public char readChar() {
        try {
            return this.datain.readChar();
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
            return '\u0000';
        }
    }

    public BlockCoord readCoord() {
        return new BlockCoord(this.readInt(), this.readUnsignedByte(), this.readInt());
    }

    public byte[] readByteArray(int length) {
        try {
            byte[] barray = new byte[length];
            this.datain.readFully(barray, 0, length);
            return barray;
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
            return null;
        }
    }

    public String readString() {
        try {
            int length = this.datain.readUnsignedShort();
            char[] chars = new char[length];
            int i = 0;
            while (i < length) {
                chars[i] = this.readChar();
                ++i;
            }
            return new String(chars);
        }
        catch (IOException e) {
            ModLoader.throwException((String)"Custom Packet", (Throwable)e);
            return null;
        }
    }

    public rj readItemStack() {
        rj var2 = null;
        short itemID = this.readShort();
        if (itemID >= 0) {
            byte stackSize = this.readByte();
            short damage = this.readShort();
            var2 = new rj((int)itemID, (int)stackSize, (int)damage);
            var2.d = this.readNBTTagCompound();
        }
        return var2;
    }

    public an readNBTTagCompound() {
        short var2;
        block3: {
            try {
                var2 = this.readShort();
                if (var2 >= 0) break block3;
                return null;
            }
            catch (IOException e) {
                ModLoader.throwException((String)"Custom Packet", (Throwable)e);
                return null;
            }
        }
        byte[] var3 = this.readByteArray(var2);
        return av.a((byte[])var3);
    }

    public static void assignHandler(String channel, int firstID, int lastID, ICustomPacketHandler IHandler) {
        Side side = IHandler instanceof ICustomPacketHandler.IClientPacketHandler ? Side.CLIENT : Side.SERVER;
        HashMap handlerMap = side.isClient() ? clienthandlermap : serverhandlermap;
        CustomPacketHandler handler = (CustomPacketHandler)handlerMap.get(channel);
        if (handler == null) {
            handler = side.isClient() ? new ClientPacketHander(channel) : new ServerPacketHander(channel);
            handlerMap.put(channel, handler);
        }
        handler.registerRange(firstID, lastID, IHandler);
    }

    /* synthetic */ PacketCustom(ce ce2, PacketCustom packetCustom) {
        this(ce2);
    }

    private static class ClientPacketHander
    extends CustomPacketHandler {
        public ClientPacketHander(String channel) {
            super(channel);
        }

        @Override
        public Side getSide() {
            return Side.CLIENT;
        }

        @Override
        public void handle(ICustomPacketHandler handler, PacketCustom packet, Player player) {
            ((ICustomPacketHandler.IClientPacketHandler)handler).handlePacket(packet, Minecraft.x().r(), Minecraft.x());
        }
    }

    private static abstract class CustomPacketHandler
    implements IPacketHandler {
        HashMap handlermap = new HashMap();

        public CustomPacketHandler(String channel) {
            NetworkRegistry.instance().registerChannel((IPacketHandler)this, channel, this.getSide());
        }

        public void onPacketData(az manager, ce packet, Player player) {
            PacketCustom packetCustom = new PacketCustom(packet, null);
            ICustomPacketHandler handler = (ICustomPacketHandler)this.handlermap.get(packetCustom.type);
            if (handler != null) {
                this.handle(handler, packetCustom, player);
            }
        }

        public void registerRange(int firstID, int lastID, ICustomPacketHandler handler) {
            int i = firstID;
            while (i <= lastID) {
                this.handlermap.put(i, handler);
                ++i;
            }
        }

        public abstract Side getSide();

        public abstract void handle(ICustomPacketHandler var1, PacketCustom var2, Player var3);
    }

    public static interface ICustomPacketHandler {

        public static interface IClientPacketHandler
        extends ICustomPacketHandler {
            public void handlePacket(PacketCustom var1, asv var2, Minecraft var3);
        }

        public static interface IServerPacketHandler
        extends ICustomPacketHandler {
            public void handlePacket(PacketCustom var1, gz var2, gu var3);
        }
    }

    private static class ServerPacketHander
    extends CustomPacketHandler {
        public ServerPacketHander(String channel) {
            super(channel);
        }

        @Override
        public Side getSide() {
            return Side.SERVER;
        }

        @Override
        public void handle(ICustomPacketHandler handler, PacketCustom packet, Player player) {
            ((ICustomPacketHandler.IServerPacketHandler)handler).handlePacket(packet, ((gu)player).a, (gu)player);
        }
    }
}

