/*
 * Decompiled with CFR 0.152.
 */
package ic2.platform;

import forge.DimensionManager;
import forge.IPacketHandler;
import ic2.api.INetworkClientTileEntityEventListener;
import ic2.api.INetworkDataProvider;
import ic2.api.INetworkItemEventListener;
import ic2.common.DataEncoder;
import ic2.common.IHandHeldInventory;
import ic2.common.IHasGui;
import ic2.common.ItemArmorQuantumSuit;
import ic2.platform.Keyboard;
import ic2.platform.Platform;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class NetworkManager
implements IPacketHandler {
    private static final int updatePeriod = 2;
    private static Map fieldsToUpdateSet = new HashMap();
    private static Map ticksLeftToUpdate = new HashMap();

    public static void onTick(ge world) {
        int worldTicksLeftToUpdate = !ticksLeftToUpdate.containsKey(world) ? 2 : (Integer)ticksLeftToUpdate.get(world);
        if (--worldTicksLeftToUpdate == 0) {
            NetworkManager.sendUpdatePacket(world);
            worldTicksLeftToUpdate = 2;
        }
        ticksLeftToUpdate.put(world, worldTicksLeftToUpdate);
    }

    public static void updateTileEntityField(qj te, String field) {
        if (!fieldsToUpdateSet.containsKey(te.k)) {
            fieldsToUpdateSet.put(te.k, new HashSet());
        }
        Set worldFieldsToUpdateSet = (Set)fieldsToUpdateSet.get(te.k);
        worldFieldsToUpdateSet.add(new TileEntityField(te, field));
        if (worldFieldsToUpdateSet.size() > 10000) {
            NetworkManager.sendUpdatePacket(te.k);
        }
    }

    public static void initiateTileEntityEvent(qj te, int event, boolean limitRange) {
        int maxDistance = limitRange ? 400 : ModLoader.getMinecraftServerInstance().h.a() + 16;
        ge world = te.k;
        gl packet = null;
        for (Object obj : world.d) {
            gi entityPlayer = (gi)obj;
            int distanceX = te.l - (int)entityPlayer.bm;
            int distanceZ = te.n - (int)entityPlayer.bo;
            int distance = limitRange ? distanceX * distanceX + distanceZ * distanceZ : Math.max(Math.abs(distanceX), Math.abs(distanceZ));
            if (distance > maxDistance) continue;
            if (packet == null) {
                try {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    DataOutputStream os = new DataOutputStream(buffer);
                    os.writeByte(1);
                    os.writeInt(world.t.g);
                    os.writeInt(te.l);
                    os.writeInt(te.m);
                    os.writeInt(te.n);
                    os.writeInt(event);
                    os.close();
                    packet = new gl();
                    packet.a = "ic2";
                    packet.p = false;
                    packet.c = buffer.toByteArray();
                    packet.b = buffer.size();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            entityPlayer.a.b(packet);
        }
    }

    public static void initiateItemEvent(ih player, kp itemStack, int event, boolean limitRange) {
        if (player.v.length() > 127) {
            return;
        }
        int maxDistance = limitRange ? 400 : ModLoader.getMinecraftServerInstance().h.a() + 16;
        gl packet = null;
        for (Object obj : player.bi.d) {
            gi entityPlayer = (gi)obj;
            int distanceX = (int)player.bm - (int)entityPlayer.bm;
            int distanceZ = (int)player.bo - (int)entityPlayer.bo;
            int distance = limitRange ? distanceX * distanceX + distanceZ * distanceZ : Math.max(Math.abs(distanceX), Math.abs(distanceZ));
            if (distance > maxDistance) continue;
            if (packet == null) {
                try {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    DataOutputStream os = new DataOutputStream(buffer);
                    os.writeByte(2);
                    os.writeByte(player.v.length());
                    os.writeChars(player.v);
                    os.writeInt(itemStack.c);
                    os.writeInt(itemStack.h());
                    os.writeInt(event);
                    os.close();
                    packet = new gl();
                    packet.a = "ic2";
                    packet.p = false;
                    packet.c = buffer.toByteArray();
                    packet.b = buffer.size();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            entityPlayer.a.b(packet);
        }
    }

    public static void announceBlockUpdate(ge world, int x, int y, int z) {
        gl packet = null;
        for (Object obj : world.d) {
            gi entityPlayer = (gi)obj;
            int distance = Math.min(Math.abs(x - (int)entityPlayer.bm), Math.abs(z - (int)entityPlayer.bo));
            if (distance > ModLoader.getMinecraftServerInstance().h.a() + 16) continue;
            if (packet == null) {
                try {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    DataOutputStream os = new DataOutputStream(buffer);
                    os.writeByte(3);
                    os.writeInt(world.t.g);
                    os.writeInt(x);
                    os.writeInt(y);
                    os.writeInt(z);
                    os.close();
                    packet = new gl();
                    packet.a = "ic2";
                    packet.p = true;
                    packet.c = buffer.toByteArray();
                    packet.b = buffer.size();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            entityPlayer.a.b(packet);
        }
    }

    public static void requestInitialData(INetworkDataProvider dataProvider) {
    }

    public static void initiateClientItemEvent(kp itemStack, int event) {
    }

    public static void initiateClientTileEntityEvent(qj te, int event) {
    }

    public static void initiateGuiDisplay(gi entityPlayer, IHasGui inventory, int windowId) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(4);
            if (inventory instanceof qj) {
                qj te = (qj)inventory;
                os.writeByte(0);
                os.writeInt(te.k.t.g);
                os.writeInt(te.l);
                os.writeInt(te.m);
                os.writeInt(te.n);
            } else if (entityPlayer.k.d() != null && entityPlayer.k.d().a() instanceof IHandHeldInventory) {
                os.writeByte(1);
                os.writeInt(entityPlayer.k.c);
            } else {
                Platform.displayError("An unknown GUI type was attempted to be displayed.\nThis could happen due to corrupted data from a player or a bug.\n\n(Technical information: " + inventory + ")");
            }
            os.writeInt(windowId);
            os.close();
            gl packet = new gl();
            packet.a = "ic2";
            packet.p = false;
            packet.c = buffer.toByteArray();
            packet.b = buffer.size();
            entityPlayer.a.b((lx)packet);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void sendUpdatePacket(ge world) {
        if (!fieldsToUpdateSet.containsKey(world)) {
            return;
        }
        Set worldFieldsToUpdateSet = (Set)fieldsToUpdateSet.get(world);
        if (worldFieldsToUpdateSet.isEmpty()) {
            return;
        }
        for (Object obj : world.d) {
            gi entityPlayer = (gi)obj;
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                buffer.write(0);
                GZIPOutputStream gzip = new GZIPOutputStream(buffer);
                DataOutputStream os = new DataOutputStream(gzip);
                os.writeInt(world.t.g);
                for (TileEntityField tef : worldFieldsToUpdateSet) {
                    int distance;
                    if (tef.te.l() || tef.te.k != world || tef.target != null && tef.target != entityPlayer || (distance = Math.min(Math.abs(tef.te.l - (int)entityPlayer.bm), Math.abs(tef.te.n - (int)entityPlayer.bo))) > ModLoader.getMinecraftServerInstance().h.a() + 16) continue;
                    os.writeInt(tef.te.l);
                    os.writeInt(tef.te.m);
                    os.writeInt(tef.te.n);
                    os.writeShort(tef.field.length());
                    os.writeChars(tef.field);
                    Field field = null;
                    try {
                        Class<?> fieldDeclaringClass = tef.te.getClass();
                        do {
                            try {
                                field = fieldDeclaringClass.getDeclaredField(tef.field);
                            }
                            catch (NoSuchFieldException e) {
                                fieldDeclaringClass = fieldDeclaringClass.getSuperclass();
                            }
                        } while (field == null && fieldDeclaringClass != null);
                        if (field == null) {
                            throw new NoSuchFieldException(tef.field);
                        }
                        field.setAccessible(true);
                        DataEncoder.encode(os, field.get(tef.te));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                os.close();
                gzip.close();
                if (buffer.size() <= 1) continue;
                gl packet = new gl();
                packet.a = "ic2";
                packet.p = true;
                packet.c = buffer.toByteArray();
                packet.b = buffer.size();
                entityPlayer.a.b((lx)packet);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        worldFieldsToUpdateSet.clear();
    }

    public void onPacketData(qq network, String channel, byte[] data) {
        block19: {
            gi player = ((mm)network.getNetHandler()).getPlayerEntity();
            ByteArrayInputStream isRaw = new ByteArrayInputStream(data, 1, data.length - 1);
            try {
                block1 : switch (data[0]) {
                    case 0: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int worldType = is.readInt();
                        int x = is.readInt();
                        int y = is.readInt();
                        int z = is.readInt();
                        for (ge world : DimensionManager.getWorlds()) {
                            if (worldType != world.t.g) continue;
                            qj te = world.b(x, y, z);
                            if (te instanceof INetworkDataProvider) {
                                if (!fieldsToUpdateSet.containsKey(world)) {
                                    fieldsToUpdateSet.put(world, new HashSet());
                                }
                                Set worldFieldsToUpdateSet = (Set)fieldsToUpdateSet.get(world);
                                for (String field : ((INetworkDataProvider)te).getNetworkedFields()) {
                                    worldFieldsToUpdateSet.add(new TileEntityField(te, field, player));
                                    if (worldFieldsToUpdateSet.size() <= 10000) continue;
                                    NetworkManager.sendUpdatePacket(world);
                                }
                            }
                            break block19;
                        }
                        break;
                    }
                    case 1: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int itemId = is.readInt();
                        int itemDamage = is.readInt();
                        int event = is.readInt();
                        if (itemId >= id.d.length) break;
                        id item = id.d[itemId];
                        if (item instanceof INetworkItemEventListener) {
                            ((INetworkItemEventListener)item).onNetworkEvent(itemDamage, (ih)player, event);
                        }
                        break;
                    }
                    case 2: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int keyState = is.readInt();
                        Keyboard.processKeyUpdate((ih)player, keyState);
                        break;
                    }
                    case 3: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int worldType = is.readInt();
                        int x = is.readInt();
                        int y = is.readInt();
                        int z = is.readInt();
                        int event = is.readInt();
                        for (ge world : DimensionManager.getWorlds()) {
                            if (worldType != world.t.g) continue;
                            qj te = world.b(x, y, z);
                            if (te instanceof INetworkClientTileEntityEventListener) {
                                ((INetworkClientTileEntityEventListener)te).onNetworkEvent((ih)player, event);
                                break block1;
                            }
                            break block19;
                        }
                        break;
                    }
                    case 4: {
                        GZIPInputStream gzip = new GZIPInputStream((InputStream)isRaw, data.length - 1);
                        DataInputStream is = new DataInputStream(gzip);
                        int clientNetworkProtocolVersion = is.readInt();
                        if (clientNetworkProtocolVersion != 103) {
                            ((mm)network.getNetHandler()).a("IC2 network protocol version mismatch (expected 103 (" + mod_IC2.getInstance().getVersion() + "), got " + clientNetworkProtocolVersion + ")");
                        }
                        boolean enableQuantumSpeedOnSprint = is.readByte() != 0;
                        ItemArmorQuantumSuit.enableQuantumSpeedOnSprintMap.put(player, enableQuantumSpeedOnSprint);
                        int idDataLength = is.readInt();
                        Properties clientRuntimeIdProperties = new Properties();
                        clientRuntimeIdProperties.load(is);
                        is.close();
                        for (Map.Entry<Object, Object> mapEntry : mod_IC2.runtimeIdProperties.entrySet()) {
                            String key = (String)mapEntry.getKey();
                            String value = (String)mapEntry.getValue();
                            if (!clientRuntimeIdProperties.containsKey(key)) {
                                ((mm)network.getNetHandler()).a("IC2 id value missing (" + key + ")");
                                break block1;
                            }
                            int separatorPos = key.indexOf(46);
                            if (separatorPos == -1) continue;
                            String section = key.substring(0, separatorPos);
                            String entry = key.substring(separatorPos + 1);
                            if (!section.equals("block") && !section.equals("item") || value.equals(clientRuntimeIdProperties.get(key))) continue;
                            ((mm)network.getNetHandler()).a("IC2 id mismatch (" + key + ": expected " + value + ", got " + clientRuntimeIdProperties.get(key) + ")");
                        }
                        break;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static class TileEntityField {
        qj te;
        String field;
        gi target = null;

        TileEntityField(qj te, String field) {
            this.te = te;
            this.field = field;
        }

        TileEntityField(qj te, String field, gi target) {
            this.te = te;
            this.field = field;
            this.target = target;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TileEntityField) {
                TileEntityField tef = (TileEntityField)obj;
                return tef.te == this.te && tef.field.equals(this.field);
            }
            return false;
        }

        public int hashCode() {
            return this.te.hashCode() * 31 ^ this.field.hashCode();
        }
    }
}

