/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.api.IEnergySink;
import ic2.api.IEnergySource;
import ic2.common.EnergyNet;
import ic2.common.TileEntityBlock;
import ic2.platform.Platform;

public abstract class TileEntityTransformer
extends TileEntityBlock
implements IEnergySink,
IEnergySource {
    public int lowOutput;
    public int highOutput;
    public int maxStorage;
    public int energy = 0;
    public boolean redstone = false;
    public boolean addedToEnergyNet = false;

    public TileEntityTransformer(int low, int high, int max) {
        this.lowOutput = low;
        this.highOutput = high;
        this.maxStorage = max;
    }

    @Override
    public void a(ph nbttagcompound) {
        super.a(nbttagcompound);
        this.energy = nbttagcompound.f("energy");
    }

    @Override
    public void b(ph nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("energy", this.energy);
    }

    @Override
    public boolean canUpdate() {
        return Platform.isSimulating();
    }

    public void q_() {
        super.q_();
        this.updateRedstone();
        if (this.redstone) {
            if (this.energy >= this.highOutput) {
                this.energy -= this.highOutput - EnergyNet.getForWorld(this.k).emitEnergyFrom(this, this.highOutput);
            }
        } else {
            for (int i = 0; i < 4 && this.energy >= this.lowOutput; ++i) {
                this.energy -= this.lowOutput - EnergyNet.getForWorld(this.k).emitEnergyFrom(this, this.lowOutput);
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (Platform.isSimulating()) {
            EnergyNet.getForWorld(this.k).addTileEntity(this);
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (Platform.isSimulating() && this.addedToEnergyNet) {
            EnergyNet.getForWorld(this.k).removeTileEntity(this);
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public void updateRedstone() {
        boolean red = this.k.x(this.l, this.m, this.n);
        if (red != this.redstone) {
            EnergyNet.getForWorld(this.k).removeTileEntity(this);
            this.addedToEnergyNet = false;
            this.redstone = red;
            EnergyNet.getForWorld(this.k).addTileEntity(this);
            this.addedToEnergyNet = true;
            this.setActive(this.redstone);
        }
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(qj emitter, Direction direction) {
        if (this.redstone) {
            return !this.facingMatchesDirection(direction);
        }
        return this.facingMatchesDirection(direction);
    }

    @Override
    public boolean emitsEnergyTo(qj receiver, Direction direction) {
        if (this.redstone) {
            return this.facingMatchesDirection(direction);
        }
        return !this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(Direction direction) {
        return direction.toSideValue() == this.getFacing();
    }

    @Override
    public int getMaxEnergyOutput() {
        if (this.redstone) {
            return this.highOutput;
        }
        return this.lowOutput;
    }

    @Override
    public boolean demandsEnergy() {
        return this.energy < this.maxStorage;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (this.redstone && amount > this.lowOutput || !this.redstone && amount > this.highOutput && this.highOutput != 2048) {
            mod_IC2.explodeMachineAt(this.k, this.l, this.m, this.n);
            return 0;
        }
        int need = amount;
        if (this.energy + amount >= this.maxStorage + this.highOutput) {
            need = this.maxStorage + this.highOutput - this.energy - 1;
        }
        this.energy += need;
        return amount - need;
    }

    @Override
    public boolean wrenchCanSetFacing(ih entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short side) {
        if (this.addedToEnergyNet) {
            EnergyNet.getForWorld(this.k).removeTileEntity(this);
        }
        this.addedToEnergyNet = false;
        super.setFacing(side);
        EnergyNet.getForWorld(this.k).addTileEntity(this);
        this.addedToEnergyNet = true;
    }
}

