/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.api.INetworkTileEntityEventListener;
import ic2.common.AudioPosition;
import ic2.common.IC2Achievements;
import ic2.common.Ic2Items;
import ic2.common.PositionSpec;
import ic2.common.TileEntityBlock;
import ic2.common.TileEntityElectricBlock;
import ic2.platform.AudioManager;
import ic2.platform.AudioSource;
import ic2.platform.NetworkManager;
import ic2.platform.Platform;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class TileEntityTeleporter
extends TileEntityBlock
implements INetworkTileEntityEventListener {
    public boolean targetSet = false;
    public int targetX;
    public int targetY;
    public int targetZ;
    private AudioSource audioSource = null;
    private static final int EventTeleport = 0;

    @Override
    public void a(ph nbttagcompound) {
        super.a(nbttagcompound);
        this.targetSet = nbttagcompound.o("targetSet");
        this.targetX = nbttagcompound.f("targetX");
        this.targetY = nbttagcompound.f("targetY");
        this.targetZ = nbttagcompound.f("targetZ");
    }

    @Override
    public void b(ph nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("targetSet", this.targetSet);
        nbttagcompound.a("targetX", this.targetX);
        nbttagcompound.a("targetY", this.targetY);
        nbttagcompound.a("targetZ", this.targetZ);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void q_() {
        super.q_();
        if (Platform.isSimulating()) {
            if (this.k.x(this.l, this.m, this.n) && this.targetSet) {
                my chunk = Platform.getOrLoadChunk(this.k, this.targetX >> 4, this.targetZ >> 4);
                if (chunk == null || chunk.a(this.targetX & 0xF, this.targetY, this.targetZ & 0xF) != Ic2Items.teleporter.c || chunk.c(this.targetX & 0xF, this.targetY, this.targetZ & 0xF) != Ic2Items.teleporter.h()) {
                    this.targetSet = false;
                    this.setActive(false);
                } else {
                    this.setActive(true);
                    List entitiesNearby = this.k.a(tv.class, fp.a((double)(this.l - 1), (double)this.m, (double)(this.n - 1), (double)(this.l + 2), (double)(this.m + 3), (double)(this.n + 2)));
                    if (!entitiesNearby.isEmpty()) {
                        double minDistanceSquared = Double.MAX_VALUE;
                        tv closestEntity = null;
                        for (tv entity : entitiesNearby) {
                            double distSquared;
                            if (entity.bh != null || !((distSquared = ((double)this.l - entity.bm) * ((double)this.l - entity.bm) + ((double)(this.m + 1) - entity.bn) * ((double)(this.m + 1) - entity.bn) + ((double)this.n - entity.bo) * ((double)this.n - entity.bo)) < minDistanceSquared)) continue;
                            minDistanceSquared = distSquared;
                            closestEntity = entity;
                        }
                        this.teleport(closestEntity);
                    }
                }
            } else {
                this.setActive(false);
            }
        }
        if (Platform.isRendering() && this.getActive()) {
            this.spawnBlueParticles(2, this.l, this.m, this.n);
        }
    }

    @Override
    public void onUnloaded() {
        if (Platform.isRendering() && this.audioSource != null) {
            AudioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public void teleport(tv user) {
        double distance = Math.sqrt((this.l - this.targetX) * (this.l - this.targetX) + (this.m - this.targetY) * (this.m - this.targetY) + (this.n - this.targetZ) * (this.n - this.targetZ));
        int weight = this.getWeightOf(user);
        if (weight == 0) {
            return;
        }
        int energyCost = (int)((double)weight * Math.pow(distance + 10.0, 0.7) * 5.0);
        if (energyCost > this.getAvailableEnergy()) {
            return;
        }
        this.consumeEnergy(energyCost);
        Platform.teleportTo(user, (double)this.targetX + 0.5, (double)this.targetY + 1.5 + user.W(), (double)this.targetZ + 0.5, user.bs, user.bt);
        NetworkManager.initiateTileEntityEvent(this, 0, true);
        if (user instanceof ih && distance >= 1000.0) {
            IC2Achievements.issueAchievement((ih)user, "teleportFarAway");
        }
    }

    public void spawnBlueParticles(int n, int x, int y, int z) {
        for (int i = 0; i < n; ++i) {
            this.k.a("reddust", (double)((float)x + this.k.r.nextFloat()), (double)((float)(y + 1) + this.k.r.nextFloat()), (double)((float)z + this.k.r.nextFloat()), -1.0, 0.0, 1.0);
            this.k.a("reddust", (double)((float)x + this.k.r.nextFloat()), (double)((float)(y + 2) + this.k.r.nextFloat()), (double)((float)z + this.k.r.nextFloat()), -1.0, 0.0, 1.0);
        }
    }

    public void consumeEnergy(int energy) {
        LinkedList<TileEntityElectricBlock> energySources = new LinkedList<TileEntityElectricBlock>();
        for (Direction direction : Direction.values()) {
            qj target = direction.applyToTileEntity(this);
            if (!(target instanceof TileEntityElectricBlock)) continue;
            TileEntityElectricBlock energySource = (TileEntityElectricBlock)target;
            if (energySource.energy <= 0) continue;
            energySources.add(energySource);
        }
        while (energy > 0) {
            int drain = (energy + energySources.size() - 1) / energySources.size();
            Iterator it2 = energySources.iterator();
            while (it2.hasNext()) {
                TileEntityElectricBlock energySource = (TileEntityElectricBlock)it2.next();
                if (drain > energy) {
                    drain = energy;
                }
                if (energySource.energy <= drain) {
                    energy -= energySource.energy;
                    energySource.energy = 0;
                    it2.remove();
                    continue;
                }
                energy -= drain;
                energySource.energy -= drain;
            }
        }
    }

    public int getAvailableEnergy() {
        int energy = 0;
        for (Direction direction : Direction.values()) {
            qj target = direction.applyToTileEntity(this);
            if (!(target instanceof TileEntityElectricBlock)) continue;
            energy += ((TileEntityElectricBlock)target).energy;
        }
        return energy;
    }

    public int getWeightOf(tv user) {
        int weight = 0;
        tv ce = user;
        while (ce != null) {
            if (ce instanceof ja) {
                kp is = ((ja)ce).a;
                weight += 100 * is.a / is.b();
            } else if (ce instanceof br || ce instanceof aaw || ce instanceof hi) {
                weight += 100;
            } else if (ce instanceof ih) {
                weight += 1000;
                if (mod_IC2.enableTeleporterInventory) {
                    int i;
                    ko inv = ((ih)ce).k;
                    for (i = 0; i < inv.a.length; ++i) {
                        if (inv.a[i] == null) continue;
                        weight += 100 * inv.a[i].a / inv.a[i].b();
                    }
                    for (i = 0; i < inv.b.length; ++i) {
                        if (inv.b[i] == null) continue;
                        weight += 100;
                    }
                }
            } else if (ce instanceof cg) {
                weight += 2500;
            } else if (ce instanceof vl) {
                weight += 10000;
            } else if (ce instanceof ka) {
                weight += 500;
            }
            ce = ce.bg;
        }
        return weight;
    }

    public void setTarget(int x, int y, int z) {
        this.targetSet = true;
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        NetworkManager.updateTileEntityField(this, "targetX");
        NetworkManager.updateTileEntityField(this, "targetY");
        NetworkManager.updateTileEntityField(this, "targetZ");
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>(3);
        ret.add("targetX");
        ret.add("targetY");
        ret.add("targetZ");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = AudioManager.createSource(this, PositionSpec.Center, "Machines/Teleporter/TeleChargedLoop.ogg", true, false, AudioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public void onNetworkEvent(int event) {
        switch (event) {
            case 0: {
                AudioManager.playOnce(this, PositionSpec.Center, "Machines/Teleporter/TeleUse.ogg", true, AudioManager.defaultVolume);
                AudioManager.playOnce(new AudioPosition(this.k, (float)this.targetX + 0.5f, (float)this.targetY + 0.5f, (float)this.targetZ + 0.5f), PositionSpec.Center, "Machines/Teleporter/TeleUse.ogg", true, AudioManager.defaultVolume);
                this.spawnBlueParticles(20, this.l, this.m, this.n);
                this.spawnBlueParticles(20, this.targetX, this.targetY, this.targetZ);
                break;
            }
            default: {
                Platform.displayError("An unknown event type was received over multiplayer.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: event ID " + event + ", tile entity below)\n" + "T: " + this + " (" + this.l + "," + this.m + "," + this.n + ")");
            }
        }
    }
}

