/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.api.IEnergySource;
import ic2.api.IReactor;
import ic2.common.ContainerIC2;
import ic2.common.ContainerNuclearReactor;
import ic2.common.EnergyNet;
import ic2.common.ExplosionIC2;
import ic2.common.IC2DamageSource;
import ic2.common.IHasGui;
import ic2.common.Ic2Items;
import ic2.common.PositionSpec;
import ic2.common.TileEntityMachine;
import ic2.common.TileEntityReactorChamber;
import ic2.platform.AudioManager;
import ic2.platform.AudioSource;
import ic2.platform.NetworkManager;
import ic2.platform.Platform;
import java.util.List;
import java.util.Random;

public class TileEntityNuclearReactor
extends TileEntityMachine
implements IEnergySource,
IHasGui,
IReactor {
    public static Random randomizer = new Random();
    public short output = 0;
    public int updateTicker = randomizer.nextInt(this.getTickRate());
    public int heat = 0;
    public boolean addedToEnergyNet = false;
    public AudioSource audioSourceMain;
    public AudioSource audioSourceGeiger;
    private short lastOutput = 0;

    public TileEntityNuclearReactor() {
        super(54);
    }

    @Override
    public void onUnloaded() {
        if (Platform.isSimulating() && this.addedToEnergyNet) {
            EnergyNet.getForWorld(this.k).removeTileEntity(this);
            this.addedToEnergyNet = false;
        }
        if (Platform.isRendering()) {
            AudioManager.removeSources(this);
            this.audioSourceMain = null;
            this.audioSourceGeiger = null;
        }
        super.onUnloaded();
    }

    @Override
    public String e() {
        return "Nuclear Reactor";
    }

    @Override
    public void a(ph nbttagcompound) {
        super.a(nbttagcompound);
        try {
            this.heat = nbttagcompound.f("heat");
        }
        catch (Exception e) {
            this.heat = nbttagcompound.e("heat");
        }
        this.output = nbttagcompound.e("output");
    }

    @Override
    public void b(ph nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("heat", this.heat);
        nbttagcompound.a("output", this.output);
    }

    @Override
    public void q_() {
        super.q_();
        if (!this.addedToEnergyNet) {
            EnergyNet.getForWorld(this.k).addTileEntity(this);
            this.addedToEnergyNet = true;
        }
        this.sendEnergy(this.output);
        if (this.updateTicker++ % this.getTickRate() != 0) {
            return;
        }
        if (!this.k.a(this.l, this.m, this.n, 2)) {
            this.output = 0;
        } else {
            this.dropAllUnfittingStuff();
            if (this.heat > 0) {
                this.heat -= this.coolReactorFromOutside();
                if (this.heat <= 0) {
                    this.heat = 0;
                } else if (this.calculateHeatEffects()) {
                    return;
                }
            }
            this.output = 0;
            this.processChambers();
            this.setActive(this.heat >= 1000 || this.output > 0);
            this.G_();
        }
        NetworkManager.updateTileEntityField(this, "output");
    }

    public void dropAllUnfittingStuff() {
        short size = this.getReactorSize();
        for (short x = 0; x < 9; ++x) {
            for (int y = 0; y < 6; ++y) {
                kp stack = this.getMatrixCoord(x, y);
                if (stack == null) continue;
                if (stack.a <= 0) {
                    this.setMatrixCoord(x, y, null);
                    continue;
                }
                if (x < size && TileEntityNuclearReactor.isUsefulItem(stack)) continue;
                this.eject(stack);
                this.setMatrixCoord(x, y, null);
            }
        }
    }

    public void eject(kp drop) {
        if (!Platform.isSimulating() || drop == null) {
            return;
        }
        float f = 0.7f;
        double d = (double)(this.k.r.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(this.k.r.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(this.k.r.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        ja entityitem = new ja(this.k, (double)this.l + d, (double)this.m + d1, (double)this.n + d2, drop);
        entityitem.c = 10;
        this.k.b((tv)entityitem);
    }

    public static boolean isUsefulItem(kp item) {
        if (item == null) {
            return false;
        }
        int id2 = item.c;
        return id2 == Ic2Items.uraniumCell.c || id2 == Ic2Items.coolingCell.c || id2 == Ic2Items.integratedReactorPlating.c || id2 == vz.aT.bO || id2 == id.aw.bP || id2 == id.ax.bP || id2 == id.av.bP || id2 == Ic2Items.integratedHeatDisperser.c || id2 == Ic2Items.depletedIsotopeCell.c || id2 == Ic2Items.reEnrichedUraniumCell.c || id2 == Ic2Items.nearDepletedUraniumCell.c;
    }

    public int coolReactorFromOutside() {
        int cool = 1;
        int air = 0;
        for (int x = this.l - 1; x <= this.l + 1; ++x) {
            for (int y = this.m - 1; y <= this.m + 1; ++y) {
                for (int z = this.n - 1; z <= this.n + 1; ++z) {
                    if (this.k.a(x, y, z) == Ic2Items.reactorChamber.c) {
                        cool += 2;
                    }
                    if (this.k.d(x, y, z) == na.g) {
                        ++cool;
                    }
                    if (this.k.a(x, y, z) == 0) {
                        ++air;
                    }
                    if (this.k.a(x, y, z) == vz.ar.bO) {
                        air -= 2;
                    }
                    if (this.k.d(x, y, z) != na.h) continue;
                    cool -= 3;
                }
            }
        }
        if ((cool += air / 4) < 0) {
            return 0;
        }
        return cool;
    }

    public boolean calculateHeatEffects() {
        na mat;
        int id2;
        int[] coord;
        if (this.heat < 4000 || !Platform.isSimulating() || mod_IC2.explosionPowerReactorMax <= 0.0f) {
            return false;
        }
        short size = this.getReactorSize();
        int maxHeat = this.getMaxHeat();
        float power = (float)this.heat / (float)maxHeat;
        if (power >= 1.0f) {
            this.explode();
            return true;
        }
        if (power >= 0.85f && this.k.r.nextFloat() <= 4.0f * (power - 0.7f) && (coord = this.getRandCoord(2)) != null) {
            id2 = this.k.a(coord[0], coord[1], coord[2]);
            if (id2 == 0) {
                this.k.e(coord[0], coord[1], coord[2], vz.ar.bO);
            } else {
                mat = vz.m[id2].cd;
                if (id2 != vz.z.bO) {
                    if (mat == na.e || mat == na.f || mat == na.h || mat == na.c || mat == na.y) {
                        this.k.b(coord[0], coord[1], coord[2], vz.C.bO, 15);
                    } else {
                        this.k.e(coord[0], coord[1], coord[2], vz.ar.bO);
                    }
                }
            }
        }
        if (power >= 0.7f) {
            List list1 = this.k.a(ne.class, fp.a((double)(this.l - 3), (double)(this.m - 3), (double)(this.n - 3), (double)(this.l + 4), (double)(this.m + 4), (double)(this.n + 4)));
            for (int l = 0; l < list1.size(); ++l) {
                tv ent = (tv)list1.get(l);
                ent.a((rq)IC2DamageSource.radiation, 1);
            }
        }
        if (power >= 0.5f && (coord = this.getRandCoord(2)) != null && (id2 = this.k.a(coord[0], coord[1], coord[2])) > 0 && vz.m[id2].cd == na.g) {
            this.k.e(coord[0], coord[1], coord[2], 0);
        }
        if (power >= 0.4f && this.k.r.nextFloat() <= 1.5f * (power - 0.4f) && (coord = this.getRandCoord(2)) != null && (id2 = this.k.a(coord[0], coord[1], coord[2])) > 0 && ((mat = vz.m[id2].cd) == na.d || mat == na.i || mat == na.m)) {
            this.k.e(coord[0], coord[1], coord[2], vz.ar.bO);
        }
        return false;
    }

    public int[] getRandCoord(int radius) {
        if (radius <= 0) {
            return null;
        }
        int[] c = new int[]{this.l + this.k.r.nextInt(2 * radius + 1) - radius, this.m + this.k.r.nextInt(2 * radius + 1) - radius, this.n + this.k.r.nextInt(2 * radius + 1) - radius};
        if (c[0] == this.l && c[1] == this.m && c[2] == this.n) {
            return null;
        }
        return c;
    }

    public void processChambers() {
        int size = this.getReactorSize();
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < size; ++x) {
                this.processChamber(x, y);
            }
        }
    }

    public void processChamber(int x, int y) {
        if (this.getMatrixCoord(x, y) == null) {
            return;
        }
        int id2 = this.getMatrixCoord((int)x, (int)y).c;
        if (id2 == Ic2Items.coolingCell.c && this.getMatrixCoord(x, y).h() > 0) {
            this.damageReactorItem(this.getMatrixCoord(x, y), -1);
        }
        if (id2 == Ic2Items.integratedReactorPlating.c && this.getMatrixCoord(x, y).h() > 0 && this.k.r.nextInt(10) == 0) {
            this.damageReactorItem(this.getMatrixCoord(x, y), -1);
        }
        if (id2 == Ic2Items.nearDepletedUraniumCell.c || id2 == Ic2Items.depletedIsotopeCell.c || id2 == Ic2Items.reEnrichedUraniumCell.c) {
            ++this.heat;
        }
        if (id2 == id.aw.bP && this.heat > 4000) {
            this.heat -= 250;
            this.getMatrixCoord((int)x, (int)y).c = id.av.bP;
        }
        if (id2 == id.ax.bP) {
            this.heat += 2000;
            this.getMatrixCoord((int)x, (int)y).c = id.av.bP;
        }
        if (id2 == vz.aT.bO && this.heat > 300) {
            this.heat -= 300;
            --this.getMatrixCoord((int)x, (int)y).a;
            if (this.getMatrixCoord((int)x, (int)y).a <= 0) {
                this.setMatrixCoord(x, y, null);
            }
        }
        if (id2 == Ic2Items.integratedHeatDisperser.c) {
            this.disperseHeat(x, y);
        }
        if (id2 == Ic2Items.uraniumCell.c && this.produceEnergy()) {
            this.generateEnergy(x, y);
        }
    }

    public void disperseHeat(int x, int y) {
        this.switchHeat(x, y, x - 1, y);
        this.switchHeat(x, y, x + 1, y);
        this.switchHeat(x, y, x, y - 1);
        this.switchHeat(x, y, x, y + 1);
        int rebalance = (this.getMatrixCoord(x, y).h() - this.heat + 1) / 2;
        if (rebalance > 0) {
            if (rebalance > 25) {
                rebalance = 25;
            }
            this.heat += rebalance;
            this.damageReactorItem(this.getMatrixCoord(x, y), -1 * rebalance);
        } else {
            if ((rebalance *= -1) > 25) {
                rebalance = 25;
            }
            this.heat -= rebalance;
            this.damageReactorItem(this.getMatrixCoord(x, y), rebalance);
        }
    }

    public void switchHeat(int x, int y, int x2, int y2) {
        int heat2;
        if (this.getMatrixCoord(x2, y2) == null) {
            return;
        }
        int id2 = this.getMatrixCoord((int)x2, (int)y2).c;
        if (id2 != Ic2Items.coolingCell.c && id2 != Ic2Items.integratedReactorPlating.c) {
            return;
        }
        int heat = this.getMatrixCoord(x, y).h();
        int rebalance = (heat - (heat2 = this.getMatrixCoord(x2, y2).h())) / 2;
        if (rebalance > 0) {
            if (rebalance > 6) {
                rebalance = 6;
            }
            this.getMatrixCoord(x, y).b(heat - rebalance);
            if (id2 == Ic2Items.coolingCell.c) {
                this.damageReactorItem(this.getMatrixCoord(x2, y2), rebalance);
            } else {
                this.spreadHeat(x2, y2, rebalance, false);
            }
        } else {
            if ((rebalance *= -1) > 6) {
                rebalance = 6;
            }
            this.damageReactorItem(this.getMatrixCoord(x, y), rebalance);
            this.getMatrixCoord(x2, y2).b(heat2 - rebalance);
        }
    }

    public void generateEnergy(int x, int y) {
        int pulses = 1 + this.isUranium(x + 1, y) + this.isUranium(x - 1, y) + this.isUranium(x, y + 1) + this.isUranium(x, y - 1);
        this.output = (short)(this.output + pulses * TileEntityNuclearReactor.pulsePower());
        pulses += this.enrichDepleted(x + 1, y) + this.enrichDepleted(x - 1, y) + this.enrichDepleted(x, y + 1) + this.enrichDepleted(x, y - 1);
        while (pulses > 0) {
            int genHeat;
            int takers = this.canTakeHeat(x + 1, y, true, true) + this.canTakeHeat(x - 1, y, true, true) + this.canTakeHeat(x, y + 1, true, true) + this.canTakeHeat(x, y - 1, true, true);
            switch (takers) {
                case 2: {
                    genHeat = 4;
                    break;
                }
                case 3: {
                    genHeat = 2;
                    break;
                }
                case 4: {
                    genHeat = 1;
                    break;
                }
                default: {
                    genHeat = 10;
                }
            }
            if (takers == 0) {
                this.heat += genHeat;
            } else {
                this.giveHeatTo(x + 1, y, genHeat);
                this.giveHeatTo(x - 1, y, genHeat);
                this.giveHeatTo(x, y + 1, genHeat);
                this.giveHeatTo(x, y - 1, genHeat);
            }
            --pulses;
        }
        if (this.getMatrixCoord(x, y).h() == 9999 && this.k.r.nextInt(3) == 0) {
            this.setMatrixCoord(x, y, Ic2Items.nearDepletedUraniumCell.j());
        } else {
            this.damageReactorItem(this.getMatrixCoord(x, y), 1);
        }
    }

    public int isUranium(int x, int y) {
        if (this.getMatrixCoord(x, y) != null && this.getMatrixCoord((int)x, (int)y).c == Ic2Items.uraniumCell.c) {
            return 1;
        }
        return 0;
    }

    public int enrichDepleted(int x, int y) {
        if (this.getMatrixCoord(x, y) == null || this.getMatrixCoord((int)x, (int)y).c != Ic2Items.depletedIsotopeCell.c) {
            return 0;
        }
        int oneInChance = 8;
        if (this.heat >= 3000) {
            oneInChance = 4;
        }
        if (this.heat >= 6000) {
            oneInChance = 2;
        }
        if (this.heat >= 9000) {
            oneInChance = 1;
        }
        if (this.k.r.nextInt(oneInChance) != 0) {
            return 1;
        }
        if (this.getMatrixCoord(x, y).h() <= 0) {
            this.setMatrixCoord(x, y, Ic2Items.reEnrichedUraniumCell.j());
        } else {
            this.damageReactorItem(this.getMatrixCoord(x, y), -2);
        }
        return 1;
    }

    public int canTakeHeat(int x, int y, boolean countPlating, boolean countCooler) {
        if (this.getMatrixCoord(x, y) == null) {
            return 0;
        }
        int id2 = this.getMatrixCoord((int)x, (int)y).c;
        if (id2 == Ic2Items.coolingCell.c || id2 == Ic2Items.integratedReactorPlating.c && countPlating || id2 == Ic2Items.integratedHeatDisperser.c && countCooler) {
            return 1;
        }
        return 0;
    }

    public void giveHeatTo(int x, int y, int heat) {
        if (this.canTakeHeat(x, y, true, true) == 0) {
            return;
        }
        if (this.getMatrixCoord((int)x, (int)y).c == Ic2Items.integratedReactorPlating.c) {
            this.spreadHeat(x, y, heat, true);
        } else {
            this.damageReactorItem(this.getMatrixCoord(x, y), heat);
        }
    }

    public void spreadHeat(int x, int y, int heat, boolean primary) {
        int genHeat;
        int takers = this.canTakeHeat(x + 1, y, primary, false) + this.canTakeHeat(x - 1, y, primary, false) + this.canTakeHeat(x, y + 1, primary, false) + this.canTakeHeat(x, y - 1, primary, false);
        if (takers == 0) {
            this.damageReactorItem(this.getMatrixCoord(x, y), heat);
            return;
        }
        while (heat % takers != 0 && this.getMatrixCoord(x, y).h() > 0) {
            ++heat;
            this.damageReactorItem(this.getMatrixCoord(x, y), -1);
        }
        if ((heat -= (genHeat = heat / takers) * takers) > 0) {
            this.damageReactorItem(this.getMatrixCoord(x, y), heat);
        }
        this.spreadHeatTo(x - 1, y, genHeat, primary);
        this.spreadHeatTo(x + 1, y, genHeat, primary);
        this.spreadHeatTo(x, y - 1, genHeat, primary);
        this.spreadHeatTo(x, y + 1, genHeat, primary);
    }

    public void spreadHeatTo(int x, int y, int heat, boolean toPlatings) {
        if (this.canTakeHeat(x, y, toPlatings, false) == 0) {
            return;
        }
        if (this.getMatrixCoord((int)x, (int)y).c == Ic2Items.integratedReactorPlating.c && toPlatings) {
            this.spreadHeat(x, y, heat, false);
        } else {
            this.damageReactorItem(this.getMatrixCoord(x, y), heat);
        }
    }

    public boolean produceEnergy() {
        return !this.k.x(this.l, this.m, this.n);
    }

    public kp getMatrixCoord(int x, int y) {
        if (x < 0 || x >= 9 || y < 0 || y >= 6) {
            return null;
        }
        return super.g_(x + y * 9);
    }

    public void damageReactorItem(kp itemStack, int damage) {
        if (!itemStack.d()) {
            return;
        }
        itemStack.b(itemStack.h() + damage);
        if (itemStack.h() > itemStack.i()) {
            --itemStack.a;
            if (itemStack.a < 0) {
                itemStack.a = 0;
            }
            itemStack.b(0);
        }
    }

    @Override
    public kp g_(int i) {
        int x = i % 9;
        short size = this.getReactorSize();
        if (x >= size) {
            return this.getMatrixCoord(size - 1, i / 9);
        }
        return super.g_(i);
    }

    public void setMatrixCoord(int x, int y, kp stack) {
        if (x < 0 || x >= 9 || y < 0 || y >= 6) {
            return;
        }
        super.a(x + y * 9, stack);
    }

    @Override
    public void a(int i, kp itemstack) {
        int x = i % 9;
        short size = this.getReactorSize();
        if (x >= size) {
            this.setMatrixCoord(size - 1, i / 9, itemstack);
        } else {
            super.a(i, itemstack);
        }
    }

    public short getReactorSize() {
        if (this.k == null) {
            return 9;
        }
        short rows = 3;
        for (Direction direction : Direction.values()) {
            qj target = direction.applyToTileEntity(this);
            if (!(target instanceof TileEntityReactorChamber)) continue;
            rows = (short)(rows + 1);
        }
        return rows;
    }

    @Override
    public int getTickRate() {
        return 20;
    }

    public static int pulsePower() {
        return mod_IC2.energyGeneratorNuclear;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean emitsEnergyTo(qj receiver, Direction direction) {
        return true;
    }

    @Override
    public int getMaxEnergyOutput() {
        return 240 * TileEntityNuclearReactor.pulsePower();
    }

    public int sendEnergy(int send) {
        send = EnergyNet.getForWorld(this.k).emitEnergyFrom(this, send);
        if (send > 0 && this.k.b(this.l, this.m + 1, this.n) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.k.b(this.l, this.m + 1, this.n)).sendEnergy(send);
        }
        if (send > 0 && this.k.b(this.l, this.m - 1, this.n) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.k.b(this.l, this.m - 1, this.n)).sendEnergy(send);
        }
        if (send > 0 && this.k.b(this.l + 1, this.m, this.n) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.k.b(this.l + 1, this.m, this.n)).sendEnergy(send);
        }
        if (send > 0 && this.k.b(this.l - 1, this.m, this.n) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.k.b(this.l - 1, this.m, this.n)).sendEnergy(send);
        }
        if (send > 0 && this.k.b(this.l, this.m, this.n + 1) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.k.b(this.l, this.m, this.n + 1)).sendEnergy(send);
        }
        if (send > 0 && this.k.b(this.l, this.m, this.n - 1) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.k.b(this.l, this.m, this.n - 1)).sendEnergy(send);
        }
        return send;
    }

    @Override
    public ContainerIC2 getGuiContainer(ih entityPlayer) {
        return new ContainerNuclearReactor(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(ih entityPlayer) {
        return "GuiNuclearReactor";
    }

    @Override
    public void onGuiClosed(ih entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("output")) {
            if (this.output > 0) {
                if (this.lastOutput <= 0) {
                    if (this.audioSourceMain == null) {
                        this.audioSourceMain = AudioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/NuclearReactorLoop.ogg", true, false, AudioManager.defaultVolume);
                    }
                    if (this.audioSourceMain != null) {
                        this.audioSourceMain.play();
                    }
                }
                if (this.output < 40) {
                    if (this.lastOutput <= 0 || this.lastOutput >= 40) {
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.remove();
                        }
                        this.audioSourceGeiger = AudioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerLowEU.ogg", true, false, AudioManager.defaultVolume);
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.play();
                        }
                    }
                } else if (this.output < 80) {
                    if (this.lastOutput < 40 || this.lastOutput >= 80) {
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.remove();
                        }
                        this.audioSourceGeiger = AudioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerMedEU.ogg", true, false, AudioManager.defaultVolume);
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.play();
                        }
                    }
                } else if (this.output >= 80 && this.lastOutput < 80) {
                    if (this.audioSourceGeiger != null) {
                        this.audioSourceGeiger.remove();
                    }
                    this.audioSourceGeiger = AudioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerHighEU.ogg", true, false, AudioManager.defaultVolume);
                    if (this.audioSourceGeiger != null) {
                        this.audioSourceGeiger.play();
                    }
                }
            } else if (this.lastOutput > 0) {
                if (this.audioSourceMain != null) {
                    this.audioSourceMain.stop();
                }
                if (this.audioSourceGeiger != null) {
                    this.audioSourceGeiger.stop();
                }
            }
            this.lastOutput = this.output;
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public float getWrenchDropRate() {
        return 0.8f;
    }

    @Override
    public cf getPosition() {
        return new cf(this.l, this.m, this.n);
    }

    @Override
    public ge getWorld() {
        return this.k;
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(int heat) {
        this.heat = heat;
    }

    @Override
    public int addHeat(int amount) {
        this.heat += amount;
        return this.heat;
    }

    @Override
    public kp getItemAt(int x, int y) {
        return this.getMatrixCoord(x, y);
    }

    @Override
    public void setItemAt(int x, int y, kp item) {
        this.setMatrixCoord(x, y, item);
    }

    @Override
    public void explode() {
        float boomPower = 10.0f;
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < this.getReactorSize(); ++x) {
                if (this.getMatrixCoord(x, y) != null && this.getMatrixCoord((int)x, (int)y).c == Ic2Items.uraniumCell.c) {
                    boomPower += 3.0f;
                    continue;
                }
                if (this.getMatrixCoord(x, y) == null || this.getMatrixCoord((int)x, (int)y).c != Ic2Items.integratedReactorPlating.c) continue;
                boomPower -= 1.0f;
            }
        }
        if (boomPower > mod_IC2.explosionPowerReactorMax) {
            boomPower = mod_IC2.explosionPowerReactorMax;
        }
        this.k.e(this.l, this.m, this.n, 0);
        ExplosionIC2 explosion = new ExplosionIC2(this.k, null, this.l, this.m, this.n, boomPower, 0.01f, 1.5f, IC2DamageSource.nuke);
        explosion.doExplosion();
    }

    @Override
    public int getMaxHeat() {
        int maxHeat = 10000;
        maxHeat += 1000 * (this.getReactorSize() - 3);
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < this.getReactorSize(); ++x) {
                if (this.getMatrixCoord(x, y) == null || this.getMatrixCoord((int)x, (int)y).c != Ic2Items.integratedReactorPlating.c) continue;
                maxHeat += 100;
            }
        }
        return maxHeat;
    }

    @Override
    public int getOutput() {
        return this.output;
    }
}

