/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import forge.ForgeHooks;
import forge.ISidedInventory;
import ic2.common.ContainerIC2;
import ic2.common.ContainerMiner;
import ic2.common.ElectricItem;
import ic2.common.IHasGui;
import ic2.common.Ic2Items;
import ic2.common.ItemElectricToolDDrill;
import ic2.common.ItemElectricToolDrill;
import ic2.common.ItemScanner;
import ic2.common.PositionSpec;
import ic2.common.StackUtil;
import ic2.common.TileEntityElecMachine;
import ic2.common.TileEntityPump;
import ic2.platform.AudioManager;
import ic2.platform.AudioSource;
import ic2.platform.Platform;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class TileEntityMiner
extends TileEntityElecMachine
implements IHasGui,
ISidedInventory {
    public int targetX = 0;
    public int targetY = -1;
    public int targetZ = 0;
    public short miningTicker = 0;
    public String stuckOn = null;
    private AudioSource audioSource;

    public TileEntityMiner() {
        super(4, 0, 1000, 32, mod_IC2.enableMinerLapotron ? 3 : 1);
    }

    @Override
    public void q_() {
        super.q_();
        boolean wasOperating = this.isOperating();
        boolean needsInvUpdate = false;
        if (this.isOperating()) {
            --this.energy;
            if (this.inventory[1] != null && id.d[this.inventory[1].c] instanceof ItemScanner) {
                this.energy -= ElectricItem.charge(this.inventory[1], this.energy, 2, false, false);
            }
            if (this.inventory[3] != null && (id.d[this.inventory[3].c] instanceof ItemElectricToolDrill || id.d[this.inventory[3].c] instanceof ItemElectricToolDDrill)) {
                this.energy -= ElectricItem.charge(this.inventory[3], this.energy, 1, false, false);
            }
        }
        if (this.energy <= this.maxEnergy) {
            needsInvUpdate = this.provideEnergy();
        }
        if (wasOperating) {
            needsInvUpdate = this.mine();
        } else if (this.inventory[3] == null) {
            if (this.energy >= 2 && this.canWithdraw()) {
                this.targetY = -1;
                this.miningTicker = (short)(this.miningTicker + 1);
                this.energy -= 2;
                if (this.miningTicker >= 20) {
                    this.miningTicker = 0;
                    needsInvUpdate = this.withdrawPipe();
                }
            } else if (this.isStuck()) {
                this.miningTicker = 0;
            }
        }
        this.setActive(this.isOperating());
        if (wasOperating != this.isOperating()) {
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.G_();
        }
    }

    @Override
    public void onUnloaded() {
        if (Platform.isRendering() && this.audioSource != null) {
            AudioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public void a(ph nbttagcompound) {
        super.a(nbttagcompound);
        this.targetX = nbttagcompound.f("targetX");
        this.targetY = nbttagcompound.f("targetY");
        this.targetZ = nbttagcompound.f("targetZ");
        this.miningTicker = nbttagcompound.e("miningTicker");
    }

    @Override
    public void b(ph nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("targetX", (int)((short)this.targetX));
        nbttagcompound.a("targetY", (int)((short)this.targetY));
        nbttagcompound.a("targetZ", (int)((short)this.targetZ));
        nbttagcompound.a("miningTicker", this.miningTicker);
    }

    public boolean mine() {
        if (this.targetY < 0) {
            this.aquireTarget();
            return false;
        }
        if (!this.canReachTarget(this.targetX, this.targetY, this.targetZ, true)) {
            int x = this.targetX - this.l;
            int z = this.targetZ - this.n;
            if (Math.abs(x) > Math.abs(z)) {
                this.targetX = x > 0 ? --this.targetX : ++this.targetX;
            } else {
                this.targetZ = z > 0 ? --this.targetZ : ++this.targetZ;
            }
            return false;
        }
        if (!this.canMine(this.k.a(this.targetX, this.targetY, this.targetZ), this.k.c(this.targetX, this.targetY, this.targetZ))) {
            int id2 = this.k.a(this.targetX, this.targetY, this.targetZ);
            if ((id2 == vz.A.bO || id2 == vz.B.bO || id2 == vz.C.bO || id2 == vz.D.bO) && this.isAnyPumpConnected()) {
                return false;
            }
            this.miningTicker = (short)-1;
            this.stuckOn = Platform.translateBlockName(vz.m[id2]);
            return false;
        }
        this.stuckOn = null;
        this.miningTicker = (short)(this.miningTicker + 1);
        --this.energy;
        if (this.inventory[3].c == Ic2Items.diamondDrill.c) {
            this.miningTicker = (short)(this.miningTicker + 3);
            this.energy -= 14;
        }
        if (this.miningTicker >= 200) {
            this.miningTicker = 0;
            this.mineBlock();
            return true;
        }
        return false;
    }

    public void mineBlock() {
        if (this.inventory[3].a() instanceof ItemElectricToolDrill) {
            ElectricItem.use(this.inventory[3], 50, null);
        } else if (this.inventory[3].a() instanceof ItemElectricToolDDrill) {
            ElectricItem.use(this.inventory[3], 80, null);
        }
        int id2 = this.k.a(this.targetX, this.targetY, this.targetZ);
        int meta = this.k.c(this.targetX, this.targetY, this.targetZ);
        boolean liquid = false;
        if (id2 == vz.A.bO || id2 == vz.B.bO || id2 == vz.C.bO || id2 == vz.D.bO) {
            liquid = true;
            if (meta != 0) {
                id2 = 0;
            }
        }
        if (id2 != 0) {
            if (!liquid) {
                vz ore = vz.m[id2];
                StackUtil.distributeDrop(this, ore.getBlockDropped(this.k, this.targetX, this.targetY, this.targetZ, meta, 0));
            } else {
                if (id2 == vz.A.bO || id2 == vz.B.bO) {
                    this.usePump(vz.B.bO);
                }
                if (id2 == vz.C.bO || id2 == vz.D.bO) {
                    this.usePump(vz.D.bO);
                }
            }
            this.k.e(this.targetX, this.targetY, this.targetZ, 0);
            this.energy -= 2 * (this.m - this.targetY);
        }
        if (this.targetX == this.l && this.targetZ == this.n) {
            this.k.b(this.targetX, this.targetY, this.targetZ, Ic2Items.miningPipe.c);
            --this.inventory[2].a;
            if (this.inventory[2].a == 0) {
                this.inventory[2] = null;
            }
            this.energy -= 10;
        }
        this.updateMineTip(this.targetY);
        this.targetY = -1;
    }

    public boolean withdrawPipe() {
        int y = this.getPipeTip();
        int blockId = this.k.a(this.l, y, this.n);
        if (blockId != 0) {
            StackUtil.distributeDrop(this, vz.m[blockId].getBlockDropped(this.k, this.l, y, this.n, this.k.c(this.l, y, this.n), 0));
            this.k.e(this.l, y, this.n, 0);
        }
        if (this.inventory[2] != null && this.inventory[2].c != Ic2Items.miningPipe.c && this.inventory[2].c < vz.m.length && vz.m[this.inventory[2].c] != null) {
            this.k.b(this.l, y, this.n, this.inventory[2].c, this.inventory[2].h());
            --this.inventory[2].a;
            if (this.inventory[2].a == 0) {
                this.inventory[2] = null;
            }
            this.updateMineTip(y + 1);
            return true;
        }
        this.updateMineTip(y + 1);
        return false;
    }

    public void updateMineTip(int low) {
        if (low == this.m) {
            return;
        }
        int x = this.l;
        int z = this.n;
        for (int y = this.m - 1; y > low; --y) {
            if (this.k.a(x, y, z) == Ic2Items.miningPipe.c) continue;
            this.k.e(x, y, z, Ic2Items.miningPipe.c);
        }
        this.k.e(x, low, z, Ic2Items.miningPipeTip.c);
    }

    public boolean canReachTarget(int x, int y, int z, boolean ignore) {
        if (this.l == x && this.n == z) {
            return true;
        }
        if (!ignore && !this.canPass(this.k.a(x, y, z))) {
            return false;
        }
        int xdif = x - this.l;
        int zdif = z - this.n;
        if (Math.abs(xdif) > Math.abs(zdif)) {
            x = xdif > 0 ? --x : ++x;
        } else {
            z = zdif > 0 ? --z : ++z;
        }
        return this.canReachTarget(x, y, z, false);
    }

    public void aquireTarget() {
        int y = this.getPipeTip();
        if (y >= this.m || this.inventory[1] == null || !(this.inventory[1].a() instanceof ItemScanner)) {
            this.setTarget(this.l, y - 1, this.n);
            return;
        }
        int scanrange = ((ItemScanner)this.inventory[1].a()).startLayerScan(this.inventory[1]);
        if (scanrange > 0) {
            for (int x = this.l - scanrange; x <= this.l + scanrange; ++x) {
                for (int z = this.n - scanrange; z <= this.n + scanrange; ++z) {
                    int m;
                    int n = this.k.a(x, y, z);
                    if ((!ItemScanner.isValuable(n, m = this.k.c(x, y, z)) || !this.canMine(n, m)) && (!this.isAnyPumpConnected() || this.k.c(x, y, z) != 0 || n != vz.C.bO && n != vz.D.bO)) continue;
                    this.setTarget(x, y, z);
                    return;
                }
            }
        }
        this.setTarget(this.l, y - 1, this.n);
    }

    public void setTarget(int x, int y, int z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    public int getPipeTip() {
        int y = this.m;
        while (this.k.a(this.l, y - 1, this.n) == Ic2Items.miningPipe.c || this.k.a(this.l, y - 1, this.n) == Ic2Items.miningPipeTip.c) {
            --y;
        }
        return y;
    }

    public boolean canPass(int id2) {
        return id2 == 0 || id2 == vz.A.bO || id2 == vz.B.bO || id2 == vz.C.bO || id2 == vz.D.bO || id2 == Ic2Items.miner.c || id2 == Ic2Items.miningPipe.c || id2 == Ic2Items.miningPipeTip.c;
    }

    public boolean isOperating() {
        return this.energy > 100 && this.canOperate();
    }

    public boolean canOperate() {
        if (this.inventory[2] == null || this.inventory[3] == null) {
            return false;
        }
        if (this.inventory[2].c != Ic2Items.miningPipe.c) {
            return false;
        }
        if (this.inventory[3].c != Ic2Items.miningDrill.c && this.inventory[3].c != Ic2Items.diamondDrill.c) {
            return false;
        }
        return !this.isStuck();
    }

    public boolean isStuck() {
        return this.miningTicker < 0;
    }

    public String getStuckOn() {
        return this.stuckOn;
    }

    public boolean canMine(int id2, int meta) {
        if (id2 == 0) {
            return true;
        }
        if (id2 == Ic2Items.miningPipe.c || id2 == Ic2Items.miningPipeTip.c || id2 == vz.au.bO) {
            return false;
        }
        if ((id2 == vz.A.bO || id2 == vz.B.bO || id2 == vz.C.bO || id2 == vz.D.bO) && this.isPumpConnected()) {
            return true;
        }
        vz block = vz.m[id2];
        if (block.getHardness(meta) < 0.0f) {
            return false;
        }
        if (block.a(meta, false) && block.cd.k()) {
            return true;
        }
        if (id2 == vz.W.bO) {
            return true;
        }
        if (this.inventory[3] != null && (this.inventory[3].c != Ic2Items.miningDrill.c || this.inventory[3].c != Ic2Items.diamondDrill.c)) {
            try {
                HashMap toolClasses = (HashMap)ModLoader.getPrivateValue(ForgeHooks.class, null, (String)"toolClasses");
                List tc = (List)toolClasses.get(this.inventory[3].c);
                if (tc == null) {
                    return this.inventory[3].b(block);
                }
                Object[] ta = tc.toArray();
                String cls = (String)ta[0];
                int hvl = (Integer)ta[1];
                HashMap toolHarvestLevels = (HashMap)ModLoader.getPrivateValue(ForgeHooks.class, null, (String)"toolHarvestLevels");
                Integer bhl = (Integer)toolHarvestLevels.get(Arrays.asList(block.bO, meta, cls));
                if (bhl == null) {
                    return this.inventory[3].b(block);
                }
                if (bhl > hvl) {
                    return false;
                }
                return this.inventory[3].b(block);
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    public boolean canWithdraw() {
        return this.k.a(this.l, this.m - 1, this.n) == Ic2Items.miningPipe.c || this.k.a(this.l, this.m - 1, this.n) == Ic2Items.miningPipeTip.c;
    }

    public boolean isPumpConnected() {
        if (this.k.b(this.l, this.m + 1, this.n) instanceof TileEntityPump && ((TileEntityPump)this.k.b(this.l, this.m + 1, this.n)).canHarvest()) {
            return true;
        }
        if (this.k.b(this.l, this.m - 1, this.n) instanceof TileEntityPump && ((TileEntityPump)this.k.b(this.l, this.m - 1, this.n)).canHarvest()) {
            return true;
        }
        if (this.k.b(this.l + 1, this.m, this.n) instanceof TileEntityPump && ((TileEntityPump)this.k.b(this.l + 1, this.m, this.n)).canHarvest()) {
            return true;
        }
        if (this.k.b(this.l - 1, this.m, this.n) instanceof TileEntityPump && ((TileEntityPump)this.k.b(this.l - 1, this.m, this.n)).canHarvest()) {
            return true;
        }
        if (this.k.b(this.l, this.m, this.n + 1) instanceof TileEntityPump && ((TileEntityPump)this.k.b(this.l, this.m, this.n + 1)).canHarvest()) {
            return true;
        }
        return this.k.b(this.l, this.m, this.n - 1) instanceof TileEntityPump && ((TileEntityPump)this.k.b(this.l, this.m, this.n - 1)).canHarvest();
    }

    public boolean isAnyPumpConnected() {
        if (this.k.b(this.l, this.m + 1, this.n) instanceof TileEntityPump) {
            return true;
        }
        if (this.k.b(this.l, this.m - 1, this.n) instanceof TileEntityPump) {
            return true;
        }
        if (this.k.b(this.l + 1, this.m, this.n) instanceof TileEntityPump) {
            return true;
        }
        if (this.k.b(this.l - 1, this.m, this.n) instanceof TileEntityPump) {
            return true;
        }
        if (this.k.b(this.l, this.m, this.n + 1) instanceof TileEntityPump) {
            return true;
        }
        return this.k.b(this.l, this.m, this.n - 1) instanceof TileEntityPump;
    }

    public void usePump(int id2) {
        if (this.k.b(this.l, this.m + 1, this.n) instanceof TileEntityPump && ((TileEntityPump)this.k.b(this.l, this.m + 1, this.n)).canHarvest()) {
            ((TileEntityPump)this.k.b(this.l, this.m + 1, this.n)).pumpThis(id2);
            return;
        }
        if (this.k.b(this.l, this.m - 1, this.n) instanceof TileEntityPump && ((TileEntityPump)this.k.b(this.l, this.m - 1, this.n)).canHarvest()) {
            ((TileEntityPump)this.k.b(this.l, this.m - 1, this.n)).pumpThis(id2);
            return;
        }
        if (this.k.b(this.l + 1, this.m, this.n) instanceof TileEntityPump && ((TileEntityPump)this.k.b(this.l + 1, this.m, this.n)).canHarvest()) {
            ((TileEntityPump)this.k.b(this.l + 1, this.m, this.n)).pumpThis(id2);
            return;
        }
        if (this.k.b(this.l - 1, this.m, this.n) instanceof TileEntityPump && ((TileEntityPump)this.k.b(this.l - 1, this.m, this.n)).canHarvest()) {
            ((TileEntityPump)this.k.b(this.l - 1, this.m, this.n)).pumpThis(id2);
            return;
        }
        if (this.k.b(this.l, this.m, this.n + 1) instanceof TileEntityPump && ((TileEntityPump)this.k.b(this.l, this.m, this.n + 1)).canHarvest()) {
            ((TileEntityPump)this.k.b(this.l, this.m, this.n + 1)).pumpThis(id2);
            return;
        }
        if (this.k.b(this.l, this.m, this.n - 1) instanceof TileEntityPump && ((TileEntityPump)this.k.b(this.l, this.m, this.n - 1)).canHarvest()) {
            ((TileEntityPump)this.k.b(this.l, this.m, this.n - 1)).pumpThis(id2);
            return;
        }
    }

    @Override
    public String e() {
        return "Miner";
    }

    public int gaugeEnergyScaled(int i) {
        if (this.energy <= 0) {
            return 0;
        }
        int r = this.energy * i / 1000;
        if (r > i) {
            r = i;
        }
        return r;
    }

    @Override
    public ContainerIC2 getGuiContainer(ih entityPlayer) {
        return new ContainerMiner(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(ih entityPlayer) {
        return "GuiMiner";
    }

    @Override
    public void onGuiClosed(ih entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = AudioManager.createSource(this, PositionSpec.Center, "Machines/MinerOp.ogg", true, false, AudioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    public int getStartInventorySide(int side) {
        int backSide;
        int frontSide;
        int rightSide;
        int leftSide;
        switch (this.getFacing()) {
            case 2: {
                leftSide = 4;
                rightSide = 5;
                frontSide = 3;
                backSide = 2;
                break;
            }
            case 3: {
                leftSide = 5;
                rightSide = 4;
                frontSide = 2;
                backSide = 3;
                break;
            }
            case 4: {
                leftSide = 3;
                rightSide = 2;
                frontSide = 5;
                backSide = 4;
                break;
            }
            default: {
                leftSide = 2;
                rightSide = 3;
                frontSide = 4;
                backSide = 5;
            }
        }
        if (side == leftSide || side == frontSide) {
            return 3;
        }
        if (side == rightSide || side == backSide) {
            return 1;
        }
        switch (side) {
            case 0: {
                return 0;
            }
        }
        return 2;
    }

    public int getSizeInventorySide(int side) {
        return 1;
    }
}

