/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.INetworkDataProvider;
import ic2.api.INetworkUpdateListener;
import ic2.api.IWrenchable;
import ic2.common.ITickCallback;
import ic2.platform.NetworkManager;
import ic2.platform.Platform;
import ic2.platform.TextureIndex;
import java.util.List;
import java.util.Vector;

public class TileEntityBlock
extends qj
implements INetworkDataProvider,
INetworkUpdateListener,
IWrenchable {
    private boolean active = false;
    private short facing = 0;
    public boolean prevActive = false;
    public short prevFacing = 0;
    private boolean loaded = false;

    public void m() {
        super.m();
        if (!this.loaded) {
            mod_IC2.addSingleTickCallback(this.k, new ITickCallback(){

                @Override
                public void tickCallback(ge world) {
                    if (!TileEntityBlock.this.l() && TileEntityBlock.this.k != null) {
                        TileEntityBlock.this.onLoaded();
                    } else {
                        System.out.println("[IC2] " + TileEntityBlock.this + " (" + TileEntityBlock.this.l + "," + TileEntityBlock.this.m + "," + TileEntityBlock.this.n + ") was not added, isInvalid=" + TileEntityBlock.this.l() + ", worldObj=" + TileEntityBlock.this.k);
                    }
                }
            });
        }
    }

    public void j() {
        super.j();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onLoaded() {
        if (!Platform.isSimulating()) {
            NetworkManager.requestInitialData(this);
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        this.loaded = false;
    }

    public void a(ph nbttagcompound) {
        super.a(nbttagcompound);
        this.prevFacing = this.facing = nbttagcompound.e("facing");
    }

    public void b(ph nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("facing", this.facing);
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (this.prevActive != active) {
            NetworkManager.updateTileEntityField(this, "active");
        }
        this.prevActive = active;
    }

    public void setActiveWithoutNotify(boolean active) {
        this.active = active;
        this.prevActive = active;
    }

    @Override
    public short getFacing() {
        return this.facing;
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>(2);
        ret.add("active");
        ret.add("facing");
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.active || field.equals("facing") && this.prevFacing != this.facing) {
            int blockId = this.k.a(this.l, this.m, this.n);
            if (blockId < vz.m.length && vz.m[blockId] != null) {
                vz block = vz.m[blockId];
                boolean newActive = this.active;
                short newFacing = this.facing;
                this.active = this.prevActive;
                this.facing = this.prevFacing;
                int[] textureIndex = new int[6];
                for (int side = 0; side < 6; ++side) {
                    textureIndex[side] = Platform.getBlockTexture(block, this.k, this.l, this.m, this.n, side);
                }
                this.active = newActive;
                this.facing = newFacing;
                boolean found = false;
                for (int side = 0; side < 6; ++side) {
                    int newTextureIndex = Platform.getBlockTexture(block, this.k, this.l, this.m, this.n, side);
                    if (textureIndex[side] == newTextureIndex || TextureIndex.get(blockId, textureIndex[side]) == TextureIndex.get(blockId, newTextureIndex)) continue;
                    this.k.j(this.l, this.m, this.n);
                    found = true;
                    break;
                }
            } else {
                System.out.println("[IC2] Invalid TE at " + this.l + "/" + this.m + "/" + this.n + ", no corresponding block");
            }
            this.prevActive = this.active;
            this.prevFacing = this.facing;
        }
    }

    @Override
    public boolean wrenchCanSetFacing(ih entityPlayer, int side) {
        return false;
    }

    @Override
    public void setFacing(short facing) {
        this.facing = facing;
        if (this.prevFacing != facing) {
            NetworkManager.updateTileEntityField(this, "facing");
        }
        this.prevFacing = facing;
    }

    @Override
    public boolean wrenchCanRemove(ih entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }
}

