/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.IWrenchable;
import ic2.common.ItemIC2;
import ic2.common.PositionSpec;
import ic2.common.StackUtil;
import ic2.common.TileEntityTerra;
import ic2.platform.AudioManager;
import ic2.platform.Keyboard;
import ic2.platform.Platform;
import java.util.ArrayList;
import java.util.logging.Level;

public class ItemToolWrench
extends ItemIC2 {
    public ItemToolWrench(int id2, int index) {
        super(id2, index);
        this.f(160);
        this.e(1);
    }

    public boolean canTakeDamage(kp stack, int amount) {
        return true;
    }

    public boolean onItemUseFirst(kp itemstack, ih entityPlayer, ge world, int x, int y, int z, int side) {
        TileEntityTerra tileEntityTerra;
        if (!this.canTakeDamage(itemstack, 1)) {
            return false;
        }
        int blockId = world.a(x, y, z);
        int metaData = world.c(x, y, z);
        qj tileEntity = world.b(x, y, z);
        if (tileEntity instanceof TileEntityTerra && (tileEntityTerra = (TileEntityTerra)tileEntity).ejectBlueprint()) {
            if (Platform.isSimulating()) {
                this.damage(itemstack, 1, entityPlayer);
            }
            if (Platform.isRendering()) {
                AudioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, AudioManager.defaultVolume);
            }
            return true;
        }
        if (tileEntity instanceof IWrenchable) {
            IWrenchable wrenchable = (IWrenchable)tileEntity;
            if (Keyboard.isAltKeyDown(entityPlayer)) {
                side = entityPlayer.aY() ? (wrenchable.getFacing() + 5) % 6 : (wrenchable.getFacing() + 1) % 6;
            } else if (entityPlayer.aY()) {
                side += side % 2 * -2 + 1;
            }
            if (wrenchable.wrenchCanSetFacing(entityPlayer, side)) {
                if (Platform.isSimulating()) {
                    wrenchable.setFacing((short)side);
                    this.damage(itemstack, 1, entityPlayer);
                }
                if (Platform.isRendering()) {
                    AudioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, AudioManager.defaultVolume);
                }
                return true;
            }
            if (this.canTakeDamage(itemstack, 10) && wrenchable.wrenchCanRemove(entityPlayer)) {
                if (Platform.isSimulating()) {
                    if (!Platform.isRendering() && mod_IC2.enableLoggingWrench) {
                        String blockName = tileEntity.getClass().getName().replace("TileEntity", "");
                        Platform.log(Level.INFO, "Player " + entityPlayer.v + " used the wrench to remove the " + blockName + " (" + blockId + "-" + metaData + ") at " + x + "/" + y + "/" + z);
                    }
                    vz block = vz.m[blockId];
                    ArrayList drops = block.getBlockDropped(world, x, y, z, metaData, 0);
                    boolean dropOriginalBlock = false;
                    if (wrenchable.getWrenchDropRate() < 1.0f && this.overrideWrenchSuccessRate(itemstack)) {
                        if (!this.canTakeDamage(itemstack, 200)) {
                            Platform.messagePlayer(entityPlayer, "Not enough energy for lossless wrench operation");
                            return true;
                        }
                        dropOriginalBlock = true;
                        this.damage(itemstack, 200, entityPlayer);
                    } else {
                        dropOriginalBlock = world.r.nextFloat() <= wrenchable.getWrenchDropRate();
                        this.damage(itemstack, 10, entityPlayer);
                    }
                    if (dropOriginalBlock) {
                        drops.set(0, new kp(blockId, 1, metaData));
                    }
                    for (kp itemStack : drops) {
                        StackUtil.dropAsEntity(world, x, y, z, itemStack);
                    }
                    world.e(x, y, z, 0);
                }
                if (Platform.isRendering()) {
                    AudioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, AudioManager.defaultVolume);
                }
                return true;
            }
        }
        return false;
    }

    public void damage(kp is, int damage, ih player) {
        is.a(damage, (ne)player);
    }

    public boolean overrideWrenchSuccessRate(kp itemStack) {
        return false;
    }
}

