/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.common.ElectricItem;
import ic2.common.PositionSpec;
import ic2.common.Util;
import ic2.platform.AudioManager;
import ic2.platform.Platform;
import java.util.Map;

public class ItemScanner
extends ElectricItem {
    public ItemScanner(int id2, int index, int t) {
        super(id2, index);
        this.maxCharge = 10000;
        this.transferLimit = 50;
        this.tier = t;
    }

    public kp a(kp itemstack, ge world, ih entityplayer) {
        if (this.tier == 1 && !ElectricItem.use(itemstack, 50, entityplayer) || this.tier == 2 && !ElectricItem.use(itemstack, 250, entityplayer)) {
            return itemstack;
        }
        AudioManager.playOnce(entityplayer, PositionSpec.Hand, "Tools/ODScanner.ogg", true, AudioManager.defaultVolume);
        if (this.tier == 2) {
            int value = ItemScanner.valueOfArea(world, Util.roundToNegInf(entityplayer.bm), Util.roundToNegInf(entityplayer.bn), Util.roundToNegInf(entityplayer.bo), true);
            Platform.messagePlayer(entityplayer, "SCAN RESULT: Ore value in this area is " + value);
        } else {
            int value = ItemScanner.valueOfArea(world, Util.roundToNegInf(entityplayer.bm), Util.roundToNegInf(entityplayer.bn), Util.roundToNegInf(entityplayer.bo), false);
            Platform.messagePlayer(entityplayer, "SCAN RESULT: Ore density in this area is " + value);
        }
        return itemstack;
    }

    public static int valueOfArea(ge worldObj, int x, int y, int z, boolean advancedMode) {
        int totalScore = 0;
        int blocksScanned = 0;
        int range = advancedMode ? 4 : 2;
        for (int blockY = y; blockY > 0; --blockY) {
            for (int blockX = x - range; blockX <= x + range; ++blockX) {
                for (int blockZ = z - range; blockZ <= z + range; ++blockZ) {
                    int blockId = worldObj.a(blockX, blockY, blockZ);
                    int metaData = worldObj.c(x, y, z);
                    if (advancedMode) {
                        totalScore += ItemScanner.valueOf(blockId, metaData);
                    } else if (ItemScanner.isValuable(blockId, metaData)) {
                        ++totalScore;
                    }
                    ++blocksScanned;
                }
            }
        }
        return blocksScanned > 0 ? Integer.valueOf((int)(1000.0 * (double)totalScore / (double)blocksScanned)) : null;
    }

    public static boolean isValuable(int blockId, int metaData) {
        return ItemScanner.valueOf(blockId, metaData) > 0;
    }

    public static int valueOf(int blockId, int metaData) {
        if (mod_IC2.valuableOres.containsKey(blockId)) {
            Map metaMap = (Map)mod_IC2.valuableOres.get(blockId);
            if (metaMap.containsKey(-1)) {
                return (Integer)metaMap.get(-1);
            }
            if (metaMap.containsKey(metaData)) {
                return (Integer)metaMap.get(metaData);
            }
        }
        return 0;
    }

    public int startLayerScan(kp itemStack) {
        return ElectricItem.use(itemStack, 50, null) ? 2 : 0;
    }
}

