/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.IElectricItem;
import ic2.common.ElectricItem;
import ic2.common.Ic2Items;
import ic2.platform.Platform;

public class ItemBattery
extends ElectricItem {
    public ItemBattery(int id2, int sprite, int maxCharge, int transferLimit, int tier) {
        super(id2, sprite);
        this.setNoRepair();
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.tier = tier;
    }

    @Override
    public boolean canProvideEnergy() {
        return true;
    }

    @Override
    public int getEmptyItemId() {
        if (this.bP == Ic2Items.chargedReBattery.c) {
            return Ic2Items.reBattery.c;
        }
        return super.getEmptyItemId();
    }

    @Override
    public int getIconFromDamage(int i) {
        if (i <= 1) {
            return this.bR + 4;
        }
        if (i <= 8) {
            return this.bR + 3;
        }
        if (i <= 14) {
            return this.bR + 2;
        }
        if (i <= 20) {
            return this.bR + 1;
        }
        return this.bR;
    }

    public int getIconFromChargeLevel(float chargeLevel) {
        return this.getIconFromDamage(1 + (int)Math.round((1.0 - (double)chargeLevel) * (double)(this.f() - 2)));
    }

    public kp a(kp itemStack, ge world, ih entityplayer) {
        if (Platform.isSimulating() && itemStack.c == Ic2Items.chargedReBattery.c) {
            boolean transferred = false;
            for (int i = 0; i < 9; ++i) {
                kp stack = entityplayer.k.a[i];
                if (stack == null || !(id.d[stack.c] instanceof IElectricItem) || stack == itemStack) continue;
                IElectricItem item = (IElectricItem)stack.a();
                int transfer = ItemBattery.discharge(itemStack, 2 * this.transferLimit, item.getTier(), true, true);
                transfer = ItemBattery.charge(stack, transfer, this.tier, true, false);
                ItemBattery.discharge(itemStack, transfer, item.getTier(), true, false);
                if (transfer == 0) break;
                transferred = true;
            }
            if (transferred && !Platform.isRendering()) {
                entityplayer.m.a();
            }
        }
        return itemStack;
    }
}

