/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import forge.ArmorProperties;
import forge.ISpecialArmor;
import forge.ITextureProvider;
import ic2.api.IElectricItem;
import ic2.common.ElectricItem;
import ic2.platform.ItemArmorCommon;
import java.util.ArrayList;

public abstract class ItemArmorElectric
extends ItemArmorCommon
implements ITextureProvider,
ISpecialArmor,
IElectricItem {
    public int maxCharge;
    public int transferLimit;
    public int tier;

    public ItemArmorElectric(int itemId, int spriteIndex, int armorRendering, int armorType, int maxCharge, int transferLimit, int tier) {
        super(itemId, dq.e, armorRendering, armorType);
        this.bR = spriteIndex;
        this.maxCharge = maxCharge;
        this.tier = tier;
        this.transferLimit = transferLimit;
        this.f(27);
        this.e(1);
    }

    public int c() {
        return 0;
    }

    public boolean isRepairable() {
        return false;
    }

    public void addCreativeItems(ArrayList itemList) {
        kp charged = new kp((id)this, 1);
        ElectricItem.charge(charged, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
        itemList.add(charged);
        itemList.add(new kp((id)this, 1, this.f()));
    }

    public String getTextureFile() {
        return "/ic2/sprites/item_0.png";
    }

    public ArmorProperties getProperties(ne player, kp armor, rq source, double damage, int slot) {
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = energyPerDamage > 0 ? 25 * ElectricItem.discharge(armor, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true) / energyPerDamage : 0;
        return new ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public int getArmorDisplay(ih player, kp armor, int slot) {
        return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
    }

    public void damageArmor(ne entity, kp stack, rq source, int damage, int slot) {
        ElectricItem.discharge(stack, damage * this.getEnergyPerDamage(), Integer.MAX_VALUE, true, false);
    }

    @Override
    public boolean canProvideEnergy() {
        return false;
    }

    @Override
    public int getChargedItemId() {
        return this.bP;
    }

    @Override
    public int getEmptyItemId() {
        return this.bP;
    }

    @Override
    public int getMaxCharge() {
        return this.maxCharge;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public int getTransferLimit() {
        return this.transferLimit;
    }

    public abstract double getDamageAbsorptionRatio();

    public abstract int getEnergyPerDamage();

    private double getBaseAbsorptionRatio() {
        switch (this.a) {
            case 0: {
                return 0.15;
            }
            case 1: {
                return 0.4;
            }
            case 2: {
                return 0.3;
            }
            case 3: {
                return 0.15;
            }
        }
        return 0.0;
    }
}

