/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.api.IEnergyAcceptor;
import ic2.api.IEnergyConductor;
import ic2.api.IEnergyEmitter;
import ic2.api.IEnergySink;
import ic2.api.IEnergySource;
import ic2.api.IEnergyTile;
import ic2.common.IC2DamageSource;
import ic2.platform.Platform;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public final class EnergyNet {
    public static final double minConductionLoss = 1.0E-4;
    private static Map worldToEnergyNetMap = new HashMap();
    private ge world;
    private Map energySourceToEnergyPathMap = new HashMap();
    private Map entityLivingToShockEnergyMap = new HashMap();

    public static EnergyNet getForWorld(ge world) {
        if (world == null) {
            System.out.println("[IC2] EnergyNet.getForWorld: world = null, bad things may happen..");
            return null;
        }
        if (!worldToEnergyNetMap.containsKey(world)) {
            worldToEnergyNetMap.put(world, new EnergyNet(world));
        }
        return (EnergyNet)worldToEnergyNetMap.get(world);
    }

    public static void onTick(ge world) {
        Platform.profilerStartSection("Shocking");
        EnergyNet energyNet = EnergyNet.getForWorld(world);
        for (Map.Entry entry : energyNet.entityLivingToShockEnergyMap.entrySet()) {
            ne target = (ne)entry.getKey();
            int damage = ((Integer)entry.getValue() + 63) / 64;
            if (!target.aE()) continue;
            target.a((rq)IC2DamageSource.electricity, damage);
        }
        energyNet.entityLivingToShockEnergyMap.clear();
        Platform.profilerEndSection();
    }

    private EnergyNet(ge world) {
        this.world = world;
    }

    public void addTileEntity(qj addedTileEntity) {
        if (!(addedTileEntity instanceof IEnergyTile) || ((IEnergyTile)addedTileEntity).isAddedToEnergyNet()) {
            return;
        }
        if (addedTileEntity instanceof IEnergyAcceptor) {
            List reverseEnergyPaths = this.discover(addedTileEntity, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                IEnergySource energySource = (IEnergySource)reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(energySource) || (double)energySource.getMaxEnergyOutput() <= reverseEnergyPath.loss) continue;
                this.energySourceToEnergyPathMap.remove(energySource);
            }
        }
        if (addedTileEntity instanceof IEnergySource) {
            // empty if block
        }
    }

    public void removeTileEntity(qj removedTileEntity) {
        if (!(removedTileEntity instanceof IEnergyTile) || !((IEnergyTile)removedTileEntity).isAddedToEnergyNet()) {
            boolean alreadyRemoved = removedTileEntity instanceof IEnergyTile ? !((IEnergyTile)removedTileEntity).isAddedToEnergyNet() : true;
            System.out.println("[IC2] removing " + removedTileEntity + " from the EnergyNet failed, already removed: " + alreadyRemoved);
            Thread.dumpStack();
            return;
        }
        if (removedTileEntity instanceof IEnergyAcceptor) {
            List reverseEnergyPaths = this.discover(removedTileEntity, true, Integer.MAX_VALUE);
            block0: for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                IEnergySource energySource = (IEnergySource)reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(energySource) || (double)energySource.getMaxEnergyOutput() <= reverseEnergyPath.loss) continue;
                if (removedTileEntity instanceof IEnergyConductor) {
                    this.energySourceToEnergyPathMap.remove(energySource);
                    continue;
                }
                Iterator it2 = ((List)this.energySourceToEnergyPathMap.get(energySource)).iterator();
                while (it2.hasNext()) {
                    if (((EnergyPath)it2.next()).target != removedTileEntity) continue;
                    it2.remove();
                    continue block0;
                }
            }
        }
        if (removedTileEntity instanceof IEnergySource) {
            this.energySourceToEnergyPathMap.remove((IEnergySource)removedTileEntity);
        }
    }

    public int emitEnergyFrom(IEnergySource energySource, int amount) {
        if (!energySource.isAddedToEnergyNet()) {
            System.out.println("[IC2] EnergyNet.emitEnergyFrom: " + energySource + " is not added to the enet");
            return amount;
        }
        if (!this.energySourceToEnergyPathMap.containsKey(energySource)) {
            this.energySourceToEnergyPathMap.put(energySource, this.discover((qj)energySource, false, energySource.getMaxEnergyOutput()));
        }
        Vector<EnergyPath> activeEnergyPaths = new Vector<EnergyPath>();
        double totalInvLoss = 0.0;
        for (EnergyPath energyPath : (List)this.energySourceToEnergyPathMap.get(energySource)) {
            assert (energyPath.target instanceof IEnergySink);
            IEnergySink energySink = (IEnergySink)energyPath.target;
            if (!energySink.demandsEnergy() || !(energyPath.loss < (double)amount)) continue;
            totalInvLoss += 1.0 / energyPath.loss;
            activeEnergyPaths.add(energyPath);
        }
        Collections.shuffle(activeEnergyPaths);
        for (int i = activeEnergyPaths.size() - amount; i > 0; --i) {
            EnergyPath removedEnergyPath = (EnergyPath)activeEnergyPaths.remove(activeEnergyPaths.size() - 1);
            totalInvLoss -= 1.0 / removedEnergyPath.loss;
        }
        HashMap<EnergyPath, Integer> suppliedEnergyPaths = new HashMap<EnergyPath, Integer>();
        Vector newActiveEnergyPaths = new Vector();
        while (!activeEnergyPaths.isEmpty() && amount > 0) {
            int energyConsumed = 0;
            double newTotalInvLoss = 0.0;
            Vector<EnergyPath> currentActiveEnergyPaths = activeEnergyPaths;
            activeEnergyPaths = new Vector();
            Iterator it2 = activeEnergyPaths.iterator();
            for (EnergyPath energyPath : currentActiveEnergyPaths) {
                int energyLoss;
                IEnergySink energySink = (IEnergySink)energyPath.target;
                int energyProvided = (int)Math.floor((double)Math.round((double)amount / totalInvLoss / energyPath.loss * 100000.0) / 100000.0);
                if (energyProvided > (energyLoss = (int)Math.floor(energyPath.loss))) {
                    int energyReturned = energySink.injectEnergy(energyPath.targetDirection, energyProvided - energyLoss);
                    if (energyReturned == 0) {
                        activeEnergyPaths.add(energyPath);
                        newTotalInvLoss += 1.0 / energyPath.loss;
                    } else if (energyReturned == energyProvided - energyLoss) {
                        System.out.println("[IC2] WARNING: " + energySink + " didn't implement demandsEnergy() properly, no energy from injectEnergy accepted although demandsEnergy() returned true.");
                    }
                    energyConsumed += energyProvided - energyReturned;
                    int energyInjected = energyProvided - energyLoss - energyReturned;
                    if (!suppliedEnergyPaths.containsKey(energyPath)) {
                        suppliedEnergyPaths.put(energyPath, energyInjected);
                        continue;
                    }
                    suppliedEnergyPaths.put(energyPath, energyInjected + (Integer)suppliedEnergyPaths.get(energyPath));
                    continue;
                }
                activeEnergyPaths.add(energyPath);
                newTotalInvLoss += 1.0 / energyPath.loss;
            }
            if (energyConsumed == 0 && !activeEnergyPaths.isEmpty()) {
                EnergyPath removedEnergyPath = (EnergyPath)activeEnergyPaths.remove(activeEnergyPaths.size() - 1);
                newTotalInvLoss -= 1.0 / removedEnergyPath.loss;
            }
            totalInvLoss = newTotalInvLoss;
            amount -= energyConsumed;
        }
        for (Map.Entry entry : suppliedEnergyPaths.entrySet()) {
            EnergyPath energyPath = (EnergyPath)entry.getKey();
            int energyInjected = (Integer)entry.getValue();
            energyPath.totalEnergyConducted += (long)energyInjected;
            if (energyInjected > energyPath.minInsulationEnergyAbsorption) {
                List entitiesNearEnergyPath = this.world.a(ne.class, fp.a((double)(energyPath.minX - 1), (double)(energyPath.minY - 1), (double)(energyPath.minZ - 1), (double)(energyPath.maxX + 2), (double)(energyPath.maxY + 2), (double)(energyPath.maxZ + 2)));
                for (ne entityLiving : entitiesNearEnergyPath) {
                    int maxShockEnergy = 0;
                    for (IEnergyConductor energyConductor : energyPath.conductors) {
                        qj te = (qj)energyConductor;
                        if (!entityLiving.bw.a(fp.a((double)(te.l - 1), (double)(te.m - 1), (double)(te.n - 1), (double)(te.l + 2), (double)(te.m + 2), (double)(te.n + 2)))) continue;
                        int shockEnergy = energyInjected - energyConductor.getInsulationEnergyAbsorption();
                        if (shockEnergy > maxShockEnergy) {
                            maxShockEnergy = shockEnergy;
                        }
                        if (energyConductor.getInsulationEnergyAbsorption() != energyPath.minInsulationEnergyAbsorption) continue;
                        break;
                    }
                    if (this.entityLivingToShockEnergyMap.containsKey(entityLiving)) {
                        this.entityLivingToShockEnergyMap.put(entityLiving, (Integer)this.entityLivingToShockEnergyMap.get(entityLiving) + maxShockEnergy);
                        continue;
                    }
                    this.entityLivingToShockEnergyMap.put(entityLiving, maxShockEnergy);
                }
                if (energyInjected >= energyPath.minInsulationBreakdownEnergy) {
                    for (IEnergyConductor energyConductor : energyPath.conductors) {
                        if (energyInjected < energyConductor.getInsulationBreakdownEnergy()) continue;
                        energyConductor.removeInsulation();
                        if (energyConductor.getInsulationEnergyAbsorption() >= energyPath.minInsulationEnergyAbsorption) continue;
                        energyPath.minInsulationEnergyAbsorption = energyConductor.getInsulationEnergyAbsorption();
                    }
                }
            }
            if (energyInjected < energyPath.minConductorBreakdownEnergy) continue;
            for (IEnergyConductor energyConductor : energyPath.conductors) {
                if (energyInjected < energyConductor.getConductorBreakdownEnergy()) continue;
                energyConductor.removeConductor();
            }
        }
        return amount;
    }

    public long getTotalEnergyConducted(qj tileEntity) {
        long ret = 0L;
        if (tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) {
            List reverseEnergyPaths = this.discover(tileEntity, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                IEnergySource energySource = (IEnergySource)reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(energySource) || (double)energySource.getMaxEnergyOutput() <= reverseEnergyPath.loss) continue;
                for (EnergyPath energyPath : (List)this.energySourceToEnergyPathMap.get(energySource)) {
                    if ((!(tileEntity instanceof IEnergySink) || energyPath.target != tileEntity) && (!(tileEntity instanceof IEnergyConductor) || !energyPath.conductors.contains((IEnergyConductor)tileEntity))) continue;
                    ret += energyPath.totalEnergyConducted;
                }
            }
        }
        if (tileEntity instanceof IEnergySource && this.energySourceToEnergyPathMap.containsKey((IEnergySource)tileEntity)) {
            for (EnergyPath energyPath : (List)this.energySourceToEnergyPathMap.get((IEnergySource)tileEntity)) {
                ret += energyPath.totalEnergyConducted;
            }
        }
        return ret;
    }

    private List discover(qj emitter, boolean reverse, int lossLimit) {
        HashMap<qj, EnergyBlockLink> reachedTileEntities = new HashMap<qj, EnergyBlockLink>();
        LinkedList<qj> tileEntitiesToCheck = new LinkedList<qj>();
        tileEntitiesToCheck.add(emitter);
        while (!tileEntitiesToCheck.isEmpty()) {
            qj currentTileEntity = (qj)tileEntitiesToCheck.remove();
            if (currentTileEntity.l()) continue;
            double currentLoss = 0.0;
            if (currentTileEntity != emitter) {
                currentLoss = ((EnergyBlockLink)reachedTileEntities.get((Object)currentTileEntity)).loss;
            }
            List validReceivers = this.getValidReceivers(currentTileEntity, reverse);
            for (EnergyTarget validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter) continue;
                double additionalLoss = 0.0;
                if (validReceiver.tileEntity instanceof IEnergyConductor) {
                    additionalLoss = ((IEnergyConductor)validReceiver.tileEntity).getConductionLoss();
                    if (additionalLoss < 1.0E-4) {
                        additionalLoss = 1.0E-4;
                    }
                    if (currentLoss + additionalLoss >= (double)lossLimit) continue;
                }
                if (reachedTileEntities.containsKey(validReceiver.tileEntity) && !(((EnergyBlockLink)reachedTileEntities.get((Object)validReceiver.tileEntity)).loss > currentLoss + additionalLoss)) continue;
                reachedTileEntities.put(validReceiver.tileEntity, new EnergyBlockLink(validReceiver.direction, currentLoss + additionalLoss));
                if (!(validReceiver.tileEntity instanceof IEnergyConductor)) continue;
                tileEntitiesToCheck.remove(validReceiver.tileEntity);
                tileEntitiesToCheck.add(validReceiver.tileEntity);
            }
        }
        LinkedList<EnergyPath> energyPaths = new LinkedList<EnergyPath>();
        block2: for (Map.Entry entry : reachedTileEntities.entrySet()) {
            qj tileEntity = (qj)entry.getKey();
            if ((reverse || !(tileEntity instanceof IEnergySink)) && (!reverse || !(tileEntity instanceof IEnergySource))) continue;
            EnergyBlockLink energyBlockLink = (EnergyBlockLink)entry.getValue();
            EnergyPath energyPath = new EnergyPath();
            energyPath.loss = energyBlockLink.loss > 0.1 ? energyBlockLink.loss : 0.1;
            energyPath.target = tileEntity;
            energyPath.targetDirection = energyBlockLink.direction;
            if (!reverse && emitter instanceof IEnergySource) {
                while ((tileEntity = energyBlockLink.direction.applyToTileEntity(tileEntity)) != emitter) {
                    if (tileEntity instanceof IEnergyConductor) {
                        IEnergyConductor energyConductor = (IEnergyConductor)tileEntity;
                        if (tileEntity.l < energyPath.minX) {
                            energyPath.minX = tileEntity.l;
                        }
                        if (tileEntity.m < energyPath.minY) {
                            energyPath.minY = tileEntity.m;
                        }
                        if (tileEntity.n < energyPath.minZ) {
                            energyPath.minZ = tileEntity.n;
                        }
                        if (tileEntity.l > energyPath.maxX) {
                            energyPath.maxX = tileEntity.l;
                        }
                        if (tileEntity.m > energyPath.maxY) {
                            energyPath.maxY = tileEntity.m;
                        }
                        if (tileEntity.n > energyPath.maxZ) {
                            energyPath.maxZ = tileEntity.n;
                        }
                        energyPath.conductors.add(energyConductor);
                        if (energyConductor.getInsulationEnergyAbsorption() < energyPath.minInsulationEnergyAbsorption) {
                            energyPath.minInsulationEnergyAbsorption = energyConductor.getInsulationEnergyAbsorption();
                        }
                        if (energyConductor.getInsulationBreakdownEnergy() < energyPath.minInsulationBreakdownEnergy) {
                            energyPath.minInsulationBreakdownEnergy = energyConductor.getInsulationBreakdownEnergy();
                        }
                        if (energyConductor.getConductorBreakdownEnergy() < energyPath.minConductorBreakdownEnergy) {
                            energyPath.minConductorBreakdownEnergy = energyConductor.getConductorBreakdownEnergy();
                        }
                        if ((energyBlockLink = (EnergyBlockLink)reachedTileEntities.get(tileEntity)) != null) continue;
                        Platform.displayError("An energy network pathfinding entry is corrupted.\nThis could happen due to incorrect Minecraft behavior or a bug.\n\n(Technical information: energyBlockLink, tile entities below)\nE: " + emitter + " (" + emitter.l + "," + emitter.m + "," + emitter.n + ")\n" + "C: " + tileEntity + " (" + tileEntity.l + "," + tileEntity.m + "," + tileEntity.n + ")\n" + "R: " + energyPath.target + " (" + energyPath.target.l + "," + energyPath.target.m + "," + energyPath.target.n + ")");
                        continue;
                    }
                    if (tileEntity == null) continue block2;
                    System.out.println("EnergyNet: EnergyBlockLink corrupted (" + energyPath.target + " [" + energyPath.target.l + " " + energyPath.target.m + " " + energyPath.target.n + "] -> " + tileEntity + " [" + tileEntity.l + " " + tileEntity.m + " " + tileEntity.n + "] -> " + emitter + " [" + emitter.l + " " + emitter.m + " " + emitter.n + "])");
                    continue block2;
                }
            }
            energyPaths.add(energyPath);
        }
        return energyPaths;
    }

    public List discoverTargets(qj emitter, boolean reverse, int lossLimit) {
        List paths = this.discover(emitter, reverse, lossLimit);
        LinkedList<qj> targets = new LinkedList<qj>();
        for (EnergyPath path : paths) {
            targets.add(path.target);
        }
        return targets;
    }

    private List getValidReceivers(qj emitter, boolean reverse) {
        LinkedList<EnergyTarget> validReceivers = new LinkedList<EnergyTarget>();
        for (Direction direction : Direction.values()) {
            qj target = direction.applyToTileEntity(emitter);
            if (!(target instanceof IEnergyTile) || !((IEnergyTile)target).isAddedToEnergyNet()) continue;
            Direction inverseDirection = direction.getInverse();
            if ((reverse || !(emitter instanceof IEnergyEmitter) || !((IEnergyEmitter)emitter).emitsEnergyTo(target, direction)) && (!reverse || !(emitter instanceof IEnergyAcceptor) || !((IEnergyAcceptor)emitter).acceptsEnergyFrom(target, direction)) || (reverse || !(target instanceof IEnergyAcceptor) || !((IEnergyAcceptor)target).acceptsEnergyFrom(emitter, inverseDirection)) && (!reverse || !(target instanceof IEnergyEmitter) || !((IEnergyEmitter)target).emitsEnergyTo(emitter, inverseDirection))) continue;
            validReceivers.add(new EnergyTarget(target, inverseDirection));
        }
        return validReceivers;
    }

    static class EnergyTarget {
        qj tileEntity;
        Direction direction;

        EnergyTarget(qj tileEntity, Direction direction) {
            this.tileEntity = tileEntity;
            this.direction = direction;
        }
    }

    static class EnergyBlockLink {
        Direction direction;
        double loss;

        EnergyBlockLink(Direction direction, double loss) {
            this.direction = direction;
            this.loss = loss;
        }
    }

    static class EnergyPath {
        qj target = null;
        Direction targetDirection;
        Set conductors = new HashSet();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        double loss = 0.0;
        int minInsulationEnergyAbsorption = Integer.MAX_VALUE;
        int minInsulationBreakdownEnergy = Integer.MAX_VALUE;
        int minConductorBreakdownEnergy = Integer.MAX_VALUE;
        long totalEnergyConducted = 0L;

        EnergyPath() {
        }
    }
}

