/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import forge.IConnectRedstone;
import forge.ISpecialResistance;
import ic2.api.Direction;
import ic2.api.IPaintableBlock;
import ic2.common.AabbUtil;
import ic2.common.BlockMultiID;
import ic2.common.Ic2Items;
import ic2.common.ItemToolCutter;
import ic2.common.StackUtil;
import ic2.common.TileEntityBlock;
import ic2.common.TileEntityCable;
import ic2.common.TileEntityCableDetector;
import ic2.common.TileEntityCableSplitter;
import ic2.platform.ItemBlockCommon;
import ic2.platform.Platform;
import java.util.ArrayList;

public class BlockCable
extends BlockMultiID
implements IPaintableBlock,
ISpecialResistance,
IConnectRedstone {
    public BlockCable(int i) {
        super(i, na.f);
        this.c(0.2f);
        this.a(k);
        Ic2Items.copperCableBlock = new kp((vz)this, 1, 1);
        Ic2Items.insulatedCopperCableBlock = new kp((vz)this, 1, 0);
        Ic2Items.goldCableBlock = new kp((vz)this, 1, 2);
        Ic2Items.insulatedGoldCableBlock = new kp((vz)this, 1, 3);
        Ic2Items.doubleInsulatedGoldCableBlock = new kp((vz)this, 1, 4);
        Ic2Items.ironCableBlock = new kp((vz)this, 1, 5);
        Ic2Items.insulatedIronCableBlock = new kp((vz)this, 1, 6);
        Ic2Items.doubleInsulatedIronCableBlock = new kp((vz)this, 1, 7);
        Ic2Items.trippleInsulatedIronCableBlock = new kp((vz)this, 1, 8);
        Ic2Items.glassFiberCableBlock = new kp((vz)this, 1, 9);
        Ic2Items.tinCableBlock = new kp((vz)this, 1, 10);
        Ic2Items.detectorCableBlock = new kp((vz)this, 1, 11);
        Ic2Items.splitterCableBlock = new kp((vz)this, 1, 12);
        ModLoader.registerBlock((vz)this, ItemBlockCommon.class);
    }

    public String getTextureFile() {
        return "/ic2/sprites/block_cable.png";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getBlockTexture(zy iblockaccess, int x, int y, int z, int side) {
        short cableType;
        int color = 0;
        qj te = iblockaccess.b(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            cableType = (short)iblockaccess.c(x, y, z);
            return cableType * 16 + color;
        }
        TileEntityCable cable = (TileEntityCable)te;
        if (cable.foamed != 0) {
            if (cable.foamed != 1) return 208 + cable.foamColor;
            return 178;
        }
        cableType = cable.cableType;
        if (!(te instanceof TileEntityCableDetector) && !(te instanceof TileEntityCableSplitter)) {
            color = cable.color;
            return cableType * 16 + color;
        }
        color = cable.getActive() ? 1 : 0;
        return cableType * 16 + color;
    }

    @Override
    public int a(int side, int meta) {
        return meta * 16;
    }

    public wu a(ge world, int x, int y, int z, cj origin, cj absDirection) {
        qj te = world.b(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return null;
        }
        TileEntityCable tileEntityCable = (TileEntityCable)te;
        cj direction = cj.a((double)(absDirection.a - origin.a), (double)(absDirection.b - origin.b), (double)(absDirection.c - origin.c));
        double maxLength = direction.c();
        double halfThickness = (double)tileEntityCable.getCableThickness() / 2.0;
        boolean hit = false;
        cj intersection = cj.a((double)0.0, (double)0.0, (double)0.0);
        Direction intersectingDirection = AabbUtil.getIntersection(origin, direction, fp.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness)), intersection);
        if (intersectingDirection != null && intersection.b(origin) <= maxLength) {
            hit = true;
        }
        for (Direction dir : Direction.values()) {
            if (hit) break;
            qj target = dir.applyToTileEntity(tileEntityCable);
            if (!tileEntityCable.canInteractWith(target)) continue;
            fp bbox = null;
            switch (dir) {
                case XN: {
                    bbox = fp.a((double)x, (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case XP: {
                    bbox = fp.a((double)((double)x + 0.5), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 1.0), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case YN: {
                    bbox = fp.a((double)((double)x + 0.5 - halfThickness), (double)y, (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case YP: {
                    bbox = fp.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 1.0), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case ZN: {
                    bbox = fp.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)z, (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5));
                    break;
                }
                case ZP: {
                    bbox = fp.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 1.0));
                }
            }
            intersectingDirection = AabbUtil.getIntersection(origin, direction, bbox, intersection);
            if (intersectingDirection == null || !(intersection.b(origin) <= maxLength)) continue;
            hit = true;
        }
        if (hit) {
            return new wu(x, y, z, intersectingDirection.toSideValue(), intersection);
        }
        return null;
    }

    public fp getCollisionBoundingBoxFromPool(ge world, int x, int y, int z, int meta) {
        double halfThickness = TileEntityCable.getCableThickness(meta);
        return fp.b((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
    }

    public fp e(ge world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, false);
    }

    public fp getSelectedBoundingBoxFromPool(ge world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, true);
    }

    public fp getCommonBoundingBoxFromPool(ge world, int x, int y, int z, boolean selectionBoundingBox) {
        qj te = world.b(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return this.getCollisionBoundingBoxFromPool(world, x, y, z, 3);
        }
        TileEntityCable cable = (TileEntityCable)te;
        double halfThickness = cable.foamed == 1 && selectionBoundingBox ? 0.5 : (double)cable.getCableThickness() / 2.0;
        double minX = (double)x + 0.5 - halfThickness;
        double minY = (double)y + 0.5 - halfThickness;
        double minZ = (double)z + 0.5 - halfThickness;
        double maxX = (double)x + 0.5 + halfThickness;
        double maxY = (double)y + 0.5 + halfThickness;
        double maxZ = (double)z + 0.5 + halfThickness;
        if (cable.canInteractWith(world.b(x - 1, y, z))) {
            minX = x;
        }
        if (cable.canInteractWith(world.b(x, y - 1, z))) {
            minY = y;
        }
        if (cable.canInteractWith(world.b(x, y, z - 1))) {
            minZ = z;
        }
        if (cable.canInteractWith(world.b(x + 1, y, z))) {
            maxX = x + 1;
        }
        if (cable.canInteractWith(world.b(x, y + 1, z))) {
            maxY = y + 1;
        }
        if (cable.canInteractWith(world.b(x, y, z + 1))) {
            maxZ = z + 1;
        }
        return fp.b((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public boolean isBlockNormalCube(ge world, int x, int y, int z) {
        qj te = world.b(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean a(ge world, int x, int y, int z, ih entityPlayer) {
        kp cur = entityPlayer.U();
        if (cur != null && cur.c == vz.E.bO) {
            if (!Platform.isSimulating()) {
                return true;
            }
            qj te = world.b(x, y, z);
            if (te instanceof TileEntityCable) {
                TileEntityCable cable = (TileEntityCable)te;
                if (cable.foamed == 1 && cable.changeFoam((byte)2)) {
                    --cur.a;
                    if (cur.a <= 0) {
                        entityPlayer.k.a[entityPlayer.k.c] = null;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static int getCableColor(zy iblockaccess, int i, int j, int k) {
        qj te = iblockaccess.b(i, j, k);
        return te instanceof TileEntityCable ? (int)((TileEntityCable)te).color : 0;
    }

    @Override
    public boolean colorBlock(ge world, int i, int j, int k, int color) {
        return ((TileEntityCable)world.b(i, j, k)).changeColor(color);
    }

    public boolean canHarvestBlock(ih player, int md) {
        return true;
    }

    @Override
    public ArrayList getBlockDropped(ge world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<kp> ret = new ArrayList<kp>();
        qj te = world.b(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            ret.add(new kp(Ic2Items.insulatedCopperCableItem.c, 1, (int)cable.cableType));
        } else if (metadata != 13) {
            ret.add(new kp(Ic2Items.insulatedCopperCableItem.c, 1, metadata));
        }
        return ret;
    }

    @Override
    public void d(ge world, int x, int y, int z) {
        qj te;
        if (world.c(x, y, z) == 13 && (te = world.b(x, y, z)) instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            StackUtil.dropAsEntity(world, x, y, z, new kp(Ic2Items.insulatedCopperCableItem.c, 1, (int)cable.cableType));
        }
    }

    @Override
    public TileEntityBlock getBlockEntity(int meta) {
        if (meta == 11) {
            return new TileEntityCableDetector((short)meta);
        }
        if (meta == 12) {
            return new TileEntityCableSplitter((short)meta);
        }
        return new TileEntityCable((short)meta);
    }

    public int getMaxMeta() {
        return 13;
    }

    public boolean b() {
        return false;
    }

    public int c() {
        return mod_IC2.cableRenderId;
    }

    public boolean a() {
        return false;
    }

    public void b(ge world, int i, int j, int k, ih entityplayer) {
        if (entityplayer.U() != null && entityplayer.U().a() instanceof ItemToolCutter) {
            ItemToolCutter.cutInsulationFrom(entityplayer.U(), world, i, j, k);
        }
    }

    public boolean a(zy iblockaccess, int x, int y, int z, int side) {
        qj te = iblockaccess.b(x, y, z);
        if (te instanceof TileEntityCableDetector) {
            return ((TileEntityCableDetector)te).getActive();
        }
        return false;
    }

    @Override
    public void addCreativeItems(ArrayList itemList) {
    }

    public float getHardness(int md) {
        if (md == 13) {
            return 3.0f;
        }
        return 0.2f;
    }

    public float getSpecialExplosionResistance(ge world, int x, int y, int z, double src_x, double src_y, double src_z, tv exploder) {
        qj te = world.b(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed == 2) {
                return 90.0f;
            }
        }
        return 6.0f;
    }

    public boolean canConnectRedstone(zy world, int X, int Y, int Z, int direction) {
        int meta = world.c(X, Y, Z);
        return meta == 11 || meta == 12;
    }
}

