/*
 * Decompiled with CFR 0.152.
 */
package ic2.platform;

import ic2.common.AudioPosition;
import ic2.common.PositionSpec;
import ic2.platform.AudioManager;
import java.net.URL;
import paulscode.sound.SoundSystem;

public final class AudioSource
implements Comparable {
    private SoundSystem soundSystem;
    private String sourceName;
    private boolean valid = false;
    private boolean culled = false;
    private Object obj;
    private AudioPosition position;
    private PositionSpec positionSpec;
    private float configuredVolume;
    private float realVolume;
    private boolean isPlaying = false;

    public AudioSource(SoundSystem soundSystem, String sourceName, Object obj, PositionSpec positionSpec, String initialSoundFile, boolean loop, boolean priorized, float volume) {
        this.soundSystem = soundSystem;
        this.sourceName = sourceName;
        this.obj = obj;
        this.positionSpec = positionSpec;
        URL url = AudioSource.class.getClassLoader().getResource("ic2/sounds/" + initialSoundFile);
        if (url == null) {
            System.out.println("Invalid sound file: " + initialSoundFile);
            return;
        }
        this.position = AudioPosition.getFrom(obj, positionSpec);
        soundSystem.newSource(priorized, sourceName, url, initialSoundFile, loop, this.position.x, this.position.y, this.position.z, 0, AudioManager.fadingDistance * Math.max(volume, 1.0f));
        this.valid = true;
        this.setVolume(volume);
    }

    public int compareTo(AudioSource x) {
        if (this.culled) {
            return (int)((this.realVolume * 0.9f - x.realVolume) * 128.0f);
        }
        return (int)((this.realVolume - x.realVolume) * 128.0f);
    }

    public void remove() {
        if (!this.valid) {
            return;
        }
        this.stop();
        this.soundSystem.removeSource(this.sourceName);
        this.sourceName = null;
    }

    public void play() {
        if (!this.valid) {
            return;
        }
        if (this.isPlaying) {
            return;
        }
        this.isPlaying = true;
        this.soundSystem.play(this.sourceName);
    }

    public void pause() {
        if (!this.valid) {
            return;
        }
        if (!this.isPlaying) {
            return;
        }
        this.isPlaying = false;
        this.soundSystem.pause(this.sourceName);
    }

    public void stop() {
        if (!this.valid) {
            return;
        }
        if (!this.isPlaying) {
            return;
        }
        this.isPlaying = false;
        this.soundSystem.stop(this.sourceName);
    }

    public void flush() {
        if (!this.valid) {
            return;
        }
        if (!this.isPlaying) {
            return;
        }
        this.soundSystem.flush(this.sourceName);
    }

    public void cull() {
        if (!this.valid || this.culled) {
            return;
        }
        this.soundSystem.cull(this.sourceName);
        this.culled = true;
    }

    public void activate() {
        if (!this.valid || !this.culled) {
            return;
        }
        this.soundSystem.activate(this.sourceName);
        this.culled = false;
    }

    public float getVolume() {
        if (!this.valid) {
            return 0.0f;
        }
        return this.soundSystem.getVolume(this.sourceName);
    }

    public float getRealVolume() {
        return this.realVolume;
    }

    public void setVolume(float volume) {
        this.configuredVolume = volume;
        this.soundSystem.setVolume(this.sourceName, 0.001f);
    }

    public void setPitch(float pitch) {
        if (!this.valid) {
            return;
        }
        this.soundSystem.setPitch(this.sourceName, pitch);
    }

    public void updatePosition() {
        if (!this.valid) {
            return;
        }
        this.position = AudioPosition.getFrom(this.obj, this.positionSpec);
        this.soundSystem.setPosition(this.sourceName, this.position.x, this.position.y, this.position.z);
    }

    public void updateVolume(yw player) {
        float distance;
        if (!this.valid || !this.isPlaying) {
            this.realVolume = 0.0f;
            return;
        }
        float maxDistance = AudioManager.fadingDistance * Math.max(this.configuredVolume, 1.0f);
        float rolloffFactor = 1.0f;
        float referenceDistance = 1.0f;
        float x = (float)player.o;
        float y = (float)player.p;
        float z2 = (float)player.q;
        if (this.position.world == player.k) {
            float deltaX = this.position.x - x;
            float deltaY = this.position.y - y;
            float deltaZ = this.position.z - z2;
            distance = (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        } else {
            distance = Float.POSITIVE_INFINITY;
        }
        if (distance > maxDistance) {
            this.realVolume = 0.0f;
            this.cull();
            return;
        }
        if (distance < referenceDistance) {
            distance = referenceDistance;
        }
        float gain = 1.0f - rolloffFactor * (distance - referenceDistance) / (maxDistance - referenceDistance);
        float newRealVolume = gain * this.configuredVolume * AudioManager.getMasterVolume();
        float dx = (this.position.x - x) / distance;
        float dy2 = (this.position.y - y) / distance;
        float dz = (this.position.z - z2) / distance;
        if ((double)newRealVolume > 0.1) {
            int i = 0;
            while ((float)i < distance) {
                int blockId = player.k.a((int)x, (int)y, (int)z2);
                if (blockId != 0) {
                    newRealVolume = pb.n[blockId] ? (newRealVolume *= 0.6f) : (newRealVolume *= 0.8f);
                }
                x += dx;
                y += dy2;
                z2 += dz;
                ++i;
            }
        }
        if ((double)Math.abs(this.realVolume / newRealVolume - 1.0f) > 0.06) {
            this.soundSystem.setVolume(this.sourceName, AudioManager.getMasterVolume() * Math.min(newRealVolume, 1.0f));
        }
        this.realVolume = newRealVolume;
    }
}

