/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import forge.ForgeHooks;
import forge.ISidedInventory;
import ic2.common.ContainerIC2;
import ic2.common.ContainerMiner;
import ic2.common.ElectricItem;
import ic2.common.IHasGui;
import ic2.common.Ic2Items;
import ic2.common.ItemElectricToolDDrill;
import ic2.common.ItemElectricToolDrill;
import ic2.common.ItemScanner;
import ic2.common.PositionSpec;
import ic2.common.StackUtil;
import ic2.common.TileEntityElecMachine;
import ic2.common.TileEntityPump;
import ic2.platform.AudioManager;
import ic2.platform.AudioSource;
import ic2.platform.Platform;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class TileEntityMiner
extends TileEntityElecMachine
implements IHasGui,
ISidedInventory {
    public int targetX = 0;
    public int targetY = -1;
    public int targetZ = 0;
    public short miningTicker = 0;
    public String stuckOn = null;
    private AudioSource audioSource;

    public TileEntityMiner() {
        super(4, 0, 1000, 32, mod_IC2.enableMinerLapotron ? 3 : 1);
    }

    @Override
    public void n_() {
        super.n_();
        boolean wasOperating = this.isOperating();
        boolean needsInvUpdate = false;
        if (this.isOperating()) {
            --this.energy;
            if (this.inventory[1] != null && yr.e[this.inventory[1].c] instanceof ItemScanner) {
                this.energy -= ElectricItem.charge(this.inventory[1], this.energy, 2, false, false);
            }
            if (this.inventory[3] != null && (yr.e[this.inventory[3].c] instanceof ItemElectricToolDrill || yr.e[this.inventory[3].c] instanceof ItemElectricToolDDrill)) {
                this.energy -= ElectricItem.charge(this.inventory[3], this.energy, 1, false, false);
            }
        }
        if (this.energy <= this.maxEnergy) {
            needsInvUpdate = this.provideEnergy();
        }
        if (wasOperating) {
            needsInvUpdate = this.mine();
        } else if (this.inventory[3] == null) {
            if (this.energy >= 2 && this.canWithdraw()) {
                this.targetY = -1;
                this.miningTicker = (short)(this.miningTicker + 1);
                this.energy -= 2;
                if (this.miningTicker >= 20) {
                    this.miningTicker = 0;
                    needsInvUpdate = this.withdrawPipe();
                }
            } else if (this.isStuck()) {
                this.miningTicker = 0;
            }
        }
        this.setActive(this.isOperating());
        if (wasOperating != this.isOperating()) {
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.j();
        }
    }

    @Override
    public void onUnloaded() {
        if (Platform.isRendering() && this.audioSource != null) {
            AudioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        this.targetX = nbttagcompound.f("targetX");
        this.targetY = nbttagcompound.f("targetY");
        this.targetZ = nbttagcompound.f("targetZ");
        this.miningTicker = nbttagcompound.e("miningTicker");
    }

    @Override
    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("targetX", (int)((short)this.targetX));
        nbttagcompound.a("targetY", (int)((short)this.targetY));
        nbttagcompound.a("targetZ", (int)((short)this.targetZ));
        nbttagcompound.a("miningTicker", this.miningTicker);
    }

    public boolean mine() {
        if (this.targetY < 0) {
            this.aquireTarget();
            return false;
        }
        if (!this.canReachTarget(this.targetX, this.targetY, this.targetZ, true)) {
            int x = this.targetX - this.j;
            int z = this.targetZ - this.l;
            if (Math.abs(x) > Math.abs(z)) {
                this.targetX = x > 0 ? --this.targetX : ++this.targetX;
            } else {
                this.targetZ = z > 0 ? --this.targetZ : ++this.targetZ;
            }
            return false;
        }
        if (!this.canMine(this.i.a(this.targetX, this.targetY, this.targetZ), this.i.e(this.targetX, this.targetY, this.targetZ))) {
            int id = this.i.a(this.targetX, this.targetY, this.targetZ);
            if ((id == pb.A.bO || id == pb.B.bO || id == pb.C.bO || id == pb.D.bO) && this.isAnyPumpConnected()) {
                return false;
            }
            this.miningTicker = (short)-1;
            this.stuckOn = Platform.translateBlockName(pb.m[id]);
            return false;
        }
        this.stuckOn = null;
        this.miningTicker = (short)(this.miningTicker + 1);
        --this.energy;
        if (this.inventory[3].c == Ic2Items.diamondDrill.c) {
            this.miningTicker = (short)(this.miningTicker + 3);
            this.energy -= 14;
        }
        if (this.miningTicker >= 200) {
            this.miningTicker = 0;
            this.mineBlock();
            return true;
        }
        return false;
    }

    public void mineBlock() {
        if (this.inventory[3].a() instanceof ItemElectricToolDrill) {
            ElectricItem.use(this.inventory[3], 50, null);
        } else if (this.inventory[3].a() instanceof ItemElectricToolDDrill) {
            ElectricItem.use(this.inventory[3], 80, null);
        }
        int id = this.i.a(this.targetX, this.targetY, this.targetZ);
        int meta = this.i.e(this.targetX, this.targetY, this.targetZ);
        boolean liquid = false;
        if (id == pb.A.bO || id == pb.B.bO || id == pb.C.bO || id == pb.D.bO) {
            liquid = true;
            if (meta != 0) {
                id = 0;
            }
        }
        if (id != 0) {
            if (!liquid) {
                pb ore = pb.m[id];
                StackUtil.distributeDrop(this, ore.getBlockDropped(this.i, this.targetX, this.targetY, this.targetZ, meta, 0));
            } else {
                if (id == pb.A.bO || id == pb.B.bO) {
                    this.usePump(pb.B.bO);
                }
                if (id == pb.C.bO || id == pb.D.bO) {
                    this.usePump(pb.D.bO);
                }
            }
            this.i.g(this.targetX, this.targetY, this.targetZ, 0);
            this.energy -= 2 * (this.k - this.targetY);
        }
        if (this.targetX == this.j && this.targetZ == this.l) {
            this.i.d(this.targetX, this.targetY, this.targetZ, Ic2Items.miningPipe.c);
            --this.inventory[2].a;
            if (this.inventory[2].a == 0) {
                this.inventory[2] = null;
            }
            this.energy -= 10;
        }
        this.updateMineTip(this.targetY);
        this.targetY = -1;
    }

    public boolean withdrawPipe() {
        int y = this.getPipeTip();
        int blockId = this.i.a(this.j, y, this.l);
        if (blockId != 0) {
            StackUtil.distributeDrop(this, pb.m[blockId].getBlockDropped(this.i, this.j, y, this.l, this.i.e(this.j, y, this.l), 0));
            this.i.g(this.j, y, this.l, 0);
        }
        if (this.inventory[2] != null && this.inventory[2].c != Ic2Items.miningPipe.c && this.inventory[2].c < pb.m.length && pb.m[this.inventory[2].c] != null) {
            this.i.d(this.j, y, this.l, this.inventory[2].c, this.inventory[2].i());
            --this.inventory[2].a;
            if (this.inventory[2].a == 0) {
                this.inventory[2] = null;
            }
            this.updateMineTip(y + 1);
            return true;
        }
        this.updateMineTip(y + 1);
        return false;
    }

    public void updateMineTip(int low) {
        if (low == this.k) {
            return;
        }
        int x = this.j;
        int z = this.l;
        for (int y = this.k - 1; y > low; --y) {
            if (this.i.a(x, y, z) == Ic2Items.miningPipe.c) continue;
            this.i.g(x, y, z, Ic2Items.miningPipe.c);
        }
        this.i.g(x, low, z, Ic2Items.miningPipeTip.c);
    }

    public boolean canReachTarget(int x, int y, int z, boolean ignore) {
        if (this.j == x && this.l == z) {
            return true;
        }
        if (!ignore && !this.canPass(this.i.a(x, y, z))) {
            return false;
        }
        int xdif = x - this.j;
        int zdif = z - this.l;
        if (Math.abs(xdif) > Math.abs(zdif)) {
            x = xdif > 0 ? --x : ++x;
        } else {
            z = zdif > 0 ? --z : ++z;
        }
        return this.canReachTarget(x, y, z, false);
    }

    public void aquireTarget() {
        int y = this.getPipeTip();
        if (y >= this.k || this.inventory[1] == null || !(this.inventory[1].a() instanceof ItemScanner)) {
            this.setTarget(this.j, y - 1, this.l);
            return;
        }
        int scanrange = ((ItemScanner)this.inventory[1].a()).startLayerScan(this.inventory[1]);
        if (scanrange > 0) {
            for (int x = this.j - scanrange; x <= this.j + scanrange; ++x) {
                for (int z = this.l - scanrange; z <= this.l + scanrange; ++z) {
                    int m;
                    int n = this.i.a(x, y, z);
                    if ((!ItemScanner.isValuable(n, m = this.i.e(x, y, z)) || !this.canMine(n, m)) && (!this.isAnyPumpConnected() || this.i.e(x, y, z) != 0 || n != pb.C.bO && n != pb.D.bO)) continue;
                    this.setTarget(x, y, z);
                    return;
                }
            }
        }
        this.setTarget(this.j, y - 1, this.l);
    }

    public void setTarget(int x, int y, int z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    public int getPipeTip() {
        int y = this.k;
        while (this.i.a(this.j, y - 1, this.l) == Ic2Items.miningPipe.c || this.i.a(this.j, y - 1, this.l) == Ic2Items.miningPipeTip.c) {
            --y;
        }
        return y;
    }

    public boolean canPass(int id) {
        return id == 0 || id == pb.A.bO || id == pb.B.bO || id == pb.C.bO || id == pb.D.bO || id == Ic2Items.miner.c || id == Ic2Items.miningPipe.c || id == Ic2Items.miningPipeTip.c;
    }

    public boolean isOperating() {
        return this.energy > 100 && this.canOperate();
    }

    public boolean canOperate() {
        if (this.inventory[2] == null || this.inventory[3] == null) {
            return false;
        }
        if (this.inventory[2].c != Ic2Items.miningPipe.c) {
            return false;
        }
        if (this.inventory[3].c != Ic2Items.miningDrill.c && this.inventory[3].c != Ic2Items.diamondDrill.c) {
            return false;
        }
        return !this.isStuck();
    }

    public boolean isStuck() {
        return this.miningTicker < 0;
    }

    public String getStuckOn() {
        return this.stuckOn;
    }

    public boolean canMine(int id, int meta) {
        if (id == 0) {
            return true;
        }
        if (id == Ic2Items.miningPipe.c || id == Ic2Items.miningPipeTip.c || id == pb.au.bO) {
            return false;
        }
        if ((id == pb.A.bO || id == pb.B.bO || id == pb.C.bO || id == pb.D.bO) && this.isPumpConnected()) {
            return true;
        }
        pb block = pb.m[id];
        if (block.getHardness(meta) < 0.0f) {
            return false;
        }
        if (block.a(meta, false) && block.cd.k()) {
            return true;
        }
        if (id == pb.W.bO) {
            return true;
        }
        if (this.inventory[3] != null && (this.inventory[3].c != Ic2Items.miningDrill.c || this.inventory[3].c != Ic2Items.diamondDrill.c)) {
            try {
                HashMap toolClasses = (HashMap)ModLoader.getPrivateValue(ForgeHooks.class, null, (String)"toolClasses");
                List tc = (List)toolClasses.get(this.inventory[3].c);
                if (tc == null) {
                    return this.inventory[3].b(block);
                }
                Object[] ta = tc.toArray();
                String cls = (String)ta[0];
                int hvl = (Integer)ta[1];
                HashMap toolHarvestLevels = (HashMap)ModLoader.getPrivateValue(ForgeHooks.class, null, (String)"toolHarvestLevels");
                Integer bhl = (Integer)toolHarvestLevels.get(Arrays.asList(block.bO, meta, cls));
                if (bhl == null) {
                    return this.inventory[3].b(block);
                }
                if (bhl > hvl) {
                    return false;
                }
                return this.inventory[3].b(block);
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    public boolean canWithdraw() {
        return this.i.a(this.j, this.k - 1, this.l) == Ic2Items.miningPipe.c || this.i.a(this.j, this.k - 1, this.l) == Ic2Items.miningPipeTip.c;
    }

    public boolean isPumpConnected() {
        if (this.i.b(this.j, this.k + 1, this.l) instanceof TileEntityPump && ((TileEntityPump)this.i.b(this.j, this.k + 1, this.l)).canHarvest()) {
            return true;
        }
        if (this.i.b(this.j, this.k - 1, this.l) instanceof TileEntityPump && ((TileEntityPump)this.i.b(this.j, this.k - 1, this.l)).canHarvest()) {
            return true;
        }
        if (this.i.b(this.j + 1, this.k, this.l) instanceof TileEntityPump && ((TileEntityPump)this.i.b(this.j + 1, this.k, this.l)).canHarvest()) {
            return true;
        }
        if (this.i.b(this.j - 1, this.k, this.l) instanceof TileEntityPump && ((TileEntityPump)this.i.b(this.j - 1, this.k, this.l)).canHarvest()) {
            return true;
        }
        if (this.i.b(this.j, this.k, this.l + 1) instanceof TileEntityPump && ((TileEntityPump)this.i.b(this.j, this.k, this.l + 1)).canHarvest()) {
            return true;
        }
        return this.i.b(this.j, this.k, this.l - 1) instanceof TileEntityPump && ((TileEntityPump)this.i.b(this.j, this.k, this.l - 1)).canHarvest();
    }

    public boolean isAnyPumpConnected() {
        if (this.i.b(this.j, this.k + 1, this.l) instanceof TileEntityPump) {
            return true;
        }
        if (this.i.b(this.j, this.k - 1, this.l) instanceof TileEntityPump) {
            return true;
        }
        if (this.i.b(this.j + 1, this.k, this.l) instanceof TileEntityPump) {
            return true;
        }
        if (this.i.b(this.j - 1, this.k, this.l) instanceof TileEntityPump) {
            return true;
        }
        if (this.i.b(this.j, this.k, this.l + 1) instanceof TileEntityPump) {
            return true;
        }
        return this.i.b(this.j, this.k, this.l - 1) instanceof TileEntityPump;
    }

    public void usePump(int id) {
        if (this.i.b(this.j, this.k + 1, this.l) instanceof TileEntityPump && ((TileEntityPump)this.i.b(this.j, this.k + 1, this.l)).canHarvest()) {
            ((TileEntityPump)this.i.b(this.j, this.k + 1, this.l)).pumpThis(id);
            return;
        }
        if (this.i.b(this.j, this.k - 1, this.l) instanceof TileEntityPump && ((TileEntityPump)this.i.b(this.j, this.k - 1, this.l)).canHarvest()) {
            ((TileEntityPump)this.i.b(this.j, this.k - 1, this.l)).pumpThis(id);
            return;
        }
        if (this.i.b(this.j + 1, this.k, this.l) instanceof TileEntityPump && ((TileEntityPump)this.i.b(this.j + 1, this.k, this.l)).canHarvest()) {
            ((TileEntityPump)this.i.b(this.j + 1, this.k, this.l)).pumpThis(id);
            return;
        }
        if (this.i.b(this.j - 1, this.k, this.l) instanceof TileEntityPump && ((TileEntityPump)this.i.b(this.j - 1, this.k, this.l)).canHarvest()) {
            ((TileEntityPump)this.i.b(this.j - 1, this.k, this.l)).pumpThis(id);
            return;
        }
        if (this.i.b(this.j, this.k, this.l + 1) instanceof TileEntityPump && ((TileEntityPump)this.i.b(this.j, this.k, this.l + 1)).canHarvest()) {
            ((TileEntityPump)this.i.b(this.j, this.k, this.l + 1)).pumpThis(id);
            return;
        }
        if (this.i.b(this.j, this.k, this.l - 1) instanceof TileEntityPump && ((TileEntityPump)this.i.b(this.j, this.k, this.l - 1)).canHarvest()) {
            ((TileEntityPump)this.i.b(this.j, this.k, this.l - 1)).pumpThis(id);
            return;
        }
    }

    @Override
    public String c() {
        return "Miner";
    }

    public int gaugeEnergyScaled(int i) {
        if (this.energy <= 0) {
            return 0;
        }
        int r = this.energy * i / 1000;
        if (r > i) {
            r = i;
        }
        return r;
    }

    @Override
    public ContainerIC2 getGuiContainer(yw entityPlayer) {
        return new ContainerMiner(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(yw entityPlayer) {
        return "GuiMiner";
    }

    @Override
    public void onGuiClosed(yw entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = AudioManager.createSource(this, PositionSpec.Center, "Machines/MinerOp.ogg", true, false, AudioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    public int getStartInventorySide(int side) {
        int backSide;
        int frontSide;
        int rightSide;
        int leftSide;
        switch (this.getFacing()) {
            case 2: {
                leftSide = 4;
                rightSide = 5;
                frontSide = 3;
                backSide = 2;
                break;
            }
            case 3: {
                leftSide = 5;
                rightSide = 4;
                frontSide = 2;
                backSide = 3;
                break;
            }
            case 4: {
                leftSide = 3;
                rightSide = 2;
                frontSide = 5;
                backSide = 4;
                break;
            }
            default: {
                leftSide = 2;
                rightSide = 3;
                frontSide = 4;
                backSide = 5;
            }
        }
        if (side == leftSide || side == frontSide) {
            return 3;
        }
        if (side == rightSide || side == backSide) {
            return 1;
        }
        switch (side) {
            case 0: {
                return 0;
            }
        }
        return 2;
    }

    public int getSizeInventorySide(int side) {
        return 1;
    }
}

