/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import forge.ISidedInventory;
import ic2.api.Direction;
import ic2.api.INetworkTileEntityEventListener;
import ic2.common.ContainerElectricMachine;
import ic2.common.ContainerIC2;
import ic2.common.IHasGui;
import ic2.common.Ic2Items;
import ic2.common.TileEntityElecMachine;
import ic2.platform.AudioManager;
import ic2.platform.AudioSource;
import ic2.platform.NetworkManager;
import ic2.platform.Platform;

public abstract class TileEntityElectricMachine
extends TileEntityElecMachine
implements IHasGui,
INetworkTileEntityEventListener,
ISidedInventory {
    public short progress = 0;
    public int defaultEnergyConsume;
    public int defaultOperationLength;
    public int defaultMaxInput;
    public int defaultEnergyStorage;
    public int energyConsume;
    public int operationLength;
    public float serverChargeLevel;
    public float serverProgress;
    public AudioSource audioSource;
    private static final int EventStart = 0;
    private static final int EventInterrupt = 1;
    private static final int EventStop = 2;

    public TileEntityElectricMachine(int slots, int e, int length, int maxinput) {
        super(slots + 4, 1, e * length + maxinput - 1, maxinput);
        this.defaultEnergyConsume = this.energyConsume = e;
        this.defaultOperationLength = this.operationLength = length;
        this.defaultMaxInput = this.maxInput;
        this.defaultEnergyStorage = e * length;
    }

    @Override
    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        this.progress = nbttagcompound.e("progress");
    }

    @Override
    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("progress", this.progress);
    }

    public float getChargeLevel() {
        float ret;
        if (Platform.isSimulating()) {
            ret = (float)this.energy / (float)(this.maxEnergy - this.maxInput + 1);
            if (ret > 1.0f) {
                ret = 1.0f;
            }
        } else {
            ret = this.serverChargeLevel;
        }
        return ret;
    }

    public float getProgress() {
        float ret;
        if (Platform.isSimulating()) {
            ret = (float)this.progress / (float)this.operationLength;
            if (ret > 1.0f) {
                ret = 1.0f;
            }
        } else {
            ret = this.serverProgress;
        }
        return ret;
    }

    public void setChargeLevel(float chargeLevel) {
        assert (!Platform.isSimulating());
        this.serverChargeLevel = chargeLevel;
    }

    public void setProgress(float progress) {
        assert (!Platform.isSimulating());
        this.serverProgress = progress;
    }

    @Override
    public void n_() {
        super.n_();
        boolean canOperate = this.canOperate();
        if (canOperate) {
            this.setOverclockRates();
        }
        boolean needsInvUpdate = false;
        if (this.energy <= this.energyConsume * this.operationLength && canOperate) {
            needsInvUpdate = this.provideEnergy();
        }
        boolean newActive = this.getActive();
        if (this.progress >= this.operationLength) {
            this.operate();
            needsInvUpdate = true;
            this.progress = 0;
            newActive = false;
            NetworkManager.initiateTileEntityEvent(this, 2, true);
        }
        canOperate = this.canOperate();
        if (!newActive || this.progress == 0) {
            if (canOperate) {
                if (this.energy >= this.energyConsume) {
                    newActive = true;
                    NetworkManager.initiateTileEntityEvent(this, 0, true);
                }
            } else {
                this.progress = 0;
            }
        } else if (!canOperate || this.energy < this.energyConsume) {
            if (!canOperate) {
                this.progress = 0;
            }
            newActive = false;
            NetworkManager.initiateTileEntityEvent(this, 1, true);
        }
        if (newActive) {
            this.progress = (short)(this.progress + 1);
            this.energy -= this.energyConsume;
        }
        if (needsInvUpdate) {
            this.j();
        }
        if (newActive != this.getActive()) {
            this.setActive(newActive);
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (Platform.isRendering() && this.audioSource != null) {
            AudioManager.removeSources(this);
            this.audioSource = null;
        }
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        this.setOverclockRates();
        return super.injectEnergy(directionFrom, amount);
    }

    public void setOverclockRates() {
        int overclockerUpgradeCount = 0;
        int transformerUpgradeCount = 0;
        int energyStorageUpgradeCount = 0;
        for (int i = 0; i < 4; ++i) {
            aan itemStack = this.inventory[i + this.inventory.length - 4];
            if (itemStack == null) continue;
            if (itemStack.a(Ic2Items.overclockerUpgrade)) {
                overclockerUpgradeCount += itemStack.a;
                continue;
            }
            if (itemStack.a(Ic2Items.transformerUpgrade)) {
                transformerUpgradeCount += itemStack.a;
                continue;
            }
            if (!itemStack.a(Ic2Items.energyStorageUpgrade)) continue;
            energyStorageUpgradeCount += itemStack.a;
        }
        if (overclockerUpgradeCount > 32) {
            overclockerUpgradeCount = 32;
        }
        if (transformerUpgradeCount > 10) {
            transformerUpgradeCount = 10;
        }
        this.energyConsume = (int)((double)this.defaultEnergyConsume * Math.pow(1.6, overclockerUpgradeCount));
        this.operationLength = (int)Math.round((double)this.defaultOperationLength * Math.pow(0.7, overclockerUpgradeCount));
        this.maxInput = this.defaultMaxInput * (int)Math.pow(4.0, transformerUpgradeCount);
        this.maxEnergy = this.defaultEnergyStorage + energyStorageUpgradeCount * 10000 + this.maxInput - 1;
        this.tier = transformerUpgradeCount + 1;
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
    }

    @Override
    public boolean provideEnergy() {
        if (this.inventory[this.fuelslot] != null && this.inventory[this.fuelslot].a() == yr.aC) {
            this.energy += this.defaultEnergyConsume * this.defaultOperationLength;
            --this.inventory[this.fuelslot].a;
            if (this.inventory[this.fuelslot].a <= 0) {
                this.inventory[this.fuelslot] = null;
            }
            return true;
        }
        return super.provideEnergy();
    }

    public void operate() {
        aan processResult;
        if (!this.canOperate()) {
            return;
        }
        if (this.inventory[0].a().m()) {
            processResult = this.getResultFor(this.inventory[0], false).k();
            this.inventory[0] = new aan(this.inventory[0].a().l());
        } else {
            processResult = this.getResultFor(this.inventory[0], true).k();
        }
        if (this.inventory[0].a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[2] == null) {
            this.inventory[2] = processResult;
        } else {
            this.inventory[2].a += processResult.a;
        }
    }

    public boolean canOperate() {
        if (this.inventory[0] == null) {
            return false;
        }
        aan processResult = this.getResultFor(this.inventory[0], false);
        if (processResult == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].a(processResult)) {
            return false;
        }
        return this.inventory[2].a + processResult.a <= this.inventory[2].c();
    }

    public abstract aan getResultFor(aan var1, boolean var2);

    @Override
    public abstract String c();

    @Override
    public ContainerIC2 getGuiContainer(yw entityPlayer) {
        return new ContainerElectricMachine(entityPlayer, this);
    }

    @Override
    public void onGuiClosed(yw entityPlayer) {
    }

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    @Override
    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = AudioManager.createSource(this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                AudioManager.playOnce(this, this.getInterruptSoundFile());
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    public int getStartInventorySide(int side) {
        switch (side) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        return 2;
    }

    public int getSizeInventorySide(int side) {
        return 1;
    }
}

