/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.api.IElectricItem;
import ic2.api.IEnergySink;
import ic2.common.ElectricItem;
import ic2.common.EnergyNet;
import ic2.common.Ic2Items;
import ic2.common.TileEntityMachine;
import ic2.platform.Platform;

public abstract class TileEntityElecMachine
extends TileEntityMachine
implements IEnergySink {
    public int energy = 0;
    public int fuelslot;
    public int maxEnergy;
    public int maxInput;
    public int tier = 0;
    public boolean addedToEnergyNet = false;

    public TileEntityElecMachine(int slots, int fuelslot, int maxenergy, int maxinput) {
        super(slots);
        this.fuelslot = fuelslot;
        this.maxEnergy = maxenergy;
        this.maxInput = maxinput;
        this.tier = 1;
    }

    public TileEntityElecMachine(int slots, int fuelslot, int maxenergy, int maxinput, int tier) {
        super(slots);
        this.fuelslot = fuelslot;
        this.maxEnergy = maxenergy;
        this.maxInput = maxinput;
        this.tier = tier;
    }

    @Override
    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        this.energy = nbttagcompound.f("energy");
    }

    @Override
    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("energy", this.energy);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (Platform.isSimulating()) {
            EnergyNet.getForWorld(this.i).addTileEntity(this);
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (Platform.isSimulating() && this.addedToEnergyNet) {
            EnergyNet.getForWorld(this.i).removeTileEntity(this);
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public boolean provideEnergy() {
        if (this.inventory[this.fuelslot] == null) {
            return false;
        }
        int id = this.inventory[this.fuelslot].c;
        if (yr.e[id] instanceof IElectricItem) {
            if (!((IElectricItem)yr.e[id]).canProvideEnergy()) {
                return false;
            }
            int transfer = ElectricItem.discharge(this.inventory[this.fuelslot], this.maxEnergy - this.energy, this.tier, false, false);
            this.energy += transfer;
            return transfer > 0;
        }
        if (id == yr.aC.bQ) {
            this.energy += this.maxEnergy;
            --this.inventory[this.fuelslot].a;
            if (this.inventory[this.fuelslot].a <= 0) {
                this.inventory[this.fuelslot] = null;
            }
            return true;
        }
        if (id == Ic2Items.suBattery.c) {
            this.energy += 1000;
            --this.inventory[this.fuelslot].a;
            if (this.inventory[this.fuelslot].a <= 0) {
                this.inventory[this.fuelslot] = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean demandsEnergy() {
        return this.energy <= this.maxEnergy - this.maxInput;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.maxInput) {
            mod_IC2.explodeMachineAt(this.i, this.j, this.k, this.l);
            return 0;
        }
        this.energy += amount;
        int re = 0;
        if (this.energy > this.maxEnergy) {
            re = this.energy - this.maxEnergy;
            this.energy = this.maxEnergy;
        }
        return re;
    }

    @Override
    public boolean acceptsEnergyFrom(kw emitter, Direction direction) {
        return true;
    }

    public boolean isRedstonePowered() {
        return this.i.x(this.j, this.k, this.l);
    }
}

