/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.INetworkDataProvider;
import ic2.api.INetworkUpdateListener;
import ic2.api.IWrenchable;
import ic2.common.ITickCallback;
import ic2.platform.NetworkManager;
import ic2.platform.Platform;
import ic2.platform.TextureIndex;
import java.util.List;
import java.util.Vector;

public class TileEntityBlock
extends kw
implements INetworkDataProvider,
INetworkUpdateListener,
IWrenchable {
    private boolean active = false;
    private short facing = 0;
    public boolean prevActive = false;
    public short prevFacing = 0;
    private boolean loaded = false;

    public void m() {
        super.m();
        if (!this.loaded) {
            mod_IC2.addSingleTickCallback(this.i, new ITickCallback(){

                @Override
                public void tickCallback(xd world) {
                    if (!TileEntityBlock.this.l() && TileEntityBlock.this.i != null) {
                        TileEntityBlock.this.onLoaded();
                    } else {
                        System.out.println("[IC2] " + TileEntityBlock.this + " (" + TileEntityBlock.this.j + "," + TileEntityBlock.this.k + "," + TileEntityBlock.this.l + ") was not added, isInvalid=" + TileEntityBlock.this.l() + ", worldObj=" + TileEntityBlock.this.i);
                    }
                }
            });
        }
    }

    public void h() {
        super.h();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onLoaded() {
        if (!Platform.isSimulating()) {
            NetworkManager.requestInitialData(this);
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        this.loaded = false;
    }

    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        this.prevFacing = this.facing = nbttagcompound.e("facing");
    }

    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("facing", this.facing);
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (this.prevActive != active) {
            NetworkManager.updateTileEntityField(this, "active");
        }
        this.prevActive = active;
    }

    public void setActiveWithoutNotify(boolean active) {
        this.active = active;
        this.prevActive = active;
    }

    @Override
    public short getFacing() {
        return this.facing;
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>(2);
        ret.add("active");
        ret.add("facing");
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.active || field.equals("facing") && this.prevFacing != this.facing) {
            int blockId = this.i.a(this.j, this.k, this.l);
            if (blockId < pb.m.length && pb.m[blockId] != null) {
                pb block = pb.m[blockId];
                boolean newActive = this.active;
                short newFacing = this.facing;
                this.active = this.prevActive;
                this.facing = this.prevFacing;
                int[] textureIndex = new int[6];
                for (int side = 0; side < 6; ++side) {
                    textureIndex[side] = Platform.getBlockTexture(block, this.i, this.j, this.k, this.l, side);
                }
                this.active = newActive;
                this.facing = newFacing;
                boolean found = false;
                for (int side = 0; side < 6; ++side) {
                    int newTextureIndex = Platform.getBlockTexture(block, this.i, this.j, this.k, this.l, side);
                    if (textureIndex[side] == newTextureIndex || TextureIndex.get(blockId, textureIndex[side]) == TextureIndex.get(blockId, newTextureIndex)) continue;
                    this.i.k(this.j, this.k, this.l);
                    found = true;
                    break;
                }
            } else {
                System.out.println("[IC2] Invalid TE at " + this.j + "/" + this.k + "/" + this.l + ", no corresponding block");
            }
            this.prevActive = this.active;
            this.prevFacing = this.facing;
        }
    }

    @Override
    public boolean wrenchCanSetFacing(yw entityPlayer, int side) {
        return false;
    }

    @Override
    public void setFacing(short facing) {
        this.facing = facing;
        if (this.prevFacing != facing) {
            NetworkManager.updateTileEntityField(this, "facing");
        }
        this.prevFacing = facing;
    }

    @Override
    public boolean wrenchCanRemove(yw entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }
}

