/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;

public class AabbUtil {
    public static Direction getIntersection(bo origin, bo direction, wu bbox, bo intersection) {
        double length = direction.d();
        bo normalizedDirection = bo.a((double)(direction.a / length), (double)(direction.b / length), (double)(direction.c / length));
        Direction intersectingDirection = AabbUtil.intersects(origin, normalizedDirection, bbox);
        if (intersectingDirection == null) {
            return null;
        }
        bo planeOrigin = normalizedDirection.a < 0.0 && normalizedDirection.b < 0.0 && normalizedDirection.c < 0.0 ? bo.a((double)bbox.d, (double)bbox.e, (double)bbox.f) : (normalizedDirection.a < 0.0 && normalizedDirection.b < 0.0 && normalizedDirection.c >= 0.0 ? bo.a((double)bbox.d, (double)bbox.e, (double)bbox.c) : (normalizedDirection.a < 0.0 && normalizedDirection.b >= 0.0 && normalizedDirection.c < 0.0 ? bo.a((double)bbox.d, (double)bbox.b, (double)bbox.f) : (normalizedDirection.a < 0.0 && normalizedDirection.b >= 0.0 && normalizedDirection.c >= 0.0 ? bo.a((double)bbox.d, (double)bbox.b, (double)bbox.c) : (normalizedDirection.a >= 0.0 && normalizedDirection.b < 0.0 && normalizedDirection.c < 0.0 ? bo.a((double)bbox.a, (double)bbox.e, (double)bbox.f) : (normalizedDirection.a >= 0.0 && normalizedDirection.b < 0.0 && normalizedDirection.c >= 0.0 ? bo.a((double)bbox.a, (double)bbox.e, (double)bbox.c) : (normalizedDirection.a >= 0.0 && normalizedDirection.b >= 0.0 && normalizedDirection.c < 0.0 ? bo.a((double)bbox.a, (double)bbox.b, (double)bbox.f) : bo.a((double)bbox.a, (double)bbox.b, (double)bbox.c)))))));
        bo planeNormalVector = null;
        switch (intersectingDirection) {
            case XN: 
            case XP: {
                planeNormalVector = bo.a((double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case YN: 
            case YP: {
                planeNormalVector = bo.a((double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case ZN: 
            case ZP: {
                planeNormalVector = bo.a((double)0.0, (double)0.0, (double)1.0);
            }
        }
        bo newIntersection = AabbUtil.getIntersectionWithPlane(origin, normalizedDirection, planeOrigin, planeNormalVector);
        intersection.a = newIntersection.a;
        intersection.b = newIntersection.b;
        intersection.c = newIntersection.c;
        return intersectingDirection;
    }

    public static Direction intersects(bo origin, bo direction, wu bbox) {
        double[] ray = AabbUtil.getRay(origin, direction);
        if (direction.a < 0.0 && direction.b < 0.0 && direction.c < 0.0) {
            if (origin.a < bbox.a) {
                return null;
            }
            if (origin.b < bbox.b) {
                return null;
            }
            if (origin.c < bbox.c) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) < 0.0) {
                return Direction.ZP;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) < 0.0) {
                return Direction.YP;
            }
            return Direction.XP;
        }
        if (direction.a < 0.0 && direction.b < 0.0 && direction.c >= 0.0) {
            if (origin.a < bbox.a) {
                return null;
            }
            if (origin.b < bbox.b) {
                return null;
            }
            if (origin.c > bbox.f) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) > 0.0) {
                return Direction.XP;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) < 0.0) {
                return Direction.YP;
            }
            return Direction.ZN;
        }
        if (direction.a < 0.0 && direction.b >= 0.0 && direction.c < 0.0) {
            if (origin.a < bbox.a) {
                return null;
            }
            if (origin.b > bbox.e) {
                return null;
            }
            if (origin.c < bbox.c) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) > 0.0) {
                return Direction.ZP;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) < 0.0) {
                return Direction.XP;
            }
            return Direction.YN;
        }
        if (direction.a < 0.0 && direction.b >= 0.0 && direction.c >= 0.0) {
            if (origin.a < bbox.a) {
                return null;
            }
            if (origin.b > bbox.e) {
                return null;
            }
            if (origin.c > bbox.f) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) > 0.0) {
                return Direction.YN;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) < 0.0) {
                return Direction.ZN;
            }
            return Direction.XP;
        }
        if (direction.a >= 0.0 && direction.b < 0.0 && direction.c < 0.0) {
            if (origin.a > bbox.d) {
                return null;
            }
            if (origin.b < bbox.b) {
                return null;
            }
            if (origin.c < bbox.c) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) < 0.0) {
                return Direction.XN;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) < 0.0) {
                return Direction.ZP;
            }
            return Direction.YP;
        }
        if (direction.a >= 0.0 && direction.b < 0.0 && direction.c >= 0.0) {
            if (origin.a > bbox.d) {
                return null;
            }
            if (origin.b < bbox.b) {
                return null;
            }
            if (origin.c > bbox.f) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.CG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) > 0.0) {
                return Direction.ZN;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) < 0.0) {
                return Direction.XN;
            }
            return Direction.YP;
        }
        if (direction.a >= 0.0 && direction.b >= 0.0 && direction.c < 0.0) {
            if (origin.a > bbox.d) {
                return null;
            }
            if (origin.b > bbox.e) {
                return null;
            }
            if (origin.c < bbox.c) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.HG, bbox)) < 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.FG, bbox)) > 0.0) {
                return null;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) > 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) > 0.0) {
                return Direction.XN;
            }
            if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) < 0.0) {
                return Direction.YN;
            }
            return Direction.ZP;
        }
        if (origin.a > bbox.d) {
            return null;
        }
        if (origin.b > bbox.e) {
            return null;
        }
        if (origin.c > bbox.f) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EF, bbox)) < 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.EH, bbox)) > 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DH, bbox)) < 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.DC, bbox)) > 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BC, bbox)) < 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.BF, bbox)) > 0.0) {
            return null;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AB, bbox)) < 0.0 && AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AE, bbox)) > 0.0) {
            return Direction.XN;
        }
        if (AabbUtil.side(ray, AabbUtil.getEdgeRay(Edge.AD, bbox)) < 0.0) {
            return Direction.ZN;
        }
        return Direction.YN;
    }

    private static double[] getRay(bo origin, bo direction) {
        double[] ret = new double[]{origin.a * direction.b - direction.a * origin.b, origin.a * direction.c - direction.a * origin.c, -direction.a, origin.b * direction.c - direction.b * origin.c, -direction.c, direction.b};
        return ret;
    }

    private static double[] getEdgeRay(Edge edge, wu bbox) {
        switch (edge) {
            case AD: {
                return new double[]{-bbox.b, -bbox.c, -1.0, 0.0, 0.0, 0.0};
            }
            case AB: {
                return new double[]{bbox.a, 0.0, 0.0, -bbox.c, 0.0, 1.0};
            }
            case AE: {
                return new double[]{0.0, bbox.a, 0.0, bbox.b, -1.0, 0.0};
            }
            case DC: {
                return new double[]{bbox.d, 0.0, 0.0, -bbox.c, 0.0, 1.0};
            }
            case DH: {
                return new double[]{0.0, bbox.d, 0.0, bbox.b, -1.0, 0.0};
            }
            case BC: {
                return new double[]{-bbox.e, -bbox.c, -1.0, 0.0, 0.0, 0.0};
            }
            case BF: {
                return new double[]{0.0, bbox.a, 0.0, bbox.e, -1.0, 0.0};
            }
            case EH: {
                return new double[]{-bbox.b, -bbox.f, -1.0, 0.0, 0.0, 0.0};
            }
            case EF: {
                return new double[]{bbox.a, 0.0, 0.0, -bbox.f, 0.0, 1.0};
            }
            case CG: {
                return new double[]{0.0, bbox.d, 0.0, bbox.e, -1.0, 0.0};
            }
            case FG: {
                return new double[]{-bbox.e, -bbox.f, -1.0, 0.0, 0.0, 0.0};
            }
            case HG: {
                return new double[]{bbox.d, 0.0, 0.0, -bbox.f, 0.0, 1.0};
            }
        }
        return new double[0];
    }

    private static double side(double[] ray1, double[] ray2) {
        return ray1[2] * ray2[3] + ray1[5] * ray2[1] + ray1[4] * ray2[0] + ray1[1] * ray2[5] + ray1[0] * ray2[4] + ray1[3] * ray2[2];
    }

    private static bo getIntersectionWithPlane(bo origin, bo direction, bo planeOrigin, bo planeNormalVector) {
        double distance = AabbUtil.getDistanceToPlane(origin, direction, planeOrigin, planeNormalVector);
        return bo.a((double)(origin.a + direction.a * distance), (double)(origin.b + direction.b * distance), (double)(origin.c + direction.c * distance));
    }

    private static double getDistanceToPlane(bo origin, bo direction, bo planeOrigin, bo planeNormalVector) {
        bo base = bo.a((double)(planeOrigin.a - origin.a), (double)(planeOrigin.b - origin.b), (double)(planeOrigin.c - origin.c));
        return AabbUtil.dotProduct(base, planeNormalVector) / AabbUtil.dotProduct(direction, planeNormalVector);
    }

    private static double dotProduct(bo a, bo b) {
        return a.a * b.a + a.b * b.b + a.c * b.c;
    }

    static enum Edge {
        AD,
        AB,
        AE,
        DC,
        DH,
        BC,
        BF,
        EH,
        EF,
        CG,
        FG,
        HG;

    }
}

