/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.circuits.ChipsetManager;
import forestry.api.core.ForestryBlock;
import forestry.api.fuels.GeneratorFuel;
import forestry.api.liquids.LiquidStack;
import forestry.core.circuits.Circuit;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.GadgetManager;
import forestry.energy.BlockEngine;
import forestry.energy.GuiHandlerEnergy;
import forestry.energy.PackagesEnergy;
import forestry.energy.circuits.CircuitElectricBoost;
import forestry.energy.circuits.CircuitElectricChoke;
import forestry.energy.circuits.CircuitElectricEfficiency;
import forestry.energy.circuits.CircuitFireDampener;
import forestry.plugins.NativePlugin;
import forge.IGuiHandler;

public class PluginForestryEnergy
extends NativePlugin {
    @Override
    public boolean isAvailable() {
        return !Config.disableEnergy;
    }

    @Override
    public String getDescription() {
        return "Native Energy";
    }

    @Override
    public void preInit() {
        super.preInit();
        ForestryBlock.engine = new BlockEngine(Config.getOrCreateBlockIdProperty("engine", 204)).a("engine");
    }

    @Override
    public void doInit() {
        super.doInit();
        GeneratorFuel.fuels.put(ForestryItem.liquidBiofuel.bP, new GeneratorFuel(new LiquidStack(ForestryItem.liquidBiofuel, 1), 32, 2));
        GeneratorFuel.fuels.put(ForestryItem.liquidBiomass.bP, new GeneratorFuel(new LiquidStack(ForestryItem.liquidBiomass, 1), 8, 1));
        Circuit.energyElectricChoke1 = new CircuitElectricChoke(1);
        Circuit.energyFireDampener1 = new CircuitFireDampener(2);
        Circuit.energyElectricEfficiency1 = new CircuitElectricEfficiency(3);
        Circuit.energyElectricBoost1 = new CircuitElectricBoost(4, 2, 7, 2, "electric.boost.1", "engineTin", new String[]{"Increases output by 2 MJ/t", "Increases intake by 7 EU/t"});
        Circuit.energyElectricBoost2 = new CircuitElectricBoost(5, 2, 15, 4, "electric.boost.2", "engineTin", new String[]{"Increases output by 4 MJ/t", "Increases intake by 15 EU/t"});
    }

    @Override
    protected void registerPackages() {
        GadgetManager.registerEnginePackage(0, PackagesEnergy.getEngineBronzePackage());
        GadgetManager.registerEnginePackage(1, PackagesEnergy.getEngineCopperPackage());
        GadgetManager.registerEnginePackage(2, PackagesEnergy.getEngineTinPackage());
        GadgetManager.registerMachinePackage(4, PackagesEnergy.getGeneratorPackage());
    }

    @Override
    protected void registerItems() {
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerRecipes() {
        ChipsetManager.solderManager.addRecipe(new kp(ForestryItem.tubes, 1, 0), Circuit.energyElectricChoke1);
        ChipsetManager.solderManager.addRecipe(new kp(ForestryItem.tubes, 1, 1), Circuit.energyElectricBoost1);
        ChipsetManager.solderManager.addRecipe(new kp(ForestryItem.tubes, 1, 2), Circuit.energyElectricBoost2);
        ChipsetManager.solderManager.addRecipe(new kp(ForestryItem.tubes, 1, 3), Circuit.energyElectricEfficiency1);
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerEnergy();
    }
}

