/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.core.ForestryAPI;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.GuiId;
import forestry.core.utils.GenericInventoryAdapter;
import forestry.core.utils.StackUtils;
import forestry.mail.IStamps;
import forestry.mail.PostOffice;

public class MachinePhilatelist
extends Machine {
    public static final short SLOT_FILTER = 0;
    public static final short SLOT_BUFFER_1 = 1;
    public static final short SLOT_BUFFER_COUNT = 27;
    private GenericInventoryAdapter inventory = new GenericInventoryAdapter(28, "INV");

    public MachinePhilatelist(TileMachine tile) {
        super(tile);
    }

    @Override
    public String getName() {
        return "tile.mill.7";
    }

    @Override
    public void openGui(ih player, ni tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.PhilatelistGUI.ordinal(), this.tile.k, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        this.inventory.b(nbttagcompound);
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        this.inventory.a(nbttagcompound);
    }

    @Override
    public void updateServerSide() {
        if (this.tile.k.o() % 20L * 10L != 0L) {
            return;
        }
        kp stamp = null;
        if (this.inventory.g_(0) == null) {
            stamp = PostOffice.getPostOffice(this.tile.k).getAnyStamp(1);
        } else {
            kp filter = this.inventory.g_(0);
            if (filter.a() instanceof IStamps) {
                stamp = PostOffice.getPostOffice(this.tile.k).getAnyStamp(((IStamps)filter.a()).getPostage(filter), 1);
            }
        }
        if (stamp == null) {
            return;
        }
        StackUtils.stowInInventory(stamp, this.inventory, true, 1, 27);
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return false;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(ew container, ff iCrafting) {
    }

    @Override
    public int c() {
        return this.inventory.c();
    }

    @Override
    public kp g_(int i) {
        return this.inventory.g_(i);
    }

    @Override
    public kp a(int i, int j) {
        return this.inventory.a(i, j);
    }

    @Override
    public void a(int i, kp itemstack) {
        this.inventory.a(i, itemstack);
    }

    @Override
    public kp b(int slot) {
        return this.inventory.b(slot);
    }

    @Override
    public void G_() {
        this.inventory.G_();
    }

    @Override
    public int getStartInventorySide(int side) {
        return 1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return 27;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(qj tile) {
            return new MachinePhilatelist((TileMachine)tile);
        }
    }
}

