/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.interfaces.IInventoriedItem;
import forestry.core.items.ItemForestry;
import forestry.core.network.GuiId;
import forestry.core.unity.IItemIconByDamage;
import forestry.core.unity.IItemNBTSynched;
import forestry.core.unity.IItemTooltipped;
import forestry.core.utils.ItemInventory;
import forestry.core.utils.StringUtil;
import forestry.mail.ILetter;
import forestry.mail.Letter;
import java.util.List;

public class ItemLetter
extends ItemForestry
implements IInventoriedItem,
IItemTooltipped,
IItemNBTSynched,
IItemIconByDamage {
    public ItemLetter(int i) {
        super(i);
        this.e(1);
    }

    public kp a(kp itemstack, ge world, ih entityplayer) {
        if (!Proxy.isMultiplayerWorld()) {
            entityplayer.openGui((BaseMod)ForestryAPI.instance, GuiId.LetterGUI.ordinal(), world, (int)entityplayer.bm, (int)entityplayer.bn, (int)entityplayer.bo);
        }
        return itemstack;
    }

    public boolean i() {
        return true;
    }

    @Override
    public boolean func_46056_k() {
        return true;
    }

    @Override
    public int getIconFromDamage(int damage) {
        int state = ItemLetter.getState(damage);
        int size = ItemLetter.getSize(damage);
        int icon = 52;
        if (state > 2) {
            icon = 55;
        } else if (state > 1) {
            icon = 54;
        } else if (state > 0) {
            icon = 53;
        }
        return icon += size * 16;
    }

    public static int encodeMeta(int state, int size) {
        int meta = size << 4;
        size = ItemLetter.getSize(meta |= state);
        state = ItemLetter.getState(meta);
        return meta;
    }

    public static int getState(int meta) {
        return meta & 0xF;
    }

    public static int getSize(int meta) {
        return meta >> 4;
    }

    @Override
    public void addInformation(kp itemstack, List list) {
        ph nbttagcompound = itemstack.o();
        if (nbttagcompound == null) {
            list.add("<" + StringUtil.localize("gui.blank") + ">");
            return;
        }
        Letter letter = new Letter(nbttagcompound);
        letter.addTooltip(list);
    }

    public static ILetter getLetter(kp itemstack) {
        if (itemstack == null) {
            return null;
        }
        if (!ItemLetter.isLetter(itemstack)) {
            return null;
        }
        if (itemstack.o() == null) {
            return null;
        }
        return new Letter(itemstack.o());
    }

    public static boolean isLetter(kp itemstack) {
        if (itemstack == null) {
            return false;
        }
        return itemstack.c == ForestryItem.letters.bP;
    }

    public static int getType(ILetter letter) {
        int count = letter.countAttachments();
        if (count > 5) {
            return 2;
        }
        if (count > 1) {
            return 1;
        }
        return 0;
    }

    public static class LetterInventory
    extends ItemInventory
    implements IErrorSource,
    IHintSource {
        ILetter letter;

        protected LetterInventory() {
        }

        public LetterInventory(kp itemstack) {
            this.parent = itemstack;
            this.isItemInventory = true;
            this.setUID();
            this.a(itemstack.o());
        }

        public ILetter getLetter() {
            return this.letter;
        }

        @Override
        public void onGuiSaved(ih player) {
            super.onGuiSaved(player);
            int state = ItemLetter.getState(this.parent.h());
            if (state >= 2) {
                if (state == 2 && this.letter.countAttachments() <= 0) {
                    this.parent.b(ItemLetter.encodeMeta(3, ItemLetter.getSize(this.parent.h())));
                }
                return;
            }
            int type = ItemLetter.getType(this.letter);
            if (this.parent != null && this.letter.isMailable() && this.letter.isPostPaid()) {
                this.parent.b(ItemLetter.encodeMeta(1, type));
            } else {
                this.parent.b(ItemLetter.encodeMeta(0, type));
            }
        }

        @Override
        public void a(ph nbttagcompound) {
            if (nbttagcompound == null) {
                return;
            }
            this.letter = new Letter(nbttagcompound);
        }

        @Override
        public void b(ph nbttagcompound) {
            this.letter.b(nbttagcompound);
        }

        @Override
        public kp a(int i, int j) {
            return this.letter.a(i, j);
        }

        @Override
        public void a(int i, kp itemstack) {
            this.letter.a(i, itemstack);
        }

        @Override
        public kp g_(int i) {
            return this.letter.g_(i);
        }

        @Override
        public int c() {
            return this.letter.c();
        }

        @Override
        public String e() {
            return this.letter.e();
        }

        @Override
        public int a() {
            return this.letter.a();
        }

        @Override
        public void G_() {
            this.letter.G_();
        }

        @Override
        public boolean a(ih entityplayer) {
            return this.letter.a(entityplayer);
        }

        @Override
        public void f() {
        }

        @Override
        public void g() {
        }

        @Override
        public kp b(int slot) {
            return this.letter.b(slot);
        }

        @Override
        public boolean throwsErrors() {
            return true;
        }

        @Override
        public EnumErrorCode getErrorState() {
            if (!this.letter.hasRecipient()) {
                return EnumErrorCode.NORECIPIENT;
            }
            if (!this.letter.isProcessed() && !this.letter.isPostPaid()) {
                return EnumErrorCode.NOTPOSTPAID;
            }
            return EnumErrorCode.OK;
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("letter") != null && ((String[])Config.hints.get("letter")).length > 0;
        }

        @Override
        public String[] getHints() {
            return (String[])Config.hints.get("letter");
        }
    }
}

