/*
 * Decompiled with CFR 0.152.
 */
package forestry.food;

import forestry.api.core.ForestryAPI;
import forestry.api.food.BeverageManager;
import forestry.api.food.IBeverageEffect;
import forestry.api.food.IInfuserManager;
import forestry.api.food.IIngredientManager;
import forestry.core.Proxy;
import forestry.core.config.ForestryItem;
import forestry.core.items.ItemForestry;
import forestry.core.network.GuiId;
import forestry.food.BeverageEffect;
import forestry.food.ItemBeverage;
import java.util.ArrayList;
import java.util.Arrays;

public class ItemInfuser
extends ItemForestry {
    public ItemInfuser(int i) {
        super(i);
        this.bQ = 1;
    }

    public kp a(kp itemstack, ge world, ih entityplayer) {
        if (!Proxy.isMultiplayerWorld()) {
            entityplayer.openGui((BaseMod)ForestryAPI.instance, GuiId.InfuserGUI.ordinal(), world, (int)entityplayer.bm, (int)entityplayer.bn, (int)entityplayer.bo);
        }
        return itemstack;
    }

    public static void initialize() {
        BeverageManager.ingredientManager.addIngredient(new kp(ForestryItem.pollen, 1, 0), "Strong Curative");
        BeverageManager.ingredientManager.addIngredient(new kp(ForestryItem.pollen, 1, 1), "Weak Curative");
        BeverageManager.infuserManager.addMixture(1, new kp(ForestryItem.pollen, 1, 0), BeverageEffect.strongAntidote);
        BeverageManager.infuserManager.addMixture(1, new kp(ForestryItem.pollen, 1, 1), BeverageEffect.weakAntidote);
    }

    public static class InfuserInventory
    implements ni {
        private kp[] inventoryStacks = new kp[6];
        private short inputSlot = 0;
        private short outputSlot = 1;
        private short ingredientSlot1 = (short)2;

        private void trySeasoning() {
            kp[] toRemove;
            if (this.inventoryStacks[this.inputSlot] == null) {
                return;
            }
            if (this.inventoryStacks[this.outputSlot] != null) {
                return;
            }
            if (!this.inventoryStacks[this.inputSlot].a(new kp(ForestryItem.beverage, 1, 0))) {
                return;
            }
            kp[] ingredients = new kp[4];
            System.arraycopy(this.inventoryStacks, this.ingredientSlot1, ingredients, 0, 4);
            if (!BeverageManager.infuserManager.hasMixtures(ingredients)) {
                return;
            }
            kp seasoned = BeverageManager.infuserManager.getSeasoned(this.inventoryStacks[this.inputSlot], ingredients);
            if (seasoned == null) {
                return;
            }
            block0: for (kp templ : toRemove = BeverageManager.infuserManager.getRequired(ingredients)) {
                kp ghost = templ.j();
                for (int i = this.ingredientSlot1; i < this.c(); ++i) {
                    if (this.inventoryStacks[i] == null) continue;
                    if (ghost.a <= 0) continue block0;
                    if ((ghost.h() < 0 || !this.inventoryStacks[i].a(ghost)) && (ghost.h() >= 0 || ghost.c != this.inventoryStacks[i].c)) continue;
                    kp removed = this.a(i, 1);
                    ghost.a -= removed.a;
                }
            }
            this.a((int)this.inputSlot, 1);
            this.inventoryStacks[this.outputSlot] = seasoned;
        }

        public kp a(int i, int j) {
            if (this.inventoryStacks[i] == null) {
                return null;
            }
            if (this.inventoryStacks[i].a <= j) {
                kp product = this.inventoryStacks[i];
                this.inventoryStacks[i] = null;
                return product;
            }
            kp product = this.inventoryStacks[i].a(j);
            if (this.inventoryStacks[i].a == 0) {
                this.inventoryStacks[i] = null;
            }
            return product;
        }

        public void G_() {
            if (Proxy.isMultiplayerWorld()) {
                return;
            }
            this.trySeasoning();
        }

        public void a(int i, kp itemstack) {
            this.inventoryStacks[i] = itemstack;
        }

        public kp g_(int i) {
            return this.inventoryStacks[i];
        }

        public int c() {
            return this.inventoryStacks.length;
        }

        public String e() {
            return "Infuser";
        }

        public int a() {
            return 64;
        }

        public boolean a(ih entityplayer) {
            return true;
        }

        public void f() {
        }

        public void g() {
        }

        public kp b(int slot) {
            if (this.inventoryStacks[slot] == null) {
                return null;
            }
            kp toReturn = this.inventoryStacks[slot];
            this.inventoryStacks[slot] = null;
            return toReturn;
        }
    }

    public static class IngredientManager
    implements IIngredientManager {
        private ArrayList ingredients = new ArrayList();

        @Override
        public void addIngredient(kp ingredient, String description) {
            this.ingredients.add(new Ingredient(ingredient, description));
        }

        @Override
        public String getDescription(kp itemstack) {
            if (itemstack == null) {
                return null;
            }
            for (Ingredient ingredient : this.ingredients) {
                if (ingredient.ingredient.h() < 0 && ingredient.ingredient.c == itemstack.c) {
                    return ingredient.description;
                }
                if (ingredient.ingredient.h() < 0 || !ingredient.ingredient.a(itemstack)) continue;
                return ingredient.description;
            }
            return null;
        }
    }

    public static class Ingredient {
        public final kp ingredient;
        public final String description;

        public Ingredient(kp ingredient, String description) {
            this.ingredient = ingredient;
            this.description = description;
        }
    }

    public static class MixtureManager
    implements IInfuserManager {
        private ArrayList mixtures = new ArrayList();

        @Override
        public void addMixture(int meta, kp ingredient, IBeverageEffect effect) {
            this.mixtures.add(new Mixture(meta, ingredient, effect));
        }

        @Override
        public void addMixture(int meta, kp[] ingredients, IBeverageEffect effect) {
            this.mixtures.add(new Mixture(meta, ingredients, effect));
        }

        public boolean isIngredient(kp itemstack) {
            for (Mixture ingredient : this.mixtures) {
                if (!ingredient.isIngredient(itemstack)) continue;
                return true;
            }
            return false;
        }

        private Mixture[] getMatchingMixtures(kp[] ingredients) {
            ArrayList<Mixture> matches = new ArrayList<Mixture>();
            for (Mixture mixture : this.mixtures) {
                if (!mixture.matches(ingredients)) continue;
                matches.add(mixture);
            }
            return matches.toArray(new Mixture[0]);
        }

        @Override
        public boolean hasMixtures(kp[] ingredients) {
            return this.getMatchingMixtures(ingredients).length > 0;
        }

        @Override
        public kp[] getRequired(kp[] ingredients) {
            Mixture[] mixtures = this.getMatchingMixtures(ingredients);
            ArrayList<kp> required = new ArrayList<kp>();
            for (Mixture mixture : mixtures) {
                required.addAll(Arrays.asList(mixture.getIngredients()));
            }
            return required.toArray(new kp[0]);
        }

        @Override
        public kp getSeasoned(kp base, kp[] ingredients) {
            Mixture[] mixtures = this.getMatchingMixtures(ingredients);
            ArrayList<IBeverageEffect> effects = new ArrayList<IBeverageEffect>();
            effects.addAll(Arrays.asList(((ItemBeverage)base.a()).beverages[base.h()].loadEffects(base)));
            int weight = 0;
            int meta = 0;
            for (Mixture mixture : mixtures) {
                effects.add(mixture.getEffect());
                if (mixture.getWeight() <= weight) continue;
                weight = mixture.getWeight();
                meta = mixture.getMeta();
            }
            kp seasoned = base.j();
            seasoned.b(meta);
            ((ItemBeverage)base.a()).beverages[meta].saveEffects(seasoned, effects.toArray(new IBeverageEffect[0]));
            return seasoned;
        }
    }

    public static class Mixture {
        private int meta;
        private kp[] ingredients;
        private IBeverageEffect effect;

        public Mixture(int meta, kp ingredient, IBeverageEffect effect) {
            this(meta, new kp[]{ingredient}, effect);
        }

        public Mixture(int meta, kp[] ingredients, IBeverageEffect effect) {
            this.meta = meta;
            this.ingredients = ingredients;
            this.effect = effect;
        }

        public kp[] getIngredients() {
            return this.ingredients;
        }

        public boolean isIngredient(kp itemstack) {
            for (kp ingredient : this.ingredients) {
                if (ingredient.h() < 0 && ingredient.c == itemstack.c) {
                    return true;
                }
                if (ingredient.h() < 0 || !ingredient.a(itemstack)) continue;
                return true;
            }
            return false;
        }

        public boolean matches(kp[] res) {
            if (res == null || res.length <= 0) {
                return false;
            }
            boolean matchedAll = true;
            for (kp stack : this.ingredients) {
                boolean matched = false;
                for (kp matchStack : res) {
                    if (matchStack == null) continue;
                    if (stack.h() < 0 && stack.c == matchStack.c) {
                        if (stack.a > matchStack.a) continue;
                        matched = true;
                        break;
                    }
                    if (stack.h() < 0 || !stack.a(matchStack) || stack.a > matchStack.a) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                matchedAll = false;
            }
            return matchedAll;
        }

        public IBeverageEffect getEffect() {
            return this.effect;
        }

        public int getMeta() {
            return this.meta;
        }

        public int getWeight() {
            return this.ingredients.length;
        }
    }
}

