/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.RainSubstrate;
import forestry.core.Proxy;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.Mill;
import forestry.core.gadgets.TileMill;
import forestry.core.utils.Orientations;

public class MillRainmaker
extends Mill {
    private int duration;
    private boolean reverse;

    public MillRainmaker(TileMill tile) {
        super(tile);
        this.tileMill = tile;
        this.speed = 0.01f;
    }

    @Override
    public String getName() {
        return "Rainmaker";
    }

    @Override
    public void openGui(ih player, ni tile) {
        if (Proxy.isMultiplayerWorld()) {
            return;
        }
        if (player.k.d() == null) {
            return;
        }
        int usedItemId = player.k.d().c;
        if (FuelManager.rainSubstrate.containsKey(usedItemId) && this.charge == 0) {
            RainSubstrate substrate = (RainSubstrate)FuelManager.rainSubstrate.get(usedItemId);
            if (substrate.item.a(player.k.d())) {
                this.addCharge(substrate);
                --player.k.d().a;
            }
        }
        this.tileMill.sendNetworkUpdate();
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.charge = nbttagcompound.f("Charge");
        this.progress = nbttagcompound.h("Progress");
        this.stage = nbttagcompound.f("Stage");
        this.duration = nbttagcompound.f("Duration");
        this.reverse = nbttagcompound.o("Reverse");
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("Charge", this.charge);
        nbttagcompound.a("Progress", this.progress);
        nbttagcompound.a("Stage", this.stage);
        nbttagcompound.a("Duration", this.duration);
        nbttagcompound.a("Reverse", this.reverse);
    }

    public void addCharge(RainSubstrate substrate) {
        this.charge = 1;
        this.speed = substrate.speed;
        this.duration = substrate.duration;
        this.reverse = substrate.reverse;
    }

    @Override
    public void activate() {
        if (Proxy.isClient()) {
            this.tileMill.k.a((double)this.tileMill.l, (double)this.tileMill.m, (double)this.tileMill.n, "ambient.weather.thunder", 4.0f, (1.0f + (this.tileMill.k.r.nextFloat() - this.tileMill.k.r.nextFloat()) * 0.2f) * 0.7f);
            float f = (float)this.tile.l + 0.5f;
            float f1 = (float)this.tile.m + 0.0f + this.tile.k.r.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)this.tile.n + 0.5f;
            float f3 = 0.52f;
            float f4 = this.tile.k.r.nextFloat() * 0.6f - 0.3f;
            Proxy.addEntityExplodeFX(this.tile.k, f - f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxy.addEntityExplodeFX(this.tile.k, f + f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxy.addEntityExplodeFX(this.tile.k, f + f4, f1, f2 - f3, 0.0f, 0.0f, 0.0f);
            Proxy.addEntityExplodeFX(this.tile.k, f + f4, f1, f2 + f3, 0.0f, 0.0f, 0.0f);
        }
        if (!Proxy.isMultiplayerWorld()) {
            if (this.reverse) {
                this.tile.k.s().b(false);
            } else {
                this.tile.k.s().b(true);
                this.tile.k.s().c(this.duration);
            }
            this.charge = 0;
            this.duration = 0;
            this.reverse = false;
            this.tileMill.sendNetworkUpdate();
        }
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean addItem(kp stack, boolean doAdd, Orientations from) {
        if (this.charge != 0) {
            return false;
        }
        if (!FuelManager.rainSubstrate.containsKey(stack.c)) {
            return false;
        }
        RainSubstrate substrate = (RainSubstrate)FuelManager.rainSubstrate.get(stack.c);
        if (!substrate.item.a(stack)) {
            return false;
        }
        if (doAdd) {
            this.addCharge(substrate);
            --stack.a;
        }
        return true;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(qj tile) {
            return new MillRainmaker((TileMill)tile);
        }
    }
}

