/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import forestry.api.core.ForestryAPI;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.api.liquids.LiquidStack;
import forestry.api.recipes.IMoistenerManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.Orientations;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MachineMoistener
extends Machine {
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    private kp[] inventoryStacks = new kp[12];
    public Recipe currentRecipe;
    private short stashSlot1 = 0;
    private short reservoirSlot1 = (short)6;
    private short reservoirSize = (short)3;
    private short workingSlot = (short)9;
    private short productSlot = (short)10;
    private short resourceSlot = (short)11;
    public int burnTime = 0;
    public int totalTime = 0;
    public int productionTime = 0;
    private int timePerItem = 0;
    private kp currentProduct;
    private kp pendingProduct;

    public kp getResourceStack() {
        return this.inventoryStacks[this.resourceSlot];
    }

    public MachineMoistener(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("moistener"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.6");
    }

    @Override
    public void openGui(ih player, ni tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.MoistenerGUI.ordinal(), player.bi, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("BurnTime", this.burnTime);
        nbttagcompound.a("TotalTime", this.totalTime);
        nbttagcompound.a("ProductionTime", this.productionTime);
        ph NBTresourceSlot = new ph();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.a("ResourceTank", (jz)NBTresourceSlot);
        tx nbttaglist = new tx();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            ph nbttagcompound1 = new ph();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((jz)nbttagcompound1);
        }
        nbttagcompound.a("Items", (jz)nbttaglist);
        if (this.pendingProduct != null) {
            ph nbttagcompoundP = new ph();
            this.pendingProduct.b(nbttagcompoundP);
            nbttagcompound.a("PendingProduct", (jz)nbttagcompoundP);
        }
        if (this.currentProduct != null) {
            ph nbttagcompoundP = new ph();
            this.currentProduct.b(nbttagcompoundP);
            nbttagcompound.a("CurrentProduct", (jz)nbttagcompoundP);
        }
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.burnTime = nbttagcompound.f("BurnTime");
        this.totalTime = nbttagcompound.f("TotalTime");
        this.productionTime = nbttagcompound.f("ProductionTime");
        this.resourceTank = new TankSlot(10000);
        if (nbttagcompound.c("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.m("ResourceTank"));
        }
        tx nbttaglist = nbttagcompound.n("Items");
        this.inventoryStacks = new kp[this.c()];
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ph nbttagcompound1 = (ph)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = kp.a((ph)nbttagcompound1);
        }
        if (nbttagcompound.c("PendingProduct")) {
            ph nbttagcompoundP = nbttagcompound.m("PendingProduct");
            this.pendingProduct = kp.a((ph)nbttagcompoundP);
        }
        if (nbttagcompound.c("CurrentProduct")) {
            ph nbttagcompoundP = nbttagcompound.m("CurrentProduct");
            this.currentProduct = kp.a((ph)nbttagcompoundP);
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        int lightvalue;
        LiquidContainer container;
        if (this.inventoryStacks[this.productSlot] != null && (container = LiquidManager.getLiquidContainer(this.inventoryStacks[this.productSlot])) != null && container.liquid.isLiquidEqual(new kp(vz.B))) {
            this.inventoryStacks[this.productSlot] = this.replenishByContainer(this.inventoryStacks[this.productSlot], container, this.resourceTank);
            if (this.inventoryStacks[this.productSlot].a <= 0) {
                this.inventoryStacks[this.productSlot] = null;
            }
        }
        if ((lightvalue = this.tile.k.n(this.tile.l, this.tile.m + 1, this.tile.n)) > 11) {
            this.setErrorState(EnumErrorCode.NOTGLOOMY);
            return;
        }
        int speed = lightvalue >= 9 ? 1 : (lightvalue >= 7 ? 2 : (lightvalue >= 5 ? 3 : 4));
        if (this.burnTime > 0 && this.pendingProduct == null) {
            if (this.resourceTank.quantity <= 0) {
                return;
            }
            this.checkRecipe();
            if (this.currentRecipe == null) {
                return;
            }
            --this.resourceTank.quantity;
            this.burnTime -= speed;
            this.productionTime -= speed;
            if (this.productionTime <= 0) {
                this.pendingProduct = this.currentProduct;
                this.a((int)this.resourceSlot, 1);
                this.resetRecipe();
                this.tryAddPending();
            }
        } else if (this.pendingProduct != null) {
            this.tryAddPending();
        } else if (this.rotateWorkingSlot()) {
            this.checkRecipe();
            if (this.inventoryStacks[this.workingSlot] == null) {
                return;
            }
            if (FuelManager.moistenerResource.containsKey(this.inventoryStacks[this.workingSlot].c)) {
                MoistenerFuel res = (MoistenerFuel)FuelManager.moistenerResource.get(this.inventoryStacks[this.workingSlot].c);
                this.burnTime = this.totalTime = res.moistenerValue;
            }
        } else {
            this.rotateReservoir();
        }
        if (this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        } else {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
    }

    private boolean tryAddPending() {
        if (this.pendingProduct == null) {
            return false;
        }
        if (this.inventoryStacks[this.productSlot] == null) {
            this.inventoryStacks[this.productSlot] = this.pendingProduct.j();
            this.pendingProduct = null;
            return true;
        }
        if (this.inventoryStacks[this.productSlot].a(this.pendingProduct) && this.inventoryStacks[this.productSlot].a <= this.inventoryStacks[this.productSlot].b() - this.pendingProduct.a) {
            this.inventoryStacks[this.productSlot].a += this.pendingProduct.a;
            this.pendingProduct = null;
            return true;
        }
        return false;
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.getResourceStack());
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.currentProduct = null;
            this.productionTime = 0;
            this.timePerItem = 0;
            this.setErrorState(EnumErrorCode.NORECIPE);
            return;
        }
        this.currentProduct = this.currentRecipe.product;
        this.productionTime = this.currentRecipe.timePerItem;
        this.timePerItem = this.currentRecipe.timePerItem;
    }

    private int getFreeSlot(kp deposit, int startSlot, int endSlot) {
        int slot = -1;
        for (int i = startSlot; i < endSlot; ++i) {
            if (this.inventoryStacks[i] == null) {
                if (slot >= 0) continue;
                slot = i;
                continue;
            }
            if (!this.inventoryStacks[i].a(deposit) || this.inventoryStacks[i].a >= this.inventoryStacks[i].b()) continue;
            slot = i;
        }
        return slot;
    }

    private int getFreeStashSlot(kp deposit) {
        return this.getFreeSlot(deposit, 0, this.reservoirSlot1);
    }

    private int getFreeReservoirSlot(kp deposit) {
        return this.getFreeSlot(deposit, this.reservoirSlot1, this.reservoirSlot1 + this.reservoirSize);
    }

    private int getNextResourceSlot(int startSlot, int endSlot) {
        int stage = -1;
        int resourceSlot = -1;
        for (int i = startSlot; i < endSlot; ++i) {
            if (this.inventoryStacks[i] == null || !FuelManager.moistenerResource.containsKey(this.inventoryStacks[i].c)) continue;
            MoistenerFuel res = (MoistenerFuel)FuelManager.moistenerResource.get(this.inventoryStacks[i].c);
            if (stage >= 0 && res.stage >= stage) continue;
            stage = res.stage;
            resourceSlot = i;
        }
        return resourceSlot;
    }

    private boolean rotateWorkingSlot() {
        if (this.inventoryStacks[this.workingSlot] != null) {
            kp deposit;
            if (FuelManager.moistenerResource.containsKey(this.inventoryStacks[this.workingSlot].c)) {
                MoistenerFuel res = (MoistenerFuel)FuelManager.moistenerResource.get(this.inventoryStacks[this.workingSlot].c);
                deposit = res.product.j();
            } else {
                deposit = this.inventoryStacks[this.workingSlot].j();
            }
            int targetSlot = this.getFreeReservoirSlot(deposit);
            if (targetSlot < 0) {
                return false;
            }
            if (this.inventoryStacks[targetSlot] == null) {
                this.inventoryStacks[targetSlot] = deposit;
            } else {
                ++this.inventoryStacks[targetSlot].a;
            }
            this.a((int)this.workingSlot, 1);
        }
        if (this.inventoryStacks[this.workingSlot] != null) {
            return true;
        }
        int resourceSlot = this.getNextResourceSlot(this.reservoirSlot1, this.reservoirSlot1 + this.reservoirSize);
        if (resourceSlot < 0) {
            return false;
        }
        this.inventoryStacks[this.workingSlot] = this.inventoryStacks[resourceSlot].a(1);
        if (this.inventoryStacks[resourceSlot].a <= 0) {
            this.inventoryStacks[resourceSlot] = null;
        }
        return true;
    }

    private void rotateReservoir() {
        int resourceSlot;
        int targetSlot;
        ArrayList<Integer> slotsToShift = new ArrayList<Integer>();
        for (int i = this.reservoirSlot1; i < this.reservoirSlot1 + this.reservoirSize; ++i) {
            if (this.inventoryStacks[i] == null || FuelManager.moistenerResource.containsKey(this.inventoryStacks[i].c)) continue;
            slotsToShift.add(i);
        }
        Iterator i$ = slotsToShift.iterator();
        while (i$.hasNext()) {
            int slot = (Integer)i$.next();
            targetSlot = this.getFreeStashSlot(this.inventoryStacks[slot]);
            if (targetSlot < 0) continue;
            if (this.inventoryStacks[targetSlot] == null) {
                this.inventoryStacks[targetSlot] = this.inventoryStacks[slot];
                this.inventoryStacks[slot] = null;
                continue;
            }
            StackUtils.mergeStacks(this.inventoryStacks[slot], this.inventoryStacks[targetSlot]);
            if (this.inventoryStacks[slot] == null || this.inventoryStacks[slot].a > 0) continue;
            this.inventoryStacks[slot] = null;
        }
        for (int i = 0; i < 2 && (resourceSlot = this.getNextResourceSlot(0, this.reservoirSlot1)) >= 0 && (targetSlot = this.getFreeReservoirSlot(this.inventoryStacks[resourceSlot])) >= 0; ++i) {
            if (this.inventoryStacks[targetSlot] == null) {
                this.inventoryStacks[targetSlot] = this.inventoryStacks[resourceSlot];
                this.inventoryStacks[resourceSlot] = null;
                continue;
            }
            StackUtils.mergeStacks(this.inventoryStacks[resourceSlot], this.inventoryStacks[targetSlot]);
            if (this.inventoryStacks[resourceSlot] == null || this.inventoryStacks[resourceSlot].a > 0) continue;
            this.inventoryStacks[resourceSlot] = null;
        }
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.burnTime > 0 && this.resourceTank.quantity > 0;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        int max = 0;
        int avail = 0;
        for (int i = this.stashSlot1; i < this.reservoirSlot1; ++i) {
            if (this.inventoryStacks[i] == null) {
                max += 64;
                continue;
            }
            if (!FuelManager.moistenerResource.containsKey(this.inventoryStacks[i].c)) continue;
            MoistenerFuel res = (MoistenerFuel)FuelManager.moistenerResource.get(this.inventoryStacks[i].c);
            if (!res.item.a(this.inventoryStacks[i])) continue;
            max += 64;
            avail += this.inventoryStacks[i].a;
        }
        return (float)avail / (float)max > percentage;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.inventoryStacks[this.resourceSlot] == null) {
            return false;
        }
        return (float)this.inventoryStacks[this.resourceSlot].a / (float)this.inventoryStacks[this.resourceSlot].b() > percentage;
    }

    public boolean isProducing() {
        return this.productionTime > 0;
    }

    public int getProductionProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return 0;
        }
        return this.productionTime * i / this.timePerItem;
    }

    public int getConsumptionProgressScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return this.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public int c() {
        return this.inventoryStacks.length;
    }

    @Override
    public kp g_(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public void a(int i, kp itemstack) {
        this.inventoryStacks[i] = itemstack;
    }

    @Override
    public kp a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            kp removed = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return removed;
        }
        kp removed = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return removed;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0) {
            return this.productSlot;
        }
        if (side == 1) {
            return this.resourceSlot;
        }
        return 0;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 0) {
            return 1;
        }
        if (side == 1) {
            return 1;
        }
        return 6;
    }

    @Override
    public kp b(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        kp toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public boolean addItem(kp stack, boolean doAdd, Orientations from) {
        LiquidContainer container = LiquidManager.getLiquidContainer(stack);
        if (container != null && container.liquid.isLiquidEqual(new LiquidStack(vz.B, 1))) {
            if (this.inventoryStacks[this.productSlot] == null) {
                if (doAdd) {
                    this.inventoryStacks[this.productSlot] = stack.j();
                    stack.a = 0;
                }
                return true;
            }
            if (!this.inventoryStacks[this.productSlot].a(stack)) {
                return false;
            }
            int space = this.inventoryStacks[this.productSlot].b() - this.inventoryStacks[this.productSlot].a;
            if (space <= 0) {
                return false;
            }
            if (space < stack.a) {
                if (doAdd) {
                    this.inventoryStacks[this.productSlot].a = this.inventoryStacks[this.productSlot].b();
                    stack.a -= space;
                }
                return true;
            }
            if (doAdd) {
                this.inventoryStacks[this.productSlot].a += stack.a;
                stack.a = 0;
            }
            return true;
        }
        if (from == Orientations.YPos || from == Orientations.YNeg) {
            if (this.inventoryStacks[this.resourceSlot] == null) {
                if (doAdd) {
                    this.inventoryStacks[this.resourceSlot] = stack.j();
                    stack.a = 0;
                }
                return true;
            }
            if (!this.inventoryStacks[this.resourceSlot].a(stack)) {
                return false;
            }
            int space = this.inventoryStacks[this.resourceSlot].b() - this.inventoryStacks[this.resourceSlot].a;
            if (space <= 0) {
                return false;
            }
            if (space < stack.a) {
                if (doAdd) {
                    this.inventoryStacks[this.resourceSlot].a = this.inventoryStacks[this.resourceSlot].b();
                    stack.a -= space;
                }
                return true;
            }
            if (doAdd) {
                this.inventoryStacks[this.resourceSlot].a += stack.a;
                stack.a = 0;
            }
            return true;
        }
        int freeSlots = 0;
        int slot = -1;
        for (int i = 0; i < this.reservoirSlot1; ++i) {
            int space;
            if (this.inventoryStacks[i] == null) {
                ++freeSlots;
                slot = i;
                continue;
            }
            if (!this.inventoryStacks[i].a(stack) || (space = this.inventoryStacks[i].b() - this.inventoryStacks[i].a) <= 0) continue;
            if (space < stack.a) {
                if (doAdd) {
                    this.inventoryStacks[i].a = this.inventoryStacks[i].b();
                    stack.a -= space;
                    continue;
                }
                return true;
            }
            if (doAdd) {
                this.inventoryStacks[i].a += stack.a;
                stack.a = 0;
            }
            return true;
        }
        if (freeSlots <= 2) {
            return false;
        }
        if (doAdd) {
            this.inventoryStacks[slot] = stack.j();
            stack.a = 0;
        }
        return true;
    }

    @Override
    public kp extractItem(boolean doRemove, Orientations from) {
        if (this.inventoryStacks[this.productSlot] != null && this.inventoryStacks[this.productSlot].a > 0) {
            kp product = new kp(this.inventoryStacks[this.productSlot].c, 1, this.inventoryStacks[this.productSlot].h());
            if (doRemove) {
                --this.inventoryStacks[this.productSlot].a;
                if (this.inventoryStacks[this.productSlot].a <= 0) {
                    this.inventoryStacks[this.productSlot] = null;
                }
            }
            return product;
        }
        for (int i = 0; i < this.reservoirSlot1; ++i) {
            if (this.inventoryStacks[i] == null || FuelManager.moistenerResource.containsKey(this.inventoryStacks[i].c)) continue;
            kp product = new kp(this.inventoryStacks[i].c, 1, this.inventoryStacks[i].h());
            if (doRemove) {
                --this.inventoryStacks[i].a;
                if (this.inventoryStacks[i].a <= 0) {
                    this.inventoryStacks[i] = null;
                }
            }
            return product;
        }
        return null;
    }

    @Override
    public int fill(Orientations from, int quantity, int id2, boolean doFill) {
        int used = this.resourceTank.fill(from, quantity, id2, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public int getCapacity() {
        return 10000;
    }

    @Override
    public TankSlot[] getLiquidContents() {
        return new TankSlot[]{this.resourceTank};
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.burnTime = j;
                break;
            }
            case 1: {
                this.totalTime = j;
                break;
            }
            case 2: {
                this.productionTime = j;
                break;
            }
            case 3: {
                this.timePerItem = j;
                break;
            }
            case 4: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 5: {
                this.resourceTank.quantity = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ew container, ff iCrafting) {
        iCrafting.a(container, 0, this.burnTime);
        iCrafting.a(container, 1, this.totalTime);
        iCrafting.a(container, 2, this.productionTime);
        iCrafting.a(container, 3, this.timePerItem);
        iCrafting.a(container, 4, this.resourceTank.liquidId);
        iCrafting.a(container, 5, this.resourceTank.quantity);
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowFuel25);
        res.add(ForestryTrigger.lowFuel10);
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        return res;
    }

    public static void initialize() {
        RecipeManagers.moistenerManager.addRecipe(new kp(id.R), new kp((vz)vz.by), 5000);
        RecipeManagers.moistenerManager.addRecipe(new kp(vz.w), new kp(vz.ao), 20000);
        RecipeManagers.moistenerManager.addRecipe(new kp(vz.bm), new kp(vz.bm, 1, 1), 20000);
    }

    public static class RecipeManager
    implements IMoistenerManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(kp resource, kp product, int timePerItem) {
            recipes.add(new Recipe(resource, product, timePerItem));
        }

        public static Recipe findMatchingRecipe(kp item) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(item)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public List getRecipes() {
            HashMap<kp[], kp[]> recipeList = new HashMap<kp[], kp[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new kp[]{recipe.resource}, new kp[]{recipe.product});
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        public int timePerItem;
        public kp resource;
        public kp product;

        public Recipe(kp resource, kp product, int timePerItem) {
            this.timePerItem = timePerItem;
            this.resource = resource;
            this.product = product;
        }

        public boolean matches(kp res) {
            if (res == null && this.resource == null) {
                return true;
            }
            if (res == null && this.resource != null) {
                return false;
            }
            if (res != null && this.resource == null) {
                return false;
            }
            return this.resource.a(res);
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(qj tile) {
            return new MachineMoistener((TileMachine)tile);
        }
    }
}

