/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import forestry.api.core.ForestryAPI;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.api.liquids.LiquidStack;
import forestry.api.recipes.IFermenterManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.Orientations;
import forestry.core.utils.RecipeUtil;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class MachineFermenter
extends Machine {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_FUEL = 1;
    public static final short SLOT_CAN_OUTPUT = 2;
    public static final short SLOT_CAN_INPUT = 3;
    public static final short SLOT_INPUT = 4;
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    @EntityNetData
    public TankSlot productTank = new TankSlot(10000);
    private kp[] inventoryStacks = new kp[5];
    private Recipe currentRecipe;
    public int fermentationTime = 0;
    public int fermentationTotalTime = 0;
    public int fuelBurnTime = 0;
    public int fuelTotalTime = 0;
    public int fuelCurrentFerment = 0;

    public MachineFermenter(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("fermenter"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.0");
    }

    @Override
    public void openGui(ih player, ni tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.FermenterGUI.ordinal(), player.bi, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("FermentationTime", this.fermentationTime);
        nbttagcompound.a("FermentationTotalTime", this.fermentationTotalTime);
        nbttagcompound.a("FuelBurnTime", this.fuelBurnTime);
        nbttagcompound.a("FuelTotalTime", this.fuelTotalTime);
        nbttagcompound.a("FuelCurrentFerment", this.fuelCurrentFerment);
        ph NBTresourceSlot = new ph();
        ph NBTproductSlot = new ph();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        this.productTank.writeToNBT(NBTproductSlot);
        nbttagcompound.a("ResourceTank", (jz)NBTresourceSlot);
        nbttagcompound.a("ProductTank", (jz)NBTproductSlot);
        tx nbttaglist = new tx();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            ph nbttagcompound1 = new ph();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((jz)nbttagcompound1);
        }
        nbttagcompound.a("Items", (jz)nbttaglist);
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.fermentationTime = nbttagcompound.f("FermentationTime");
        this.fermentationTotalTime = nbttagcompound.f("FermentationTotalTime");
        this.fuelBurnTime = nbttagcompound.f("FuelBurnTime");
        this.fuelTotalTime = nbttagcompound.f("FuelTotalTime");
        this.fuelCurrentFerment = nbttagcompound.f("FuelCurrentFerment");
        this.resourceTank = new TankSlot(10000);
        this.productTank = new TankSlot(10000);
        if (nbttagcompound.c("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.m("ResourceTank"));
            this.productTank.readFromNBT(nbttagcompound.m("ProductTank"));
        }
        tx nbttaglist = nbttagcompound.n("Items");
        this.inventoryStacks = new kp[this.c()];
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ph nbttagcompound1 = (ph)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = kp.a((ph)nbttagcompound1);
        }
    }

    @Override
    public void updateServerSide() {
        LiquidContainer container;
        if (this.inventoryStacks[4] != null && (container = LiquidManager.getLiquidContainer(this.inventoryStacks[4])) != null && RecipeManager.isLiquidResource(container.liquid)) {
            this.inventoryStacks[4] = this.replenishByContainer(this.inventoryStacks[4], container, this.resourceTank);
            if (this.inventoryStacks[4].a <= 0) {
                this.inventoryStacks[4] = null;
            }
        }
        if (this.inventoryStacks[3] != null && (container = LiquidManager.getEmptyContainer(this.inventoryStacks[3], new LiquidStack(this.productTank.liquidId, this.productTank.quantity))) != null) {
            this.inventoryStacks[2] = this.bottleIntoContainer(this.inventoryStacks[3], this.inventoryStacks[2], container, this.productTank);
            if (this.inventoryStacks[3].a <= 0) {
                this.inventoryStacks[3] = null;
            }
        }
        if (this.tile.k.o() % 20L * 10L != 0L) {
            return;
        }
        if (RecipeManager.findMatchingRecipe(this.inventoryStacks[0], new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity)) != null) {
            this.setErrorState(EnumErrorCode.OK);
        } else if (this.inventoryStacks[1] == null && this.fuelBurnTime <= 0) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
    }

    @Override
    public boolean doWork() {
        if (this.currentRecipe == null) {
            this.checkRecipe();
            this.resetRecipe();
            if (this.currentRecipe != null) {
                this.a(0, 1);
                return true;
            }
            return false;
        }
        if (this.fuelBurnTime > 0 && this.resourceTank.quantity > 0 && this.productTank.quantity < 10000) {
            --this.fuelBurnTime;
            if (this.currentRecipe == null) {
                return true;
            }
            if (this.fermentationTime <= 0) {
                return false;
            }
            this.resourceTank.empty(this.fuelCurrentFerment, true);
            this.fermentationTime -= this.fuelCurrentFerment;
            this.addProduct(new LiquidStack(this.currentRecipe.output.itemID, Math.round((float)this.fuelCurrentFerment * this.currentRecipe.modifier), this.currentRecipe.output.itemMeta));
            if (this.fermentationTime > 0) {
                return true;
            }
            this.currentRecipe = null;
            return true;
        }
        if (this.fuelBurnTime <= 0) {
            this.fuelBurnTime = this.fuelTotalTime = this.determineFuelValue(this.getFuelStack());
            if (this.fuelBurnTime > 0) {
                this.fuelCurrentFerment = this.determineFermentPerCycle(this.getFuelStack());
                this.a(1, 1);
                return true;
            }
            this.fuelCurrentFerment = 0;
            return false;
        }
        return false;
    }

    private void addProduct(LiquidStack output) {
        this.productTank.fill(null, output, true);
        if (this.productTank.quantity > 10000) {
            this.productTank.quantity = 10000;
        }
    }

    private void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.inventoryStacks[0], new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity));
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.fermentationTime = 0;
            this.fermentationTotalTime = 0;
            return;
        }
        this.fermentationTime = this.currentRecipe.fermentationValue;
        this.fermentationTotalTime = this.currentRecipe.fermentationValue;
    }

    private int determineFuelValue(kp item) {
        if (item == null) {
            return 0;
        }
        int fuelid = item.a().bP;
        if (fuelid == 0) {
            return 0;
        }
        if (FuelManager.fermenterFuel.containsKey(fuelid)) {
            return ((FermenterFuel)FuelManager.fermenterFuel.get((Object)Integer.valueOf((int)fuelid))).burnDuration;
        }
        return 0;
    }

    private int determineFermentPerCycle(kp item) {
        if (item == null) {
            return 0;
        }
        int fuelid = item.a().bP;
        if (fuelid == 0) {
            return 0;
        }
        if (FuelManager.fermenterFuel.containsKey(fuelid)) {
            return ((FermenterFuel)FuelManager.fermenterFuel.get((Object)Integer.valueOf((int)fuelid))).fermentPerCycle;
        }
        return 0;
    }

    @Override
    public boolean isWorking() {
        return this.fuelBurnTime > 0;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.getFermentationStack() == null) {
            return false;
        }
        return (float)this.getFermentationStack().a / (float)this.getFermentationStack().b() > percentage;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        if (this.getFuelStack() == null) {
            return false;
        }
        return (float)this.getFuelStack().a / (float)this.getFuelStack().b() > percentage;
    }

    @Override
    public boolean hasWork() {
        if (this.getFuelStack() == null && this.fuelBurnTime <= 0) {
            return false;
        }
        if (this.fuelBurnTime <= 0 && RecipeManager.findMatchingRecipe(this.inventoryStacks[0], new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity)) == null) {
            return false;
        }
        if (this.getFermentationStack() == null && this.fermentationTime <= 0) {
            return false;
        }
        if (this.fermentationTime <= 0 && RecipeManager.findMatchingRecipe(this.inventoryStacks[0], new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity)) == null) {
            return false;
        }
        if (this.resourceTank.quantity <= 0) {
            return false;
        }
        return this.productTank.quantity < this.productTank.capacity;
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.fuelTotalTime == 0) {
            return 0;
        }
        return this.fuelBurnTime * i / this.fuelTotalTime;
    }

    public int getFermentationProgressScaled(int i) {
        if (this.fermentationTotalTime == 0) {
            return 0;
        }
        return this.fermentationTime * i / this.fermentationTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    public int getProductScaled(int i) {
        return this.productTank.quantity * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return this.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return this.rateTankLevel(this.getProductScaled(100));
    }

    public kp getFermentationStack() {
        return this.inventoryStacks[0];
    }

    public kp getFuelStack() {
        return this.inventoryStacks[1];
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fuelBurnTime = j;
                break;
            }
            case 1: {
                this.fuelTotalTime = j;
                break;
            }
            case 2: {
                this.fermentationTime = j;
                break;
            }
            case 3: {
                this.fermentationTotalTime = j;
                break;
            }
            case 4: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 5: {
                this.resourceTank.quantity = j;
                break;
            }
            case 6: {
                this.productTank.liquidId = j;
                break;
            }
            case 7: {
                this.productTank.quantity = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ew container, ff iCrafting) {
        iCrafting.a(container, 0, this.fuelBurnTime);
        iCrafting.a(container, 1, this.fuelTotalTime);
        iCrafting.a(container, 2, this.fermentationTime);
        iCrafting.a(container, 3, this.fermentationTotalTime);
        iCrafting.a(container, 4, this.resourceTank.liquidId);
        iCrafting.a(container, 5, this.resourceTank.quantity);
        iCrafting.a(container, 6, this.productTank.liquidId);
        iCrafting.a(container, 7, this.productTank.quantity);
    }

    @Override
    public boolean addItem(kp stack, boolean doAdd, Orientations from) {
        int inventory;
        if (FuelManager.fermenterFuel.containsKey(stack.a().bP)) {
            inventory = 1;
        } else if (RecipeManager.isResource(stack)) {
            inventory = 0;
        } else if (LiquidManager.isEmptyContainer(stack)) {
            inventory = 3;
        } else {
            LiquidContainer container = LiquidManager.getLiquidContainer(stack);
            if (container != null && RecipeManager.isLiquidResource(container.liquid)) {
                inventory = 4;
            } else {
                return false;
            }
        }
        int space = 0;
        if (this.inventoryStacks[inventory] == null) {
            space = this.a();
        } else {
            if (this.inventoryStacks[inventory].a().bP != stack.a().bP) {
                return false;
            }
            space = this.inventoryStacks[inventory].b() - this.inventoryStacks[inventory].a;
        }
        if (space <= 0) {
            return false;
        }
        if (space >= stack.a) {
            if (doAdd) {
                if (this.inventoryStacks[inventory] == null) {
                    this.inventoryStacks[inventory] = stack.j();
                } else {
                    this.inventoryStacks[inventory].a += stack.a;
                }
                stack.a = 0;
            }
            return true;
        }
        if (doAdd) {
            this.inventoryStacks[inventory].a += space;
            stack.a -= space;
        }
        return false;
    }

    @Override
    public kp extractItem(boolean doRemove, Orientations from) {
        kp product = null;
        if (this.inventoryStacks[2] != null) {
            product = new kp(this.inventoryStacks[2].c, 1, this.inventoryStacks[2].h());
            if (doRemove) {
                --this.inventoryStacks[2].a;
                if (this.inventoryStacks[2].a <= 0) {
                    this.inventoryStacks[2] = null;
                }
            }
        }
        return product;
    }

    @Override
    public int c() {
        return this.inventoryStacks.length;
    }

    @Override
    public kp g_(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public kp a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            kp removed = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return removed;
        }
        kp removed = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return removed;
    }

    @Override
    public void a(int i, kp itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.a()) {
            itemstack.a = this.a();
        }
    }

    @Override
    public kp b(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        kp toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return 1;
    }

    @Override
    public int getStartInventorySide(int side) {
        switch (side) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 4;
    }

    @Override
    public int fill(Orientations from, int quantity, int id2, boolean doFill) {
        if (!RecipeManager.isLiquidResource(new LiquidStack(id2, quantity))) {
            return 0;
        }
        int used = this.resourceTank.fill(from, new LiquidStack(id2, quantity, 0), doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public int empty(int quantityMax, boolean doEmpty) {
        int product = 0;
        if (this.productTank.quantity >= quantityMax) {
            product = quantityMax;
            if (doEmpty) {
                this.productTank.quantity -= quantityMax;
            }
        } else {
            product = this.productTank.quantity;
            if (doEmpty) {
                this.productTank.quantity = 0;
            }
        }
        if (doEmpty && product > 0) {
            this.tile.sendNetworkUpdate();
        }
        return product;
    }

    @Override
    public int getLiquidQuantity() {
        return this.productTank.quantity;
    }

    @Override
    public int getCapacity() {
        return 10000;
    }

    @Override
    public TankSlot[] getLiquidContents() {
        return new TankSlot[]{this.resourceTank, this.productTank};
    }

    @Override
    public int getLiquidId() {
        return this.productTank.liquidId;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowFuel25);
        res.add(ForestryTrigger.lowFuel10);
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static void initialize() {
        RecipeManagers.fermenterManager.addRecipe(new kp(ForestryItem.honeydew), 500, 1.0f, new LiquidStack(ForestryItem.liquidMead.bP, 1), new LiquidStack(ForestryItem.liquidHoney.bP, 1));
        RecipeUtil.injectLeveledRecipe(new kp(vz.y, 1, 0), 800, new kp(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(new kp(vz.y, 1, 1), 800, new kp(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(new kp(vz.y, 1, 2), 800, new kp(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(new kp(vz.y, 1, 3), 800, new kp(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(new kp(vz.aV), 200, new kp(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(new kp(id.S), 100, new kp(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(new kp(id.aI), 200, new kp(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(new kp((vz)vz.af), 200, new kp(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(new kp((vz)vz.ag), 200, new kp(ForestryItem.liquidBiomass));
    }

    public static class RecipeManager
    implements IFermenterManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(kp resource, int fermentationValue, float modifier, LiquidStack output, LiquidStack liquid) {
            recipes.add(new Recipe(resource, fermentationValue, modifier, output, liquid));
        }

        @Override
        public void addRecipe(kp resource, int fermentationValue, float modifier, LiquidStack output) {
            recipes.add(new Recipe(resource, fermentationValue, modifier, output, null));
        }

        public static Recipe findMatchingRecipe(kp res, LiquidStack liqu) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(res, liqu)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isResource(kp resource) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.resource.a(resource)) continue;
                return true;
            }
            return false;
        }

        public static boolean isLiquidResource(LiquidStack liquid) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.liquid.isLiquidEqual(liquid)) continue;
                return true;
            }
            return false;
        }

        public static boolean isLiquidProduct(LiquidStack liquid) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.output.isLiquidEqual(liquid)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List getRecipes() {
            HashMap<kp[], kp[]> recipeList = new HashMap<kp[], kp[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new kp[]{recipe.resource, recipe.liquid.asItemStack()}, new kp[]{recipe.output.asItemStack()});
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        public final kp resource;
        public final int fermentationValue;
        public final float modifier;
        public final LiquidStack output;
        public final LiquidStack liquid;

        public Recipe(kp resource, int fermentationValue, float modifier, LiquidStack output, LiquidStack liquid) {
            this.resource = resource;
            this.fermentationValue = fermentationValue;
            this.modifier = modifier;
            this.output = output;
            this.liquid = liquid;
        }

        public boolean matches(kp res, LiquidStack liqu) {
            if (res == null) {
                return false;
            }
            if (!this.resource.a(res)) {
                return false;
            }
            if (this.liquid == null) {
                return true;
            }
            if (this.liquid != null && liqu == null) {
                return false;
            }
            if (!this.liquid.isLiquidEqual(liqu)) {
                return false;
            }
            return this.liquid.liquidAmount <= liqu.liquidAmount;
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(qj tile) {
            return new MachineFermenter((TileMachine)tile);
        }
    }
}

