/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import forestry.api.core.ForestryAPI;
import forestry.api.liquids.LiquidStack;
import forestry.api.recipes.IFabricatorManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.interfaces.ICrafter;
import forestry.core.network.GuiId;
import forestry.core.utils.GenericInventoryAdapter;
import forestry.core.utils.Orientations;
import forestry.core.utils.ShapedRecipeInternal;
import forestry.core.utils.StackUtils;
import forestry.core.utils.TankSlot;
import java.util.ArrayList;
import java.util.List;

public class MachineFabricator
extends Machine
implements ICrafter {
    private static final int MAX_HEAT = 5000;
    public static final short SLOT_METAL = 0;
    public static final short SLOT_PLAN = 1;
    public static final short SLOT_RESULT = 2;
    public static final short SLOT_CRAFTING_1 = 3;
    public static final short SLOT_INVENTORY_1 = 12;
    public static final short SLOT_INVENTORY_COUNT = 18;
    private GenericInventoryAdapter inventory = new GenericInventoryAdapter(30, "Items");
    private TankSlot moltenTank = new TankSlot(2000);
    private int heat = 0;
    private int guiMeltingPoint = 0;
    private LiquidStack pendingSmelt;

    public MachineFabricator(TileMachine tile) {
        super(tile);
    }

    @Override
    public String getName() {
        return "tile.machine.11";
    }

    @Override
    public void openGui(ih player, ni tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.FabricatorGUI.ordinal(), player.bi, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("Heat", this.heat);
        ph nbtMoltenTank = new ph();
        this.moltenTank.writeToNBT(nbtMoltenTank);
        nbttagcompound.a("MoltenTank", (jz)nbtMoltenTank);
        if (this.pendingSmelt != null) {
            ph smelt = new ph();
            this.pendingSmelt.writeToNBT(smelt);
            nbttagcompound.a("PendingSmelt", (jz)smelt);
        }
        this.inventory.b(nbttagcompound);
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.heat = nbttagcompound.f("Heat");
        this.moltenTank = new TankSlot(2000);
        if (nbttagcompound.c("MoltenTank")) {
            this.moltenTank.readFromNBT(nbttagcompound.m("MoltenTank"));
        }
        if (nbttagcompound.c("PendingSmelt")) {
            ph smelt = nbttagcompound.m("PendingSmelt");
            this.pendingSmelt = LiquidStack.loadLiquidStackFromNBT(smelt);
        }
        this.inventory.a(nbttagcompound);
    }

    @Override
    public void updateServerSide() {
        Smelting smelt;
        if (this.moltenTank.quantity > 0 && (smelt = RecipeManager.findMatchingSmelting(this.moltenTank.asLiquidStack())) != null && this.heat < smelt.meltingPoint) {
            this.moltenTank.empty(5, true);
        }
        if (this.pendingSmelt != null) {
            int filled = this.moltenTank.fill(Orientations.Unknown, this.pendingSmelt, true);
            this.pendingSmelt.liquidAmount -= filled;
            if (this.pendingSmelt.liquidAmount <= 0) {
                this.pendingSmelt = null;
            }
        } else if (this.moltenTank.quantity < this.moltenTank.capacity && this.inventory.g_(0) != null && (smelt = RecipeManager.findMatchingSmelting(this.inventory.g_(0))) != null && smelt.meltingPoint <= this.heat) {
            this.a(0, 1);
            this.pendingSmelt = smelt.product.copy();
        }
        this.dissipateHeat();
    }

    @Override
    public boolean doWork() {
        return this.addHeat(25);
    }

    private boolean addHeat(int addition) {
        if (this.heat >= 5000) {
            return false;
        }
        this.heat += addition;
        if (this.heat > 5000) {
            this.heat = 5000;
        }
        return true;
    }

    private void dissipateHeat() {
        if (this.heat > 2500) {
            this.heat -= 2;
        } else if (this.heat > 0) {
            --this.heat;
        }
    }

    public Object[] getPlan() {
        if (this.inventory.g_(1) == null) {
            return null;
        }
        Recipe myRecipe = RecipeManager.findMatchingRecipe(this.inventory.g_(1));
        if (myRecipe == null) {
            return null;
        }
        return myRecipe.internal.getIngredients();
    }

    @Override
    public kp getResult() {
        Recipe myRecipe = RecipeManager.findMatchingRecipe(this.inventory.g_(1), this.moltenTank.asLiquidStack(), this.inventory.getStacks(3, 9));
        if (myRecipe == null) {
            return null;
        }
        return myRecipe.internal.b().j();
    }

    @Override
    public kp takeResult(boolean consumeRecipe) {
        Recipe myRecipe = RecipeManager.findMatchingRecipe(this.inventory.g_(1), this.moltenTank.asLiquidStack(), this.inventory.getStacks(3, 9));
        if (myRecipe == null) {
            return null;
        }
        LiquidStack liquid = myRecipe.molten;
        if (this.removeFromInventory(1, this.inventory.getStacks(3, 9), false)) {
            this.removeFromInventory(1, this.inventory.getStacks(3, 9), true);
            this.moltenTank.empty(liquid.liquidAmount, true);
        } else if (consumeRecipe) {
            this.removeFromCraftMatrix(myRecipe);
            this.moltenTank.empty(liquid.liquidAmount, true);
        } else {
            return null;
        }
        return myRecipe.internal.b().j();
    }

    private void removeFromCraftMatrix(Recipe recipe) {
        Object[] ingredients = recipe.internal.getIngredients();
        for (int i = 0; i < ingredients.length; ++i) {
            if (ingredients[i] == null) continue;
            int decrease = 0;
            decrease = ingredients[i] instanceof kp ? ((kp)ingredients[i]).a : ((kp)((ArrayList)ingredients[i]).get((int)0)).a;
            this.inventory.a(3 + i, decrease);
        }
    }

    private boolean removeFromInventory(int count, kp[] set, boolean doRemove) {
        boolean hasRemoved = true;
        for (int i = 0; i < count; ++i) {
            kp[] condensedSet;
            for (kp req : condensedSet = StackUtils.condenseStacks(set)) {
                for (int j = 12; j < 30; ++j) {
                    kp pol = this.inventory.g_(j);
                    if (pol == null || !StackUtils.isItemOreEqual(pol, req)) continue;
                    if (pol.a > req.a) {
                        if (doRemove) {
                            this.inventory.a(j, req.a);
                        }
                        req.a = 0;
                        continue;
                    }
                    if (doRemove) {
                        this.inventory.a(j, req.a);
                    }
                    req.a -= pol.a;
                }
            }
            boolean hasLeft = false;
            for (kp req : condensedSet) {
                if (req == null || req.a <= 0) continue;
                hasLeft = true;
            }
            if (!hasLeft) continue;
            hasRemoved = false;
        }
        return hasRemoved;
    }

    @Override
    public boolean isWorking() {
        return false;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 5000;
    }

    public int getMeltingPoint() {
        Smelting smelt;
        if (this.moltenTank.quantity > 0) {
            Smelting smelt2 = RecipeManager.findMatchingSmelting(this.moltenTank.asLiquidStack());
            if (smelt2 != null) {
                return smelt2.meltingPoint;
            }
        } else if (this.g_(0) != null && (smelt = RecipeManager.findMatchingSmelting(this.g_(0))) != null) {
            return smelt.meltingPoint;
        }
        return 0;
    }

    public int getMeltingPointScaled(int i) {
        if (this.guiMeltingPoint > 0) {
            return this.guiMeltingPoint * i / 5000;
        }
        int meltingPoint = this.getMeltingPoint();
        if (meltingPoint <= 0) {
            return 0;
        }
        return meltingPoint * i / 5000;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.moltenTank.liquidId = j;
                break;
            }
            case 1: {
                this.moltenTank.quantity = j;
                break;
            }
            case 2: {
                this.heat = j;
                break;
            }
            case 3: {
                this.guiMeltingPoint = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ew container, ff iCrafting) {
        iCrafting.a(container, 0, this.moltenTank.liquidId);
        iCrafting.a(container, 1, this.moltenTank.quantity);
        iCrafting.a(container, 2, this.heat);
        iCrafting.a(container, 3, this.getMeltingPoint());
    }

    @Override
    public boolean addItem(kp stack, boolean doAdd, Orientations from) {
        return this.inventory.tryAddStack(stack, 12, 18, false, doAdd);
    }

    @Override
    public kp extractItem(boolean doRemove, Orientations from) {
        if (doRemove) {
            return this.takeResult(false);
        }
        return this.getResult();
    }

    @Override
    public int c() {
        return this.inventory.c();
    }

    @Override
    public kp g_(int i) {
        return this.inventory.g_(i);
    }

    @Override
    public kp a(int i, int j) {
        return this.inventory.a(i, j);
    }

    @Override
    public void a(int i, kp itemstack) {
        this.inventory.a(i, itemstack);
    }

    @Override
    public int a() {
        return this.inventory.a();
    }

    @Override
    public kp b(int slot) {
        return this.inventory.b(slot);
    }

    @Override
    public TankSlot[] getLiquidContents() {
        return new TankSlot[]{this.moltenTank};
    }

    public static void initialize() {
        RecipeManagers.fabricatorManager.addSmelting(new kp(vz.M), new LiquidStack(ForestryItem.liquidGlass, 1000), 1000);
        RecipeManagers.fabricatorManager.addSmelting(new kp(vz.bq), new LiquidStack(ForestryItem.liquidGlass, 375), 1000);
        RecipeManagers.fabricatorManager.addSmelting(new kp(vz.E), new LiquidStack(ForestryItem.liquidGlass, 1000), 3000);
    }

    public static class RecipeManager
    implements IFabricatorManager {
        private static ArrayList recipes = new ArrayList();
        private static ArrayList smeltings = new ArrayList();

        @Override
        public void addRecipe(kp plan, LiquidStack molten, kp result, Object[] pattern) {
            recipes.add(new Recipe(plan, molten, ShapedRecipeInternal.createShapedRecipe(pattern, result)));
        }

        @Override
        public void addSmelting(kp resource, LiquidStack molten, int meltingPoint) {
            smeltings.add(new Smelting(resource, molten, meltingPoint));
        }

        public static Recipe findMatchingRecipe(kp plan) {
            for (Recipe recipe : recipes) {
                if (!recipe.matches(plan)) continue;
                return recipe;
            }
            return null;
        }

        public static Recipe findMatchingRecipe(kp plan, LiquidStack liquid, kp[] resources) {
            kp[][] gridResources = new kp[3][3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    gridResources[j][i] = resources[i * 3 + j];
                }
            }
            for (Recipe recipe : recipes) {
                if (!recipe.matches(plan, gridResources) || !recipe.hasLiquid(liquid)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isResourceLiquid(LiquidStack liquid) {
            for (Recipe recipe : recipes) {
                if (!recipe.hasLiquid(liquid)) continue;
                return true;
            }
            return false;
        }

        public static Smelting findMatchingSmelting(kp resource) {
            if (resource == null) {
                return null;
            }
            for (Smelting smelting : smeltings) {
                if (!smelting.matches(resource)) continue;
                return smelting;
            }
            return null;
        }

        public static Smelting findMatchingSmelting(LiquidStack product) {
            if (product == null) {
                return null;
            }
            for (Smelting smelting : smeltings) {
                if (!smelting.matches(product)) continue;
                return smelting;
            }
            return null;
        }

        @Override
        public List getRecipes() {
            return null;
        }
    }

    public static class Smelting {
        kp resource;
        LiquidStack product;
        int meltingPoint;

        public Smelting(kp resource, LiquidStack molten, int meltingPoint) {
            this.resource = resource;
            this.product = molten;
            this.meltingPoint = meltingPoint;
        }

        public boolean matches(kp resource) {
            return this.resource.a(resource);
        }

        public boolean matches(LiquidStack product) {
            return this.product.isLiquidEqual(product);
        }
    }

    public static class Recipe {
        kp plan;
        LiquidStack molten;
        ShapedRecipeInternal internal;

        public Recipe(kp plan, LiquidStack molten, ShapedRecipeInternal internal) {
            this.plan = plan;
            this.molten = molten;
            this.internal = internal;
        }

        public boolean matches(kp plan) {
            if (this.plan == null) {
                return true;
            }
            if (plan == null && this.plan == null) {
                return true;
            }
            if (plan == null && this.plan != null) {
                return false;
            }
            return plan.a(this.plan);
        }

        public boolean matches(kp plan, kp[][] resources) {
            if (!this.matches(plan)) {
                return false;
            }
            return this.internal.matches(resources);
        }

        public boolean hasLiquid(LiquidStack resource) {
            if (!resource.isLiquidEqual(this.molten)) {
                return false;
            }
            return this.molten.liquidAmount <= resource.liquidAmount;
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(qj tile) {
            return new MachineFabricator((TileMachine)tile);
        }
    }
}

