/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import forestry.api.core.ForestryAPI;
import forestry.api.core.ForestryBlock;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.api.liquids.LiquidStack;
import forestry.api.recipes.ICarpenterManager;
import forestry.api.recipes.IGenericCrate;
import forestry.api.recipes.RecipeManagers;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.GenericInventoryAdapter;
import forestry.core.utils.Orientations;
import forestry.core.utils.ShapedRecipeInternal;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import forestry.core.utils.TileInventoryAdapter;
import forestry.factory.ContainerCarpenter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class MachineCarpenter
extends Machine {
    public static final int SLOT_CRAFTING_1 = 0;
    public static final int SLOT_BOX = 9;
    public static final int SLOT_PRODUCT = 10;
    public static final int SLOT_CAN_INPUT = 11;
    public static final short SLOT_INVENTORY_1 = 12;
    public static final short SLOT_INVENTORY_COUNT = 18;
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    private TileInventoryAdapter inventory;
    public Recipe currentRecipe;
    public ContainerCarpenter activeContainer;
    private int packageTime;
    private int totalTime;
    private kp currentProduct;
    private kp pendingProduct;

    public kp getBoxStack() {
        return this.inventory.g_(9);
    }

    public MachineCarpenter(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("carpenter"));
        this.inventory = new TileInventoryAdapter(tile, 30, "Items");
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.5");
    }

    @Override
    public void openGui(ih player, ni tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.CarpenterGUI.ordinal(), player.bi, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("PackageTime", this.packageTime);
        nbttagcompound.a("PackageTotalTime", this.totalTime);
        ph NBTresourceSlot = new ph();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.a("ResourceTank", (jz)NBTresourceSlot);
        this.inventory.b(nbttagcompound);
        if (this.pendingProduct != null) {
            ph nbttagcompoundP = new ph();
            this.pendingProduct.b(nbttagcompoundP);
            nbttagcompound.a("PendingProduct", (jz)nbttagcompoundP);
        }
        if (this.currentProduct != null) {
            ph nbttagcompoundC = new ph();
            this.currentProduct.b(nbttagcompoundC);
            nbttagcompound.a("CurrentProduct", (jz)nbttagcompoundC);
        }
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        ph nbttagcompoundP;
        super.readFromNBT(nbttagcompound);
        this.packageTime = nbttagcompound.f("PackageTime");
        this.totalTime = nbttagcompound.f("PackageTotalTime");
        this.resourceTank = new TankSlot(10000);
        if (nbttagcompound.c("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.m("ResourceTank"));
        }
        this.inventory.a(nbttagcompound);
        if (nbttagcompound.c("PendingProduct")) {
            nbttagcompoundP = nbttagcompound.m("PendingProduct");
            this.pendingProduct = kp.a((ph)nbttagcompoundP);
        }
        if (nbttagcompound.c("CurrentProduct")) {
            nbttagcompoundP = nbttagcompound.m("CurrentProduct");
            this.currentProduct = kp.a((ph)nbttagcompoundP);
        }
        ContainerCarpenter container = new ContainerCarpenter((TileMachine)this.tile);
        this.currentRecipe = RecipeManager.findMatchingRecipe(this.getBoxStack(), container.craftMatrix);
    }

    @Override
    public void updateServerSide() {
        LiquidContainer container;
        if (this.tile.k.o() % 20L * 10L != 0L) {
            return;
        }
        if (this.inventory.g_(11) != null && (container = LiquidManager.getLiquidContainer(this.inventory.g_(11))) != null && RecipeManager.isResourceLiquid(container.liquid)) {
            this.inventory.a(11, this.replenishByContainer(this.inventory.g_(11), container, this.resourceTank));
            if (this.inventory.g_((int)11).a <= 0) {
                this.inventory.a(11, null);
            }
        }
        if (this.tile.k.o() % 40L * 10L != 0L) {
            return;
        }
        if (this.currentRecipe == null || !this.validateResources()) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean doWork() {
        if (this.packageTime > 0) {
            --this.packageTime;
            if (this.currentRecipe == null || !this.currentProduct.c(this.currentRecipe.getCraftingResult()) || !this.validateResources()) {
                this.currentProduct = null;
                this.totalTime = 0;
                this.packageTime = 0;
                return false;
            }
            if (this.packageTime <= 0) {
                this.pendingProduct = this.currentProduct;
                this.currentProduct = null;
                this.totalTime = 0;
                this.removeResources(this.currentRecipe);
                if (this.activeContainer != null) {
                    this.activeContainer.updateProductDisplay();
                }
                return this.tryAddPending();
            }
            return true;
        }
        if (this.pendingProduct != null) {
            return this.tryAddPending();
        }
        if (this.currentRecipe != null) {
            if (!this.validateResources()) {
                return false;
            }
            this.packageTime = this.totalTime = this.currentRecipe.packagingTime;
            this.currentProduct = this.currentRecipe.getCraftingResult();
            if (this.activeContainer != null) {
                this.activeContainer.updateProductDisplay();
            }
            return true;
        }
        return false;
    }

    private boolean validateResources() {
        if (this.currentRecipe.liquid != null && this.resourceTank.quantity < ((Recipe)this.currentRecipe).liquid.liquidAmount) {
            return false;
        }
        if (this.currentRecipe.box != null && this.inventory.g_(9) == null) {
            return false;
        }
        return StackUtils.containsSets(this.inventory.getStacks(0, 9), this.inventory.getStacks(12, 18), true) > 0;
    }

    private void removeResources(Recipe recipe) {
        if (recipe.liquid != null) {
            this.resourceTank.quantity -= ((Recipe)recipe).liquid.liquidAmount;
        }
        if (recipe.box != null) {
            this.inventory.a(9, 1);
        }
        this.removeSets(1, this.inventory.getStacks(0, 9));
    }

    private void removeSets(int count, kp[] set) {
        for (int i = 0; i < count; ++i) {
            kp[] condensedSet;
            for (kp req : condensedSet = StackUtils.condenseStacks(set)) {
                for (int j = 12; j < 30; ++j) {
                    kp pol = this.inventory.g_(j);
                    if (pol == null || !StackUtils.isItemOreEqual(pol, req)) continue;
                    kp removed = this.inventory.a(j, req.a);
                    req.a -= removed.a;
                }
            }
        }
    }

    private boolean tryAddPending() {
        if (this.inventory.g_(10) == null) {
            this.inventory.a(10, this.pendingProduct.j());
            this.pendingProduct = null;
            return true;
        }
        if (this.inventory.g_(10).a(this.pendingProduct) && this.inventory.g_((int)10).a <= this.inventory.g_(10).b() - this.pendingProduct.a) {
            this.inventory.g_((int)10).a += this.pendingProduct.a;
            this.pendingProduct = null;
            return true;
        }
        this.setErrorState(EnumErrorCode.NOSPACE);
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.packageTime > 0;
    }

    @Override
    public boolean hasWork() {
        if (this.currentRecipe == null) {
            return false;
        }
        if (this.inventory.g_(10) != null && this.inventory.g_(10).b() - this.inventory.g_((int)10).a < this.currentRecipe.getCraftingResult().a) {
            return false;
        }
        return this.validateResources();
    }

    public int getCraftingProgressScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.packageTime * i / this.totalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return this.rateTankLevel(this.getResourceScaled(100));
    }

    public GenericInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public int c() {
        return this.inventory.c() - 9;
    }

    @Override
    public kp g_(int i) {
        return this.inventory.g_(i + 9);
    }

    @Override
    public void a(int i, kp itemstack) {
        this.inventory.a(i + 9, itemstack);
    }

    @Override
    public kp a(int i, int j) {
        return this.inventory.a(i + 9, j);
    }

    @Override
    public kp b(int slot) {
        return this.inventory.b(slot);
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0) {
            return 1;
        }
        if (side == 1) {
            return 0;
        }
        return 3;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 0) {
            return 1;
        }
        if (side == 1) {
            return 1;
        }
        return 18;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.packageTime = j;
                break;
            }
            case 1: {
                this.totalTime = j;
                break;
            }
            case 2: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 3: {
                this.resourceTank.quantity = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ew container, ff iCrafting) {
        iCrafting.a(container, 0, this.packageTime);
        iCrafting.a(container, 1, this.totalTime);
        iCrafting.a(container, 2, this.resourceTank.liquidId);
        iCrafting.a(container, 3, this.resourceTank.quantity);
    }

    @Override
    public boolean addItem(kp stack, boolean doAdd, Orientations from) {
        LiquidContainer container = LiquidManager.getLiquidContainer(stack);
        if (container != null && RecipeManager.isResourceLiquid(container.liquid)) {
            return this.inventory.tryAddStack(stack, 11, 1, false, doAdd);
        }
        if (this.currentRecipe != null && this.currentRecipe.isIngredient(stack)) {
            return this.inventory.tryAddStack(stack, 12, 18, false, doAdd);
        }
        if (RecipeManager.isBox(stack)) {
            return this.inventory.tryAddStack(stack, 9, 1, false, doAdd);
        }
        return false;
    }

    @Override
    public kp extractItem(boolean doRemove, Orientations from) {
        if (this.inventory.g_(10) == null) {
            return null;
        }
        if (this.inventory.g_((int)10).a <= 0) {
            return null;
        }
        kp product = new kp(this.inventory.g_((int)10).c, 1, this.inventory.g_(10).h());
        if (doRemove) {
            this.inventory.a(10, 1);
        }
        return product;
    }

    @Override
    public int fill(Orientations from, int quantity, int id2, boolean doFill) {
        int used = this.resourceTank.fill(from, quantity, id2, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public int getCapacity() {
        return 10000;
    }

    @Override
    public TankSlot[] getLiquidContents() {
        return new TankSlot[]{this.resourceTank};
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static void initialize() {
        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(vz.B.bO, 250), null, new kp(ForestryItem.oakStick, 2), new Object[]{"#", "#", Character.valueOf('#'), vz.J});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(vz.B.bO, 250), null, new kp(ForestryItem.woodPulp, 4), new Object[]{"#", Character.valueOf('#'), vz.J});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(vz.B.bO, 250), null, new kp(id.aJ, 1), new Object[]{"#", "#", Character.valueOf('#'), ForestryItem.woodPulp});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(vz.B.bO, 1000), null, new kp(ForestryBlock.soil, 9, 0), new Object[]{"###", "#X#", "###", Character.valueOf('#'), vz.v, Character.valueOf('X'), ForestryItem.mulch});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(vz.B.bO, 1000), null, new kp(ForestryBlock.soil, 8, 1), new Object[]{"#X#", "XYX", "#X#", Character.valueOf('#'), vz.v, Character.valueOf('X'), vz.E, Character.valueOf('Y'), ForestryItem.mulch});
        RecipeManagers.carpenterManager.addRecipe(75, new LiquidStack(vz.B.bO, 5000), null, new kp(ForestryItem.hardenedMachine), new Object[]{"# #", " Y ", "# #", Character.valueOf('#'), id.m, Character.valueOf('Y'), ForestryItem.sturdyMachine});
        RecipeManagers.carpenterManager.addRecipe(20, new LiquidStack(vz.B.bO, 1000), null, new kp(ForestryItem.circuitboards, 1, 0), new Object[]{"R R", "R#R", "R R", Character.valueOf('#'), "ingotTin", Character.valueOf('R'), id.aB});
        RecipeManagers.carpenterManager.addRecipe(40, new LiquidStack(vz.B.bO, 1000), null, new kp(ForestryItem.circuitboards, 1, 1), new Object[]{"R#R", "R#R", "R#R", Character.valueOf('#'), "ingotBronze", Character.valueOf('R'), id.aB});
        RecipeManagers.carpenterManager.addRecipe(80, new LiquidStack(vz.B.bO, 1000), null, new kp(ForestryItem.circuitboards, 1, 2), new Object[]{"R#R", "R#R", "R#R", Character.valueOf('#'), id.o, Character.valueOf('R'), id.aB});
        RecipeManagers.carpenterManager.addRecipe(40, new LiquidStack(vz.B.bO, 1000), null, new kp(ForestryItem.solderingIron), new Object[]{" # ", "# #", "  B", Character.valueOf('#'), id.n, Character.valueOf('B'), "ingotBronze"});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(vz.B.bO, 1000), null, new kp(ForestryItem.iodineCharge, 1), new Object[]{"Z#Z", "#Y#", "X#X", Character.valueOf('#'), ForestryItem.pollen, Character.valueOf('X'), id.L, Character.valueOf('Y'), ForestryItem.canEmpty, Character.valueOf('Z'), ForestryItem.honeyDrop});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(vz.B.bO, 1000), null, new kp(ForestryItem.craftingMaterial, 1, 4), new Object[]{"Z#Z", "#Y#", "X#X", Character.valueOf('#'), ForestryItem.royalJelly, Character.valueOf('X'), id.L, Character.valueOf('Y'), ForestryItem.canEmpty, Character.valueOf('Z'), ForestryItem.honeydew});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(vz.B.bO, 1000), null, new kp(ForestryItem.minerBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), id.m, Character.valueOf('W'), new kp(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.minerBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(vz.B.bO, 1000), null, new kp(ForestryItem.diggerBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), id.m, Character.valueOf('W'), new kp(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.diggerBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(vz.B.bO, 1000), null, new kp(ForestryItem.foresterBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), id.m, Character.valueOf('W'), new kp(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.foresterBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(vz.B.bO, 1000), null, new kp(ForestryItem.hunterBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), id.m, Character.valueOf('W'), new kp(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.hunterBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(vz.B.bO, 1000), null, new kp(ForestryItem.adventurerBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), id.m, Character.valueOf('W'), new kp(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.adventurerBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(vz.B.bO, 1000), null, new kp(ForestryItem.builderBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), id.m, Character.valueOf('W'), new kp(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.builderBackpack});
        RecipeManagers.carpenterManager.addRecipe(100, null, new kp(id.bm, 1), new Object[]{" # ", "###", " # ", Character.valueOf('#'), new kp(ForestryItem.craftingMaterial, 1, 1)});
        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(vz.B.bO, 500), null, new kp(ForestryItem.craftingMaterial, 1, 3), new Object[]{"###", "###", "###", Character.valueOf('#'), new kp(ForestryItem.craftingMaterial, 1, 2)});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(vz.B.bO, 1000), null, new kp(ForestryItem.carton, 2), new Object[]{" # ", "# #", " # ", Character.valueOf('#'), ForestryItem.woodPulp});
        RecipeManagers.carpenterManager.addRecipe(20, new LiquidStack(vz.B.bO, 1000), null, new kp(ForestryItem.crate, 24), new Object[]{" # ", "# #", " # ", Character.valueOf('#'), vz.J});
        RecipeManagers.carpenterManager.addRecipe(20, new LiquidStack(0, 0), new kp(ForestryItem.carton), new kp(ForestryItem.kitPickaxe), new Object[]{"###", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), ForestryItem.oakStick});
        RecipeManagers.carpenterManager.addRecipe(20, new LiquidStack(0, 0), new kp(ForestryItem.carton), new kp(ForestryItem.kitShovel), new Object[]{" # ", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), ForestryItem.oakStick});
        RecipeManagers.carpenterManager.addRecipe(null, new kp(ForestryItem.ingotBronze.c, 2, ForestryItem.ingotBronze.i()), new Object[]{"#", Character.valueOf('#'), ForestryItem.brokenBronzePickaxe});
        RecipeManagers.carpenterManager.addRecipe(null, ForestryItem.ingotBronze, new Object[]{"#", Character.valueOf('#'), ForestryItem.brokenBronzeShovel});
        RecipeManagers.carpenterManager.addRecipe(100, new LiquidStack(vz.B.bO, 2000), null, new kp(ForestryItem.beealyzer), new Object[]{"X#X", "X#X", "RDR", Character.valueOf('#'), vz.bq, Character.valueOf('X'), "ingotTin", Character.valueOf('R'), id.aB, Character.valueOf('D'), id.m});
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedWood));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedCobblestone));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedDirt));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedStone));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedBrick));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedCacti));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedSand));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedObsidian));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedNetherrack));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedSoulsand));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedSandstone));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedBogearth));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedHumus));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedNetherbrick));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedPeat));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedApatite));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedFertilizer));
        ((RecipeManager)RecipeManagers.carpenterManager).addCrating("ingotTin", ForestryItem.ingotTin, new kp((id)ForestryItem.cratedTin));
        ((RecipeManager)RecipeManagers.carpenterManager).addCrating("ingotCopper", ForestryItem.ingotCopper, new kp((id)ForestryItem.cratedCopper));
        ((RecipeManager)RecipeManagers.carpenterManager).addCrating("ingotBronze", ForestryItem.ingotBronze, new kp((id)ForestryItem.cratedBronze));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedWheat));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedMycelium));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedMulch));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedCookies));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedHoneycombs));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedBeeswax));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedPollen));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedPropolis));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedHoneydew));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedRoyalJelly));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedCocoaComb));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedRedstone));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedLapis));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedReeds));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedClay));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedGlowstone));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedApples));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedNetherwart));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedSimmeringCombs));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedStringyCombs));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedFrozenCombs));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedDrippingCombs));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedRefractoryWax));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedPhosphor));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedAsh));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedCharcoal));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedGravel));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedCoal));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedSeeds));
        RecipeManagers.carpenterManager.addCrating(new kp((id)ForestryItem.cratedSaplings));
    }

    public static class RecipeManager
    implements ICarpenterManager {
        private static ArrayList recipes = new ArrayList();

        @Override
        public void addCrating(kp crated) {
            this.addCrating(((IGenericCrate)crated.a()).getContained(crated), crated);
        }

        @Override
        public void addCrating(id toCrate, IGenericCrate crated) {
            this.addCrating(new kp(toCrate), new kp((id)crated));
        }

        @Override
        public void addCrating(kp toCrate, kp crated) {
            this.addRecipe(5, new LiquidStack(vz.B.bO, 100), new kp(ForestryItem.crate), crated, new Object[]{"###", "###", "###", Character.valueOf('#'), toCrate});
            this.addRecipe(null, new kp(toCrate.c, 9, toCrate.h()), new Object[]{"#", Character.valueOf('#'), crated});
        }

        public void addCrating(String toCrate, kp unpack, kp crated) {
            this.addRecipe(5, new LiquidStack(vz.B.bO, 100), new kp(ForestryItem.crate), crated, new Object[]{"###", "###", "###", Character.valueOf('#'), toCrate});
            this.addRecipe(null, new kp(unpack.c, 9, unpack.h()), new Object[]{"#", Character.valueOf('#'), crated});
        }

        @Override
        public void addRecipe(kp box, kp product, Object[] materials) {
            this.addRecipe(5, null, box, product, materials);
        }

        @Override
        public void addRecipe(int packagingTime, kp box, kp product, Object[] materials) {
            this.addRecipe(packagingTime, null, box, product, materials);
        }

        @Override
        public void addRecipe(int packagingTime, LiquidStack liquid, kp box, kp product, Object[] materials) {
            recipes.add(new Recipe(packagingTime, liquid, box, ShapedRecipeInternal.createShapedRecipe(materials, product)));
        }

        public static Recipe findMatchingRecipe(kp item, nz inventorycrafting) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(item, inventorycrafting)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isResourceLiquid(LiquidStack liquid) {
            for (Recipe recipe : recipes) {
                if (!recipe.hasLiquid(liquid)) continue;
                return true;
            }
            return false;
        }

        public static boolean isBox(kp resource) {
            for (Recipe recipe : recipes) {
                if (!recipe.hasBox(resource)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List getRecipes() {
            return null;
        }
    }

    public static class Recipe {
        private int packagingTime;
        private LiquidStack liquid;
        private kp box;
        private ShapedRecipeInternal internal;

        public Recipe(int packagingTime, LiquidStack liquid, kp box, ShapedRecipeInternal internal) {
            this.packagingTime = packagingTime;
            this.liquid = liquid;
            this.box = box;
            this.internal = internal;
        }

        public kp getCraftingResult() {
            return this.internal.b();
        }

        public boolean matches(kp item, nz inventorycrafting) {
            if (this.box != null && item == null) {
                return false;
            }
            if (this.box != null && !this.box.a(item)) {
                return false;
            }
            return this.internal.a(inventorycrafting);
        }

        public boolean hasLiquid(LiquidStack resource) {
            if (this.liquid != null && resource != null) {
                return this.liquid.isLiquidEqual(resource);
            }
            return false;
        }

        public boolean hasBox(kp resource) {
            if (this.box == null && resource == null) {
                return true;
            }
            if (this.box == null) {
                return true;
            }
            if (this.box.h() > 0) {
                return this.box.a(resource);
            }
            return this.box.c == resource.c;
        }

        public boolean isIngredient(kp resource) {
            return this.internal.isIngredient(resource);
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(qj tile) {
            return new MachineCarpenter((TileMachine)tile);
        }
    }
}

