/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.circuits;

import forestry.core.circuits.Circuit;
import forestry.core.gadgets.TileEngine;
import forestry.energy.EngineTin;

public abstract class CircuitElectricChange
extends Circuit {
    int euChange = 7;
    int mjChange = 2;

    public CircuitElectricChange(int id2, boolean requiresDiscovery, String name, String usage, String[] descriptions) {
        super(id2, requiresDiscovery, name, usage, descriptions);
    }

    protected void configureChange(int euChange, int mjChange) {
        this.euChange = euChange;
        this.mjChange = mjChange;
    }

    @Override
    public boolean isCircuitable(qj tile) {
        return tile instanceof TileEngine && ((TileEngine)tile).engine instanceof EngineTin;
    }

    @Override
    public void onInsertion(qj tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        EngineTin engine = (EngineTin)((TileEngine)tile).engine;
        engine.changeEnergyConfig(this.euChange, this.mjChange, 2 * this.euChange);
    }

    @Override
    public void onLoad(qj tile) {
        this.onInsertion(tile);
    }

    @Override
    public void onRemoval(qj tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        EngineTin engine = (EngineTin)((TileEngine)tile).engine;
        engine.changeEnergyConfig(-this.euChange, -this.mjChange, -(2 * this.euChange));
    }

    @Override
    public void onTick(qj tile) {
    }
}

