/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import forestry.api.core.ForestryAPI;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FuelManager;
import forestry.core.EnumErrorCode;
import forestry.core.TemperatureState;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.EngineFactory;
import forestry.core.gadgets.TileEngine;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.Orientations;
import forestry.core.utils.StackUtils;
import java.util.LinkedList;

public class EngineCopper
extends Engine {
    private int fuelItemId;
    private int burnTime;
    private int totalBurnTime;
    private int ashProduction;
    private int ashForItem;
    private kp[] itemStacks = new kp[5];
    private int wasteSlot1 = 1;

    public EngineCopper(TileEngine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("engine.copper"));
        this.maxEnergy = 20000;
        this.maxEnergyExtracted = 400;
        this.maxHeat = 10000;
        this.ashForItem = 7500;
    }

    @Override
    public void openGui(ih player, ni tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.EngineCopperGUI.ordinal(), player.bi, this.tile.l, this.tile.m, this.tile.n);
    }

    private int getFuelSlot() {
        if (this.itemStacks[0] == null) {
            return -1;
        }
        if (this.determineFuelValue(this.itemStacks[0].c) > 0) {
            return 0;
        }
        return -1;
    }

    private int getFreeWasteSlot() {
        for (int i = 1; i <= 4; ++i) {
            if (this.itemStacks[i] == null) {
                return i;
            }
            if (this.itemStacks[i].c != ForestryItem.ash.bP || this.itemStacks[i].a >= 64) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.tile.k.o() % 20L * 10L != 0L) {
            return;
        }
        if (this.mayBurn() && this.burnTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return;
        }
        if (this.forceCooldown) {
            this.setErrorState(EnumErrorCode.FORCEDCOOLDOWN);
            return;
        }
        int fuelSlot = this.getFuelSlot();
        if (fuelSlot >= 0 && this.determineBurnDuration(this.itemStacks[fuelSlot].c) > 0) {
            this.setErrorState(EnumErrorCode.OK);
        } else {
            this.setErrorState(EnumErrorCode.NOFUEL);
        }
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.burnTime > 0) {
            --this.burnTime;
            this.addAsh(1);
            if (this.tile.isActivated()) {
                this.currentOutput = this.determineFuelValue(this.fuelItemId);
                this.addEnergy(this.currentOutput);
            }
        } else if (this.tile.isActivated()) {
            int fuelslot = this.getFuelSlot();
            int wasteslot = this.getFreeWasteSlot();
            if (fuelslot >= 0 && wasteslot >= 0) {
                this.burnTime = this.totalBurnTime = this.determineBurnDuration(this.itemStacks[fuelslot].c);
                if (this.burnTime > 0) {
                    this.fuelItemId = this.itemStacks[fuelslot].c;
                    this.a(fuelslot, 1);
                }
            }
        }
    }

    @Override
    public int dissipateHeat() {
        TemperatureState tempState;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 0;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((tempState = this.getTemperatureState()) == TemperatureState.OVERHEATING || tempState == TemperatureState.OPERATING_TEMPERATURE) {
            ++loss;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int heat = 0;
        if (this.isBurning()) {
            ++heat;
            if ((double)this.storedEnergy / (double)this.maxEnergy > 0.5) {
                ++heat;
            }
        }
        this.addHeat(heat);
        return heat;
    }

    private void addAsh(int amount) {
        this.ashProduction += amount;
        if (this.ashProduction < this.ashForItem) {
            return;
        }
        int wasteslot = this.getFreeWasteSlot();
        if (wasteslot >= 0) {
            if (this.itemStacks[wasteslot] == null) {
                this.itemStacks[wasteslot] = new kp(ForestryItem.ash, 1);
            } else {
                ++this.itemStacks[wasteslot].a;
            }
        }
        this.ashProduction = 0;
        this.dumpStash();
    }

    private int determineFuelValue(int fuelid) {
        if (fuelid == 0) {
            return 0;
        }
        if (FuelManager.copperEngineFuel.containsKey(fuelid)) {
            return ((EngineCopperFuel)FuelManager.copperEngineFuel.get((Object)Integer.valueOf((int)fuelid))).powerPerCycle;
        }
        return 0;
    }

    private int determineBurnDuration(int fuelid) {
        if (fuelid == 0) {
            return 0;
        }
        if (FuelManager.copperEngineFuel.containsKey(fuelid)) {
            return ((EngineCopperFuel)FuelManager.copperEngineFuel.get((Object)Integer.valueOf((int)fuelid))).burnDuration;
        }
        return 0;
    }

    private void dumpStash() {
        buildcraft.api.Orientations[] pipes = BlockUtil.getPipeDirections(this.tile.k, this.tile.Coords(), this.tile.getOrientation());
        if (pipes.length > 0) {
            this.dumpToPipe(pipes);
        }
    }

    private void dumpToPipe(buildcraft.api.Orientations[] pipes) {
        for (int i = this.wasteSlot1; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null || this.itemStacks[i].a <= 0) continue;
            buildcraft.api.Orientations[] filtered = BlockUtil.filterPipeDirections(pipes, new buildcraft.api.Orientations[]{this.tile.getOrientation()});
            while (this.itemStacks[i].a > 0 && filtered.length > 0) {
                BlockUtil.putFromStackIntoPipe(this.tile, filtered, this.itemStacks[i]);
            }
            if (this.itemStacks[i].a > 0) continue;
            this.itemStacks[i] = null;
        }
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.burnTime > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.totalBurnTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalBurnTime;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        int fuelSlot = this.getFuelSlot();
        if (fuelSlot < 0) {
            return false;
        }
        return (float)this.itemStacks[fuelSlot].a / (float)this.itemStacks[fuelSlot].b() > percentage;
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.fuelItemId = nbttagcompound.f("EngineFuelItem");
        this.burnTime = nbttagcompound.f("EngineBurnTime");
        this.totalBurnTime = nbttagcompound.f("EngineTotalTime");
        if (nbttagcompound.c("AshProduction")) {
            this.ashProduction = nbttagcompound.f("AshProduction");
        }
        tx nbttaglist = nbttagcompound.n("Items");
        this.itemStacks = new kp[this.c()];
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ph nbttagcompound1 = (ph)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.itemStacks.length) continue;
            this.itemStacks[byte0] = kp.a((ph)nbttagcompound1);
        }
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("EngineFuelItem", this.fuelItemId);
        nbttagcompound.a("EngineBurnTime", this.burnTime);
        nbttagcompound.a("EngineTotalTime", this.totalBurnTime);
        nbttagcompound.a("AshProduction", this.ashProduction);
        tx nbttaglist = new tx();
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null) continue;
            ph nbttagcompound1 = new ph();
            nbttagcompound1.a("Slot", (byte)i);
            this.itemStacks[i].b(nbttagcompound1);
            nbttaglist.a((jz)nbttagcompound1);
        }
        nbttagcompound.a("Items", (jz)nbttaglist);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.burnTime = j;
                break;
            }
            case 1: {
                this.totalBurnTime = j;
                break;
            }
            case 2: {
                this.currentOutput = j;
                break;
            }
            case 3: {
                this.storedEnergy = j;
                break;
            }
            case 4: {
                this.heat = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ew containerEngine, ff iCrafting) {
        iCrafting.a(containerEngine, 0, this.burnTime);
        iCrafting.a(containerEngine, 1, this.totalBurnTime);
        iCrafting.a(containerEngine, 2, this.currentOutput);
        iCrafting.a(containerEngine, 3, this.storedEnergy);
        iCrafting.a(containerEngine, 4, this.heat);
    }

    @Override
    public int c() {
        return this.itemStacks.length;
    }

    @Override
    public kp g_(int i) {
        return this.itemStacks[i];
    }

    @Override
    public kp a(int i, int j) {
        if (this.itemStacks[i] == null) {
            return null;
        }
        if (this.itemStacks[i].a <= j) {
            kp removed = this.itemStacks[i];
            this.itemStacks[i] = null;
            return removed;
        }
        kp removed = this.itemStacks[i].a(j);
        if (this.itemStacks[i].a == 0) {
            this.itemStacks[i] = null;
        }
        return removed;
    }

    @Override
    public void a(int i, kp itemstack) {
        this.itemStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.tile.a()) {
            itemstack.a = this.tile.a();
        }
    }

    @Override
    public kp b(int slot) {
        if (this.itemStacks[slot] == null) {
            return null;
        }
        kp toReturn = this.itemStacks[slot];
        this.itemStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0 || side == 1) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 0 || side == 1) {
            return 4;
        }
        return 1;
    }

    @Override
    public boolean addItem(kp stack, boolean doAdd, Orientations from) {
        if (FuelManager.copperEngineFuel.containsKey(stack.c)) {
            int slot = 0;
            if (!StackUtils.canAddToStack(stack, this.itemStacks[slot])) {
                return false;
            }
            if (!StackUtils.freeSpaceInStack(this.itemStacks[slot], this.a())) {
                return false;
            }
            if (doAdd) {
                if (this.itemStacks[slot] == null) {
                    this.itemStacks[slot] = stack.j();
                    stack.a = 0;
                } else {
                    StackUtils.mergeStacks(stack, this.itemStacks[slot]);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public kp extractItem(boolean doRemove, Orientations from) {
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null || this.itemStacks[i].c != ForestryItem.ash.bP) continue;
            kp product = new kp(ForestryItem.ash);
            if (doRemove) {
                this.a(i, 1);
            }
            return product;
        }
        return null;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowFuel25);
        return res;
    }

    public static class Factory
    extends EngineFactory {
        @Override
        public Engine createEngine(qj tile) {
            return new EngineCopper((TileEngine)tile);
        }
    }
}

