/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import buildcraft.api.EntityPassiveItem;
import buildcraft.api.IPipeEntry;
import buildcraft.api.IPowerReceptor;
import buildcraft.api.Orientations;
import buildcraft.api.Position;
import forestry.core.utils.Vect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;

public class BlockUtil {
    public static ArrayList getBlockItemStack(ge world, Vect posBlock) {
        vz block = vz.m[world.a(posBlock.x, posBlock.y, posBlock.z)];
        if (block == null) {
            return null;
        }
        int meta = world.c(posBlock.x, posBlock.y, posBlock.z);
        return block.getBlockDropped(world, posBlock.x, posBlock.y, posBlock.z, meta, 0);
    }

    public static ni[] getAdjacentInventories(ge world, Vect blockPos) {
        ArrayList<ni> inventories = new ArrayList<ni>();
        qj entity = world.b(blockPos.x - 1, blockPos.y, blockPos.z);
        if (entity != null && entity instanceof ni && !(entity instanceof IPowerReceptor)) {
            inventories.add((ni)entity);
        }
        if ((entity = world.b(blockPos.x + 1, blockPos.y, blockPos.z)) != null && entity instanceof ni && !(entity instanceof IPowerReceptor)) {
            inventories.add((ni)entity);
        }
        if ((entity = world.b(blockPos.x, blockPos.y, blockPos.z - 1)) != null && entity instanceof ni && !(entity instanceof IPowerReceptor)) {
            inventories.add((ni)entity);
        }
        if ((entity = world.b(blockPos.x, blockPos.y, blockPos.z + 1)) != null && entity instanceof ni && !(entity instanceof IPowerReceptor)) {
            inventories.add((ni)entity);
        }
        return inventories.toArray(new ni[inventories.size()]);
    }

    public static Orientations[] getPipeDirections(ge world, Vect blockPos, Orientations from) {
        new ArrayList();
        LinkedList<Orientations> possiblePipes = new LinkedList<Orientations>();
        for (int j = 0; j < 6; ++j) {
            Position posPipe = new Position(blockPos.x, blockPos.y, blockPos.z, Orientations.values()[j]);
            posPipe.moveForwards(1.0);
            qj pipeEntry = world.b((int)posPipe.x, (int)posPipe.y, (int)posPipe.z);
            if (!(pipeEntry instanceof IPipeEntry) || !((IPipeEntry)pipeEntry).acceptItems()) continue;
            possiblePipes.add(Orientations.values()[j]);
        }
        return possiblePipes.toArray(new Orientations[possiblePipes.size()]);
    }

    public static Orientations[] filterPipeDirections(Orientations[] all, Orientations[] exclude) {
        LinkedList<Orientations> filtered = new LinkedList<Orientations>();
        ArrayList<Orientations> excludeList = new ArrayList<Orientations>(Arrays.asList(exclude));
        for (int i = 0; i < all.length; ++i) {
            if (excludeList.contains((Object)all[i])) continue;
            filtered.add(all[i]);
        }
        return filtered.toArray(new Orientations[filtered.size()]);
    }

    public static void putFromStackIntoPipe(qj tile, Orientations[] pipes, kp stack) {
        if (stack == null) {
            return;
        }
        if (stack.a <= 0) {
            return;
        }
        if (pipes.length <= 0) {
            return;
        }
        int choice = tile.k.r.nextInt(pipes.length);
        Position itemPos = new Position(tile.l, tile.m, tile.n, pipes[choice]);
        itemPos.x += 0.5;
        itemPos.y += 0.25;
        itemPos.z += 0.5;
        itemPos.moveForwards(0.5);
        Position pipePos = new Position(tile.l, tile.m, tile.n, pipes[choice]);
        pipePos.moveForwards(1.0);
        IPipeEntry pipe = (IPipeEntry)tile.k.b((int)pipePos.x, (int)pipePos.y, (int)pipePos.z);
        kp payload = stack.a(1);
        EntityPassiveItem entity = new EntityPassiveItem(tile.k, itemPos.x, itemPos.y, itemPos.z, payload);
        pipe.entityEntering(entity, itemPos.orientation);
    }
}

