/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.triggers;

import buildcraft.api.TriggerParameter;
import forestry.core.gadgets.TileEngine;
import forestry.core.gadgets.TileMachine;
import forestry.core.triggers.Trigger;
import forestry.core.utils.StringUtil;

public class TriggerLowFuel
extends Trigger {
    private float threshold = 0.25f;

    public TriggerLowFuel(int id2, float threshold) {
        super(id2);
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("trigger.fuel") + " < " + this.threshold * 100.0f + "%";
    }

    @Override
    public boolean isTriggerActive(qj tile, TriggerParameter parameter) {
        if (tile instanceof TileMachine) {
            TileMachine machine = (TileMachine)tile;
            return !machine.machine.hasFuelMin(this.threshold);
        }
        if (tile instanceof TileEngine) {
            TileEngine engine = (TileEngine)tile;
            if (engine.engine != null) {
                return !engine.engine.hasFuelMin(this.threshold);
            }
            return false;
        }
        return false;
    }
}

