/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import buildcraft.api.Orientations;
import forestry.core.EnumErrorCode;
import forestry.core.gadgets.TileForestry;
import forestry.core.network.PacketUpdate;
import forestry.core.utils.EnumAccess;
import forge.NetworkMod;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PacketTileUpdate
extends PacketUpdate {
    private int posX;
    private int posY;
    private int posZ;
    private Orientations orientation = Orientations.XNeg;
    private EnumErrorCode errorState = EnumErrorCode.OK;
    private boolean isOwnable = false;
    private EnumAccess access = EnumAccess.SHARED;
    private String owner = null;

    public PacketTileUpdate() {
    }

    public PacketTileUpdate(TileForestry tile, NetworkMod mod) {
        super(0, tile.getPacketPayload());
        this.posX = tile.l;
        this.posY = tile.m;
        this.posZ = tile.n;
        this.orientation = tile.getOrientation();
        this.errorState = tile.getErrorState();
        this.isOwnable = tile.isOwnable();
        this.access = tile.getAccess();
        this.owner = tile.owner;
        if (this.owner == null || this.owner.isEmpty()) {
            this.owner = "";
        }
        this.isChunkDataPacket = true;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.posX);
        data.writeInt(this.posY);
        data.writeInt(this.posZ);
        data.writeInt(this.orientation.ordinal());
        data.writeInt(this.errorState.ordinal());
        if (this.isOwnable) {
            data.writeInt(this.access.ordinal());
            data.writeUTF(this.owner);
        } else {
            data.writeInt(-1);
        }
        super.writeData(data);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.posX = data.readInt();
        this.posY = data.readInt();
        this.posZ = data.readInt();
        this.orientation = Orientations.values()[data.readInt()];
        this.errorState = EnumErrorCode.values()[data.readInt()];
        int ordinal = data.readInt();
        boolean bl = this.isOwnable = ordinal >= 0;
        if (this.isOwnable) {
            this.access = EnumAccess.values()[ordinal];
            this.owner = data.readUTF();
        }
        super.readData(data);
    }

    public Orientations getOrientation() {
        return this.orientation;
    }

    public EnumErrorCode getErrorState() {
        return this.errorState;
    }

    public EnumAccess getAccess() {
        return this.access;
    }

    public String getOwner() {
        return this.owner;
    }

    public qj getTarget(ge world) {
        return world.b(this.posX, this.posY, this.posZ);
    }
}

