/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.api.liquids.LiquidStack;
import forestry.core.Proxy;
import forestry.core.unity.IItemDisplayNamed;
import forestry.core.utils.StringUtil;

public class ItemLiquidContainer
extends id
implements IItemDisplayNamed {
    private boolean isDrink = false;
    private boolean isAlwaysEdible = false;
    private int healAmount = 0;
    private float saturationModifier = 0.0f;

    public ItemLiquidContainer(int i, int iconIndex) {
        super(i);
        this.bR = iconIndex;
        this.setTextureFile("/gfx/forestry/items/liquids.png");
    }

    private int getMatchingSlot(ih player, kp stack) {
        for (int slot = 0; slot < player.k.c(); ++slot) {
            int space;
            kp slotStack = player.k.g_(slot);
            if (slotStack == null) {
                return slot;
            }
            if (!slotStack.a(stack) || (space = slotStack.b() - slotStack.a) < stack.a) continue;
            return slot;
        }
        return -1;
    }

    public kp b(kp itemstack, ge world, ih entityplayer) {
        if (!this.isDrink) {
            return itemstack;
        }
        --itemstack.a;
        entityplayer.af().a(this.getHealAmount(), this.getSaturationModifier());
        world.a((tv)entityplayer, "random.burp", 0.5f, world.r.nextFloat() * 0.1f + 0.9f);
        return itemstack;
    }

    public int c(kp itemstack) {
        if (this.isDrink) {
            return 32;
        }
        return super.c(itemstack);
    }

    public kt d(kp itemstack) {
        if (this.isDrink) {
            return kt.c;
        }
        return kt.a;
    }

    public kp a(kp itemstack, ge world, ih entityplayer) {
        if (Proxy.isMultiplayerWorld()) {
            return itemstack;
        }
        if (this.isDrink) {
            if (entityplayer.b(this.isAlwaysEdible)) {
                entityplayer.a(itemstack, this.c(itemstack));
            }
            return itemstack;
        }
        wu movingobjectposition = this.a(world, entityplayer, true);
        if (movingobjectposition != null && movingobjectposition.a == kw.a) {
            int targetedMeta;
            int i = movingobjectposition.b;
            int j = movingobjectposition.c;
            int k = movingobjectposition.d;
            int targetedId = world.a(i, j, k);
            LiquidContainer container = LiquidManager.getEmptyContainer(itemstack, new LiquidStack(targetedId, 1, targetedMeta = world.c(i, j, k)));
            if (container == null) {
                return itemstack;
            }
            int slot = this.getMatchingSlot(entityplayer, container.filled);
            if (slot < 0) {
                return itemstack;
            }
            if (entityplayer.k.g_(slot) == null) {
                entityplayer.k.a(slot, container.filled.j());
            } else {
                ++entityplayer.k.g_((int)slot).a;
            }
            world.b(i, j, k, 0, 0);
            --itemstack.a;
            return itemstack;
        }
        return itemstack;
    }

    public int getHealAmount() {
        return this.healAmount;
    }

    public float getSaturationModifier() {
        return this.saturationModifier;
    }

    public ItemLiquidContainer setDrink(int healAmount, float saturationModifier) {
        this.isDrink = true;
        this.healAmount = healAmount;
        this.saturationModifier = saturationModifier;
        return this;
    }

    public ItemLiquidContainer setAlwaysEdible() {
        this.isAlwaysEdible = true;
        return this;
    }

    @Override
    public String getItemDisplayName(kp itemstack) {
        return StringUtil.localize(this.a(itemstack));
    }
}

