/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ISolderManager;
import forestry.api.core.ForestryAPI;
import forestry.core.Proxy;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ISolderingIron;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.items.ItemForestry;
import forestry.core.network.GuiId;
import forestry.core.utils.ItemInventory;
import java.util.ArrayList;

public class ItemSolderingIron
extends ItemForestry
implements ISolderingIron {
    public ItemSolderingIron(int i) {
        super(i);
        this.bQ = 1;
        this.f(5);
    }

    public boolean isFull3D() {
        return true;
    }

    public kp a(kp itemstack, ge world, ih entityplayer) {
        if (!Proxy.isMultiplayerWorld()) {
            entityplayer.openGui((BaseMod)ForestryAPI.instance, GuiId.SolderingIronGUI.ordinal(), world, (int)entityplayer.bm, (int)entityplayer.bn, (int)entityplayer.bo);
        }
        return itemstack;
    }

    public static class SolderingInventory
    extends ItemInventory {
        short blankSlot = 0;
        short finishedSlot = 1;
        short ingredientSlot1 = (short)2;

        public SolderingInventory() {
            super(6);
        }

        public SolderingInventory(kp itemstack) {
            super(6, itemstack);
        }

        public void trySolder() {
            if (this.inventoryStacks[this.blankSlot] == null) {
                return;
            }
            if (this.inventoryStacks[this.finishedSlot] != null) {
                return;
            }
            kp blank = this.inventoryStacks[this.blankSlot];
            if (!ItemCircuitBoard.isChipset(blank)) {
                return;
            }
            if (blank.h() < 0 || blank.h() >= EnumCircuitBoardType.values().length) {
                return;
            }
            EnumCircuitBoardType type = EnumCircuitBoardType.values()[blank.h()];
            ArrayList<ICircuit> circuits = new ArrayList<ICircuit>();
            for (short i = 0; i < type.sockets; i = (short)(i + 1)) {
                CircuitRecipe recipe;
                kp ingredient = this.inventoryStacks[this.ingredientSlot1 + i];
                if (ingredient == null || (recipe = SolderManager.getMatchingRecipe(ingredient)) == null || this.getCount(recipe.circuit, circuits) >= recipe.circuit.getLimit()) continue;
                this.a(this.ingredientSlot1 + i, recipe.resource.a);
                circuits.add(recipe.circuit);
            }
            if (circuits.size() <= 0) {
                return;
            }
            this.inventoryStacks[this.finishedSlot] = ItemCircuitBoard.createCircuitboard(type, circuits.toArray(new ICircuit[0]));
            this.inventoryStacks[this.blankSlot] = null;
        }

        public int getCount(ICircuit circuit, ArrayList circuits) {
            int count = 0;
            for (ICircuit other : circuits) {
                if (other.getId() != circuit.getId()) continue;
                ++count;
            }
            return count;
        }

        @Override
        public void a(ph nbttagcompound) {
        }

        @Override
        public void b(ph nbttagcompound) {
        }

        @Override
        public void G_() {
            this.trySolder();
        }
    }

    public static class SolderManager
    implements ISolderManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(kp resource, ICircuit circuit) {
            recipes.add(new CircuitRecipe(resource, circuit));
        }

        public static CircuitRecipe getMatchingRecipe(kp resource) {
            if (resource == null) {
                return null;
            }
            for (CircuitRecipe recipe : recipes) {
                if (!recipe.matches(resource)) continue;
                return recipe;
            }
            return null;
        }
    }

    public static class CircuitRecipe {
        kp resource;
        ICircuit circuit;

        public CircuitRecipe(kp resource, ICircuit circuit) {
            this.resource = resource;
            this.circuit = circuit;
        }

        public boolean matches(kp itemstack) {
            return itemstack.a(this.resource);
        }
    }
}

