/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.core.circuits.CircuitBoard;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.config.ForestryItem;
import forestry.core.items.ItemForestry;
import forestry.core.unity.IItemColourOverlayed;
import forestry.core.unity.IItemNBTSynched;
import forestry.core.unity.IItemTooltipped;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class ItemCircuitBoard
extends ItemForestry
implements IItemTooltipped,
IItemNBTSynched,
IItemColourOverlayed {
    public ItemCircuitBoard(int i) {
        super(i);
        this.e(1);
    }

    public void addCreativeItems(ArrayList itemList) {
        itemList.add(ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.BASIC, new ICircuit[0]));
        itemList.add(ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.ENHANCED, new ICircuit[0]));
        itemList.add(ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.REFINED, new ICircuit[0]));
    }

    public boolean i() {
        return true;
    }

    @Override
    public boolean func_46056_k() {
        return true;
    }

    @Override
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @Override
    public int getColorFromDamage(int i, int j) {
        EnumCircuitBoardType type = EnumCircuitBoardType.values()[i];
        if (j == 0) {
            return type.primaryColor;
        }
        return type.secondaryColor;
    }

    @Override
    public int getIconFromDamageForRenderPass(int i, int j) {
        if (j > 0) {
            return 22;
        }
        return 23;
    }

    @Override
    public String getItemDisplayName(kp itemstack) {
        EnumCircuitBoardType type = EnumCircuitBoardType.values()[itemstack.h()];
        return StringUtil.localize("item.circuitboard." + type.toString().toLowerCase());
    }

    @Override
    public void addInformation(kp itemstack, List list) {
        ICircuitBoard circuitboard = ItemCircuitBoard.getCircuitboard(itemstack);
        if (circuitboard != null) {
            circuitboard.addTooltip(list);
        }
    }

    public static boolean isChipset(kp itemstack) {
        if (itemstack == null) {
            return false;
        }
        return itemstack.c == ForestryItem.circuitboards.bP;
    }

    public static kp createCircuitboard(EnumCircuitBoardType type, ICircuit[] circuits) {
        kp chipset = new kp(ForestryItem.circuitboards, 1, type.ordinal());
        ItemCircuitBoard.saveChipset(chipset, new CircuitBoard(type, circuits));
        return chipset;
    }

    public static void saveChipset(kp itemstack, ICircuitBoard circuitboard) {
        if (circuitboard == null) {
            itemstack.d(null);
            return;
        }
        ph nbttagcompound = new ph();
        circuitboard.b(nbttagcompound);
        itemstack.d(nbttagcompound);
    }

    public static ICircuitBoard getCircuitboard(kp itemstack) {
        ph nbttagcompound = itemstack.o();
        if (nbttagcompound == null) {
            return null;
        }
        return new CircuitBoard(nbttagcompound);
    }
}

