/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleGrowth;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IGrowthProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosome;
import forestry.arboriculture.genetics.TreeTemplates;
import forestry.core.genetics.AlleleFloat;
import forestry.core.genetics.AlleleInteger;
import forestry.core.genetics.AlleleTolerance;
import forestry.core.genetics.Genome;

public class TreeGenome
extends Genome
implements ITreeGenome {
    public TreeGenome(IChromosome[] chromosomes) {
        super(TreeTemplates.getOakTemplate(), chromosomes);
    }

    public TreeGenome(ph nbttagcompound) {
        super(TreeTemplates.getOakTemplate(), nbttagcompound);
    }

    @Override
    public IAlleleSpecies getPrimary() {
        return (IAlleleSpecies)this.getActiveAllele(EnumTreeChromosome.SPECIES.ordinal());
    }

    @Override
    public IAlleleSpecies getSecondary() {
        return (IAlleleSpecies)this.getInactiveAllele(EnumTreeChromosome.SPECIES.ordinal());
    }

    @Override
    public IAlleleTreeSpecies getPrimaryAsTree() {
        return (IAlleleTreeSpecies)this.getActiveAllele(EnumTreeChromosome.SPECIES.ordinal());
    }

    @Override
    public IAlleleTreeSpecies getSecondaryAsTree() {
        return (IAlleleTreeSpecies)this.getInactiveAllele(EnumTreeChromosome.SPECIES.ordinal());
    }

    @Override
    public IGrowthProvider getGrowthProvider() {
        return ((IAlleleGrowth)this.getActiveAllele(EnumTreeChromosome.GROWTH.ordinal())).getProvider();
    }

    @Override
    public int getHeight() {
        return ((AlleleInteger)this.getActiveAllele(EnumTreeChromosome.HEIGHT.ordinal())).getValue();
    }

    @Override
    public float getFertility() {
        return ((AlleleFloat)this.getActiveAllele(EnumTreeChromosome.SAPLINGS.ordinal())).getValue();
    }

    @Override
    public float getYield() {
        return ((AlleleFloat)this.getActiveAllele(EnumTreeChromosome.YIELD.ordinal())).getValue();
    }

    @Override
    public EnumTolerance getToleranceTemp() {
        return ((AlleleTolerance)this.getActiveAllele(EnumTreeChromosome.TEMPERATURE_TOLERANCE.ordinal())).getValue();
    }

    @Override
    public EnumTolerance getToleranceHumid() {
        return ((AlleleTolerance)this.getActiveAllele(EnumTreeChromosome.HUMIDITY_TOLERANCE.ordinal())).getValue();
    }
}

