/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.ProxyApiculture;
import forestry.core.genetics.Allele;
import forestry.core.genetics.EffectData;

public abstract class AlleleEffectThrottled
extends Allele
implements IAlleleBeeEffect {
    public AlleleEffectThrottled(int id2, boolean isDominant) {
        super(id2, isDominant);
    }

    public abstract int getThrottle();

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData instanceof EffectData) {
            return storedData;
        }
        return new EffectData(1, 0);
    }

    public boolean isThrottled(IEffectData storedData) {
        int throttle = storedData.getInteger(0);
        storedData.setInteger(0, ++throttle);
        if (throttle < this.getThrottle()) {
            return true;
        }
        storedData.setInteger(0, 0);
        return false;
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, ge world, int biomeid, int x, int y, int z) {
        ProxyApiculture.addBeeHiveFX("/gfx/forestry/particles/swarm_bee.png", world, x, y, z, genome.getPrimaryAsBee().getPrimaryColor());
        return storedData;
    }
}

