/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.core.ForestryAPI;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.GuiId;
import forestry.core.utils.Orientations;
import forestry.core.utils.StringUtil;

public class MachineApiaristChest
extends Machine {
    private kp[] inventoryStacks = new kp[125];

    public MachineApiaristChest(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("apiarist.chest"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.mill.3");
    }

    @Override
    public void openGui(ih player, ni tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.ApiaristChestGUI.ordinal(), player.bi, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        tx nbttaglist = new tx();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            ph nbttagcompound1 = new ph();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((jz)nbttagcompound1);
        }
        nbttagcompound.a("Items", (jz)nbttaglist);
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        tx nbttaglist = nbttagcompound.n("Items");
        this.inventoryStacks = new kp[this.c()];
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ph nbttagcompound1 = (ph)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = kp.a((ph)nbttagcompound1);
        }
    }

    @Override
    public void updateServerSide() {
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return false;
    }

    @Override
    public boolean throwsErrors() {
        return false;
    }

    @Override
    public boolean addItem(kp stack, boolean doAdd, Orientations from) {
        if (!BeeManager.beeInterface.isBee(stack)) {
            return false;
        }
        int freeSlots = 0;
        int slot = -1;
        for (int i = 0; i < this.c(); ++i) {
            int space;
            if (this.g_(i) == null) {
                ++freeSlots;
                if (slot >= 0) continue;
                slot = i;
                continue;
            }
            if (!this.g_(i).a(stack) || (space = this.g_(i).b() - this.g_((int)i).a) <= 0) continue;
            if (space < stack.a) {
                if (doAdd) {
                    this.g_((int)i).a = this.g_(i).b();
                    stack.a -= space;
                    continue;
                }
                return true;
            }
            if (doAdd) {
                this.g_((int)i).a += stack.a;
                stack.a = 0;
            }
            return true;
        }
        if (freeSlots <= 0) {
            return false;
        }
        if (doAdd) {
            this.a(slot, stack.j());
            stack.a = 0;
        }
        return true;
    }

    @Override
    public kp extractItem(boolean doRemove, Orientations from) {
        kp product = null;
        for (int i = 0; i < this.c(); ++i) {
            if (this.g_(i) == null) continue;
            product = this.g_(i).j();
            if (!doRemove) break;
            this.g_((int)i).a = 0;
            this.a(i, null);
            break;
        }
        return product;
    }

    @Override
    public int c() {
        return this.inventoryStacks.length;
    }

    @Override
    public kp g_(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public kp a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            kp product = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return product;
        }
        kp product = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return product;
    }

    @Override
    public void a(int i, kp itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.a()) {
            itemstack.a = this.a();
        }
    }

    @Override
    public kp b(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        kp toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(ew container, ff iCrafting) {
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(qj tile) {
            return new MachineApiaristChest((TileMachine)tile);
        }
    }
}

