/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.items.ItemForestry;
import forestry.core.network.GuiId;
import forestry.core.utils.ItemInventory;
import forestry.core.utils.Vect;
import java.util.ArrayList;

public class ItemHabitatLocator
extends ItemForestry {
    public ItemHabitatLocator(int id2) {
        super(id2);
        this.bQ = 1;
    }

    public kp a(kp itemstack, ge world, ih entityplayer) {
        if (!Proxy.isMultiplayerWorld()) {
            entityplayer.openGui((BaseMod)ForestryAPI.instance, GuiId.HabitatLocatorGUI.ordinal(), world, (int)entityplayer.bm, (int)entityplayer.bn, (int)entityplayer.bo);
        }
        return itemstack;
    }

    public void startBiomeSearch(ge world, ih player, ArrayList biomesToSearch) {
        ArrayList<Integer> excludedBiomes = new ArrayList<Integer>();
        excludedBiomes.add(lt.b.M);
        excludedBiomes.add(lt.l.M);
        excludedBiomes.add(lt.r.M);
        biomesToSearch.removeAll(excludedBiomes);
        lt biome = world.a((int)player.bm, (int)player.bo);
        if (biomesToSearch.contains(biome.M)) {
            Proxy.setBiomeFinderCoordinates(player, new cf((int)player.bm, (int)player.bn, (int)player.bo));
            return;
        }
        if (!Proxy.isMultiplayerWorld() && biomesToSearch.size() > 0) {
            cf target = this.findNearestBiome(player, biomesToSearch);
            Proxy.setBiomeFinderCoordinates(player, target);
        }
    }

    private cf findNearestBiome(ih player, ArrayList biomesToSearch) {
        int loadChunkDistance = 25;
        cf coordinates = null;
        Vect pos = new Vect((int)player.bm, (int)player.bn, (int)player.bo);
        for (int i = 0; i < 100; ++i) {
            coordinates = this.getChunkCoordinates(pos.add(new Vect(10 * i, 0, 0)), player.bi, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(10 * i, 0, 10 * i)), player.bi, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(10 * i, 0, -10 * i)), player.bi, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(-10 * i, 0, 0)), player.bi, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(-10 * i, 0, 10 * i)), player.bi, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(-10 * i, 0, -10 * i)), player.bi, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(0, 0, 10 * i)), player.bi, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(0, 0, -10 * i)), player.bi, biomesToSearch, i < loadChunkDistance);
            if (coordinates == null) continue;
            return coordinates;
        }
        return coordinates;
    }

    private cf getChunkCoordinates(Vect pos, ge world, ArrayList biomesToSearch, boolean loadChunks) {
        if (Proxy.isClient() && !world.a(pos.x, pos.y, pos.z, pos.x, pos.y + 1, pos.z)) {
            if (loadChunks) {
                world.q().b(pos.x, pos.z);
            } else {
                return null;
            }
        }
        lt biome = world.a(pos.x, pos.z);
        if (biomesToSearch.contains(biome.M)) {
            return new cf(pos.x, pos.y, pos.z);
        }
        return null;
    }

    public static class HabitatLocatorInventory
    extends ItemInventory
    implements IErrorSource,
    IHintSource {
        public ArrayList biomesToSearch = new ArrayList();
        private short energySlot = (short)2;
        private short specimenSlot = 0;
        private short analyzeSlot = 1;

        public HabitatLocatorInventory() {
            super(3);
        }

        public HabitatLocatorInventory(kp itemstack) {
            super(3, itemstack);
        }

        @Override
        public void b(ph nbttagcompound) {
            tx nbttaglist = new tx();
            for (int i = 2; i < this.inventoryStacks.length; ++i) {
                if (this.inventoryStacks[i] == null) continue;
                ph nbttagcompound1 = new ph();
                nbttagcompound1.a("Slot", (byte)i);
                this.inventoryStacks[i].b(nbttagcompound1);
                nbttaglist.a((jz)nbttagcompound1);
            }
            nbttagcompound.a("Items", (jz)nbttaglist);
        }

        private boolean isEnergy(kp itemstack) {
            if (itemstack == null || itemstack.a <= 0) {
                return false;
            }
            return itemstack.c == ForestryItem.honeyDrop.bP || itemstack.c == ForestryItem.honeydew.bP;
        }

        private void tryAnalyze() {
            if (this.inventoryStacks[this.analyzeSlot] != null) {
                return;
            }
            if (this.g_(this.specimenSlot) == null) {
                return;
            }
            IBee bee = BeeManager.beeInterface.getBee(this.g_(this.specimenSlot));
            if (bee == null) {
                return;
            }
            if (!this.isEnergy(this.g_(this.energySlot))) {
                return;
            }
            this.biomesToSearch = bee.getSuitableBiomeIds();
            this.a((int)this.energySlot, 1);
            this.a((int)this.analyzeSlot, this.g_(this.specimenSlot));
            this.a((int)this.specimenSlot, null);
        }

        @Override
        public void G_() {
            this.tryAnalyze();
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("habitatlocator") != null && ((String[])Config.hints.get("habitatlocator")).length > 0;
        }

        @Override
        public String[] getHints() {
            return (String[])Config.hints.get("habitatlocator");
        }

        @Override
        public boolean throwsErrors() {
            return true;
        }

        @Override
        public EnumErrorCode getErrorState() {
            if (BeeManager.beeInterface.isBee(this.inventoryStacks[this.specimenSlot]) && !this.isEnergy(this.g_(this.energySlot))) {
                return EnumErrorCode.NOHONEY;
            }
            return EnumErrorCode.OK;
        }
    }
}

