/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.liquids;

public class LiquidStack {
    public int itemID;
    public int liquidAmount;
    public int itemMeta;
    public ph stackTagCompound;

    private LiquidStack() {
    }

    public LiquidStack(int itemID, int liquidAmount) {
        this(itemID, liquidAmount, 0);
    }

    public LiquidStack(id item, int liquidAmount) {
        this(item.bP, liquidAmount, 0);
    }

    public LiquidStack(vz block, int liquidAmount) {
        this(block.bO, liquidAmount, 0);
    }

    public LiquidStack(int itemID, int liquidAmount, int itemDamage) {
        this.itemID = itemID;
        this.liquidAmount = liquidAmount;
        this.itemMeta = itemDamage;
    }

    public ph writeToNBT(ph nbttagcompound) {
        nbttagcompound.a("Id", (short)this.itemID);
        nbttagcompound.a("Amount", this.liquidAmount);
        nbttagcompound.a("Meta", (short)this.itemMeta);
        if (this.stackTagCompound != null) {
            nbttagcompound.a("Tag", (jz)this.stackTagCompound);
        }
        return nbttagcompound;
    }

    public void readFromNBT(ph nbttagcompound) {
        this.itemID = nbttagcompound.e("Id");
        this.liquidAmount = nbttagcompound.f("Amount");
        this.itemMeta = nbttagcompound.e("Meta");
        if (nbttagcompound.c("Tag")) {
            this.stackTagCompound = nbttagcompound.m("tag");
        }
    }

    public LiquidStack copy() {
        LiquidStack copy = new LiquidStack(this.itemID, this.liquidAmount, this.itemMeta);
        if (this.stackTagCompound != null) {
            copy.stackTagCompound = (ph)this.stackTagCompound.b();
            if (!copy.stackTagCompound.equals((Object)this.stackTagCompound)) {
                return copy;
            }
        }
        return copy;
    }

    public ph getTagCompound() {
        return this.stackTagCompound;
    }

    public void setTagCompound(ph nbttagcompound) {
        this.stackTagCompound = nbttagcompound;
    }

    public boolean isLiquidEqual(LiquidStack other) {
        return this.itemID == other.itemID && this.itemMeta == other.itemMeta;
    }

    public boolean isLiquidEqual(kp other) {
        return this.itemID == other.c && this.itemMeta == other.h();
    }

    public kp asItemStack() {
        return new kp(this.itemID, 1, this.itemMeta);
    }

    public static LiquidStack loadLiquidStackFromNBT(ph nbttagcompound) {
        LiquidStack liquidstack = new LiquidStack();
        liquidstack.readFromNBT(nbttagcompound);
        return liquidstack.itemID == 0 ? null : liquidstack;
    }
}

