/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import forestry.api.core.ForestryAPI;
import forestry.apiculture.MachineApiaristChest;
import forestry.core.Proxy;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.TileMachine;
import forestry.core.interfaces.IInventoriedItem;
import forestry.core.items.ItemForestry;
import forestry.core.network.GuiId;
import forestry.core.unity.IItemColourOverlayed;
import forestry.core.unity.IItemNBTSynched;
import forestry.core.unity.IItemTooltipped;
import forestry.core.utils.ItemInventory;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Utils;
import forestry.storage.BackpackMode;
import java.util.ArrayList;
import java.util.List;

public abstract class ItemBackpack
extends ItemForestry
implements IInventoriedItem,
IItemTooltipped,
IItemNBTSynched,
IItemColourOverlayed {
    BackpackInfo info;

    public ItemBackpack(int i, BackpackInfo info) {
        super(i);
        this.info = info;
        this.bQ = 1;
    }

    public boolean i() {
        return true;
    }

    @Override
    public boolean func_46056_k() {
        return true;
    }

    public kp a(kp itemstack, ge world, ih entityplayer) {
        if (Proxy.isMultiplayerWorld()) {
            return itemstack;
        }
        if (entityplayer.aY()) {
            BackpackMode mode = this.getMode(itemstack);
            if (mode == BackpackMode.RESUPPLY) {
                itemstack.b(0);
            } else if (mode == BackpackMode.RECEIVE) {
                itemstack.b(3);
            } else if (mode == BackpackMode.LOCKED) {
                itemstack.b(2);
            } else {
                itemstack.b(1);
            }
        } else {
            this.openGui(entityplayer, itemstack);
        }
        return itemstack;
    }

    protected wu getPlayerTarget(ge world, ih entityplayer, boolean flag) {
        float f = 1.0f;
        float f1 = entityplayer.bv + (entityplayer.bt - entityplayer.bv) * f;
        float f2 = entityplayer.bu + (entityplayer.bs - entityplayer.bu) * f;
        double d = entityplayer.bj + (entityplayer.bm - entityplayer.bj) * (double)f;
        double d1 = entityplayer.bk + (entityplayer.bn - entityplayer.bk) * (double)f + 1.62 - (double)entityplayer.bF;
        double d2 = entityplayer.bl + (entityplayer.bo - entityplayer.bl) * (double)f;
        cj vec3d = cj.b((double)d, (double)d1, (double)d2);
        float f3 = kb.b((float)(-f2 * 0.01745329f - 3.141593f));
        float f4 = kb.a((float)(-f2 * 0.01745329f - 3.141593f));
        float f5 = -kb.b((float)(-f1 * 0.01745329f));
        float f6 = kb.a((float)(-f1 * 0.01745329f));
        float f7 = f4 * f5;
        float f8 = f6;
        float f9 = f3 * f5;
        double d3 = Proxy.getBlockReachDistance(entityplayer);
        cj vec3d1 = vec3d.c((double)f7 * d3, (double)f8 * d3, (double)f9 * d3);
        wu movingobjectposition = world.a(vec3d, vec3d1, flag, !flag);
        return movingobjectposition;
    }

    public boolean onItemUseFirst(kp stack, ih player, ge world, int X, int Y, int Z, int side) {
        if (Proxy.isMultiplayerWorld()) {
            return false;
        }
        if (!player.aY()) {
            return false;
        }
        wu movingobjectposition = this.getPlayerTarget(world, player, false);
        if (movingobjectposition != null && movingobjectposition.a == kw.a) {
            ni test;
            int i = movingobjectposition.b;
            int j = movingobjectposition.c;
            int k = movingobjectposition.d;
            qj targeted = world.b(i, j, k);
            ni inventory = null;
            if (targeted instanceof lh) {
                inventory = Utils.getChest((ni)targeted);
            } else if (targeted instanceof TileMachine) {
                TileMachine machine = (TileMachine)targeted;
                if (machine.machine instanceof MachineApiaristChest && ((ItemBackpack)ForestryItem.apiaristBackpack).isBackpack(stack)) {
                    inventory = (ni)targeted;
                }
            } else if (targeted instanceof ni && (test = (ni)targeted).c() > 26) {
                inventory = test;
            }
            if (inventory != null) {
                if (inventory.c() <= 0) {
                    return false;
                }
                ItemInventory backpackInventory = new ItemInventory(this.getBackpackSize(), stack);
                if (stack.h() == 2) {
                    this.tryChestReceive(backpackInventory, inventory);
                } else {
                    this.tryChestTransfer(backpackInventory, inventory);
                }
                backpackInventory.save();
                return true;
            }
        }
        return false;
    }

    private void tryChestTransfer(ItemInventory backpackInventory, ni inventory) {
        block0: for (int l = 0; l < backpackInventory.c(); ++l) {
            kp packstack = backpackInventory.g_(l);
            if (packstack == null) continue;
            for (int m = 0; m < inventory.c(); ++m) {
                int space;
                kp targetstack = inventory.g_(m);
                if (targetstack == null) {
                    inventory.a(m, packstack.j());
                    backpackInventory.a(l, null);
                    continue block0;
                }
                if (!targetstack.a(packstack) || (space = targetstack.b() - targetstack.a) <= 0) continue;
                if (space >= packstack.a) {
                    targetstack.a += packstack.a;
                    backpackInventory.a(l, packstack.a);
                    continue block0;
                }
                targetstack.a = targetstack.b();
                backpackInventory.a(l, space);
            }
        }
    }

    private void tryChestReceive(ItemInventory backpackInventory, ni inventory) {
        block0: for (int i = 0; i < inventory.c(); ++i) {
            kp inventoryStack = inventory.g_(i);
            if (inventoryStack == null || !this.isValidItem(inventoryStack)) continue;
            for (int j = 0; j < backpackInventory.c(); ++j) {
                int space;
                kp backpackStack = backpackInventory.g_(j);
                if (backpackStack == null) {
                    backpackInventory.a(j, inventoryStack.j());
                    inventory.a(i, null);
                    continue block0;
                }
                if (!backpackStack.a(inventoryStack) || (space = backpackStack.b() - backpackStack.a) <= 0) continue;
                if (space >= inventoryStack.a) {
                    backpackStack.a += inventoryStack.a;
                    inventory.a(i, inventoryStack.a);
                    continue block0;
                }
                backpackStack.a = backpackStack.b();
                inventory.a(i, space);
            }
        }
    }

    public void openGui(ih entityplayer, kp itemstack) {
        if (this.getBackpackSize() == 15) {
            entityplayer.openGui((BaseMod)ForestryAPI.instance, GuiId.BackpackGUI.ordinal(), entityplayer.bi, (int)entityplayer.bm, (int)entityplayer.bn, (int)entityplayer.bo);
        } else if (this.getBackpackSize() == 45) {
            entityplayer.openGui((BaseMod)ForestryAPI.instance, GuiId.BackpackT2GUI.ordinal(), entityplayer.bi, (int)entityplayer.bm, (int)entityplayer.bn, (int)entityplayer.bo);
        }
    }

    public abstract boolean isBackpack(kp var1);

    public abstract ArrayList getValidItems();

    public boolean isValidItem(kp itemstack) {
        for (kp stack : this.getValidItems()) {
            if (!(stack.h() < 0 ? stack.c == itemstack.c : stack.a(itemstack))) continue;
            return true;
        }
        return false;
    }

    public int getBackpackSize() {
        return this.info.slots;
    }

    public BackpackMode getMode(kp backpack) {
        int meta = backpack.h();
        if (meta >= 3) {
            return BackpackMode.RESUPPLY;
        }
        if (meta >= 2) {
            return BackpackMode.RECEIVE;
        }
        if (meta >= 1) {
            return BackpackMode.LOCKED;
        }
        return BackpackMode.NORMAL;
    }

    @Override
    public void addInformation(kp itemstack, List list) {
        ItemInventory inventory = new ItemInventory(this.getBackpackSize(), itemstack);
        int occupied = 0;
        for (int i = 0; i < inventory.c(); ++i) {
            if (inventory.g_(i) == null || inventory.g_((int)i).a <= 0) continue;
            ++occupied;
        }
        BackpackMode mode = this.getMode(itemstack);
        if (mode == BackpackMode.LOCKED) {
            list.add("(LOCKED)");
        } else if (mode == BackpackMode.RECEIVE) {
            list.add("(RECEIVING)");
        } else if (mode == BackpackMode.RESUPPLY) {
            list.add("(RESUPPLY)");
        }
        list.add(occupied + "/" + this.getBackpackSize() + " " + StringUtil.localize("gui.slots"));
    }

    public kp[] getBackpacksInInventory(ih player) {
        ArrayList<kp> bags = new ArrayList<kp>();
        for (kp stack : player.k.a) {
            if (!this.isBackpack(stack)) continue;
            bags.add(stack);
        }
        return bags.toArray(new kp[0]);
    }

    public kp tryStowing(kp backpack, kp itemstack) {
        ItemInventory inventory = new ItemInventory(((ItemBackpack)backpack.a()).getBackpackSize(), backpack);
        if (backpack.h() == 1) {
            return itemstack;
        }
        int freeSlots = 0;
        int slot = -1;
        for (int i = 0; i < inventory.c(); ++i) {
            int space;
            kp slotStack = inventory.g_(i);
            if (slotStack == null) {
                ++freeSlots;
                if (slot >= 0) continue;
                slot = i;
                continue;
            }
            if (!slotStack.a(itemstack) || (space = slotStack.b() - slotStack.a) <= 0) continue;
            if (space < itemstack.a) {
                slotStack.a = slotStack.b();
                itemstack.a -= space;
                continue;
            }
            slotStack.a += itemstack.a;
            itemstack.a = 0;
            inventory.save();
            return null;
        }
        if (freeSlots <= 0) {
            inventory.save();
            return itemstack;
        }
        inventory.a(slot, itemstack.j());
        itemstack.a = 0;
        inventory.save();
        return null;
    }

    @Override
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @Override
    public String getItemDisplayName(kp itemstack) {
        if (this.info.iconType > 1) {
            return StringUtil.localize("storage.backpack.t2adj") + " " + StringUtil.localize("storage.backpack." + this.info.name);
        }
        return StringUtil.localize("storage.backpack." + this.info.name);
    }

    @Override
    public int getColorFromDamage(int i, int j) {
        if (j == 0) {
            return this.info.primaryColor;
        }
        return this.info.secondaryColor;
    }

    @Override
    public int getIconFromDamageForRenderPass(int i, int j) {
        int iconIndex = 0;
        iconIndex = j == 0 ? 112 : 113 + this.info.iconType;
        if (i > 2) {
            return iconIndex + 48;
        }
        if (i > 1) {
            return iconIndex + 32;
        }
        if (i > 0) {
            return iconIndex + 16;
        }
        return iconIndex;
    }

    public static int getSlotsForType(int type) {
        switch (type) {
            case 0: {
                return 125;
            }
            case 2: {
                return 45;
            }
        }
        return 15;
    }

    public static class BackpackInfo {
        public final String name;
        public final int slots;
        public final int iconType;
        public final int primaryColor;
        public final int secondaryColor;

        public BackpackInfo(String name, int slots, int iconType, int primaryColor) {
            this(name, slots, iconType, primaryColor, 0xFFFFFF);
        }

        public BackpackInfo(String name, int slots, int iconType, int primaryColor, int secondaryColor) {
            this.name = name;
            this.slots = slots;
            this.iconType = iconType;
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
        }
    }
}

