/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.core.ForestryBlock;
import forestry.api.core.IResupplyHandler;
import forestry.api.storage.BackpackManager;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.plugins.NativePlugin;
import forestry.storage.GuiHandlerStorage;
import forestry.storage.ItemApiaristBackpack;
import forestry.storage.ItemBackpack;
import forestry.storage.ItemBackpackAdventurer;
import forestry.storage.ItemBackpackBuilder;
import forestry.storage.ItemBackpackDigger;
import forestry.storage.ItemBackpackForester;
import forestry.storage.ItemBackpackHunter;
import forestry.storage.ItemBackpackMiner;
import forestry.storage.PickupHandlerStorage;
import forestry.storage.ResupplyHandler;
import forge.IGuiHandler;
import forge.IPickupHandler;
import java.util.ArrayList;

public class PluginForestryStorage
extends NativePlugin {
    private ArrayList minerItems;
    private ArrayList diggerItems;
    private ArrayList foresterItems;
    private ArrayList hunterItems;
    private ArrayList adventurerItems;
    private ArrayList builderItems;

    @Override
    public boolean isAvailable() {
        return !Config.disableStorage;
    }

    @Override
    public String getDescription() {
        return "Native Storage";
    }

    @Override
    public void preInit() {
        super.preInit();
        this.createBackpackArrays();
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return new PickupHandlerStorage();
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerStorage();
    }

    @Override
    public IResupplyHandler getResupplyHandler() {
        return new ResupplyHandler();
    }

    @Override
    protected void registerPackages() {
    }

    @Override
    protected void registerItems() {
        ForestryItem.apiaristBackpack = new ItemApiaristBackpack(Config.getOrCreateItemIdProperty("apiaristBag", 13048)).a("apiaristBag");
        ForestryItem.minerBackpack = new ItemBackpackMiner(Config.getOrCreateItemIdProperty("minerBag", 13049), 1).a("minerBag");
        ForestryItem.diggerBackpack = new ItemBackpackDigger(Config.getOrCreateItemIdProperty("diggerBag", 13050), 1).a("diggerBag");
        ForestryItem.foresterBackpack = new ItemBackpackForester(Config.getOrCreateItemIdProperty("foresterBag", 13051), 1).a("foresterBag");
        ForestryItem.hunterBackpack = new ItemBackpackHunter(Config.getOrCreateItemIdProperty("hunterBag", 13052), 1).a("hunterBag");
        ForestryItem.adventurerBackpack = new ItemBackpackAdventurer(Config.getOrCreateItemIdProperty("adventurerBackpack", 13096), 1).a("adventurerBackpack");
        ForestryItem.builderBackpack = new ItemBackpackBuilder(Config.getOrCreateItemIdProperty("builderBackpack", 13106), 1).a("builderBackpack");
        ForestryItem.minerBackpackT2 = new ItemBackpackMiner(Config.getOrCreateItemIdProperty("minerBagT2", 13088), 2).a("minerBagT2");
        ForestryItem.diggerBackpackT2 = new ItemBackpackDigger(Config.getOrCreateItemIdProperty("diggerBagT2", 13089), 2).a("diggerBagT2");
        ForestryItem.foresterBackpackT2 = new ItemBackpackForester(Config.getOrCreateItemIdProperty("foresterBagT2", 13090), 2).a("foresterBagT2");
        ForestryItem.hunterBackpackT2 = new ItemBackpackHunter(Config.getOrCreateItemIdProperty("hunterBagT2", 13091), 2).a("hunterBagT2");
        ForestryItem.adventurerBackpackT2 = new ItemBackpackAdventurer(Config.getOrCreateItemIdProperty("adventurerBackpackT2", 13097), 2).a("adventurerBackpackT2");
        ForestryItem.builderBackpackT2 = new ItemBackpackBuilder(Config.getOrCreateItemIdProperty("builderBackpackT2", 13107), 2).a("builderBackpackT2");
        PickupHandlerStorage.backpacks = new ItemBackpack[]{(ItemBackpack)ForestryItem.apiaristBackpack, (ItemBackpack)ForestryItem.minerBackpack, (ItemBackpack)ForestryItem.diggerBackpack, (ItemBackpack)ForestryItem.foresterBackpack, (ItemBackpack)ForestryItem.hunterBackpack, (ItemBackpack)ForestryItem.adventurerBackpack, (ItemBackpack)ForestryItem.builderBackpack};
    }

    @Override
    protected void registerBackpackItems() {
        this.minerItems.add(new kp(vz.ap));
        this.minerItems.add(new kp(vz.I));
        this.minerItems.add(new kp(id.l));
        this.minerItems.add(new kp(vz.aw));
        this.minerItems.add(new kp(id.m));
        this.minerItems.add(new kp(vz.G));
        this.minerItems.add(new kp(id.o));
        this.minerItems.add(new kp(vz.H));
        this.minerItems.add(new kp(id.n));
        this.minerItems.add(new kp(vz.N));
        this.minerItems.add(new kp(vz.aN));
        this.minerItems.add(new kp(id.aB));
        this.minerItems.add(new kp(id.aV, 1, 4));
        this.minerItems.add(new kp(id.aS));
        this.minerItems.add(ForestryItem.ingotCopper);
        this.minerItems.add(ForestryItem.ingotTin);
        this.minerItems.add(ForestryItem.ingotBronze);
        this.diggerItems.add(new kp(vz.v));
        this.diggerItems.add(new kp(vz.w));
        this.diggerItems.add(new kp(vz.E));
        this.diggerItems.add(new kp(vz.Q));
        this.diggerItems.add(new kp(vz.F));
        this.diggerItems.add(new kp(id.ao));
        this.diggerItems.add(new kp(vz.bb));
        this.diggerItems.add(new kp(id.aH));
        this.diggerItems.add(new kp(vz.bc));
        this.foresterItems.add(new kp(vz.y, 1, -1));
        this.foresterItems.add(new kp((vz)vz.ag));
        this.foresterItems.add(new kp((vz)vz.af));
        this.foresterItems.add(new kp(vz.J, 1, -1));
        this.foresterItems.add(new kp(id.R));
        this.foresterItems.add(new kp((vz)vz.ae));
        this.foresterItems.add(new kp((vz)vz.ad));
        this.foresterItems.add(new kp((vz)vz.K, 1, -1));
        this.foresterItems.add(new kp(vz.aV));
        this.foresterItems.add(new kp((vz)vz.X, 1, -1));
        this.foresterItems.add(new kp(vz.bu));
        this.foresterItems.add(new kp(id.i));
        this.foresterItems.add(new kp(id.as));
        this.foresterItems.add(new kp(id.bq));
        this.foresterItems.add(new kp(id.bf));
        this.foresterItems.add(new kp(id.bg));
        this.hunterItems.add(new kp(id.K));
        this.hunterItems.add(new kp(id.L));
        this.hunterItems.add(new kp(id.bv));
        this.hunterItems.add(new kp(id.bn));
        this.hunterItems.add(new kp(id.aW));
        this.hunterItems.add(new kp(id.J));
        this.hunterItems.add(new kp(id.bl));
        this.hunterItems.add(new kp(id.bo));
        this.hunterItems.add(new kp(id.bp));
        this.hunterItems.add(new kp(id.k));
        this.hunterItems.add(new kp(id.ap));
        this.hunterItems.add(new kp(id.aq));
        this.hunterItems.add(new kp(id.bh));
        this.hunterItems.add(new kp(id.bi));
        this.hunterItems.add(new kp(id.bj));
        this.hunterItems.add(new kp(id.bk));
        this.hunterItems.add(new kp(id.aE));
        this.hunterItems.add(new kp(id.aO));
        this.hunterItems.add(new kp(id.bm));
        this.hunterItems.add(new kp(id.bt));
        this.hunterItems.add(new kp(id.bu));
        this.hunterItems.add(new kp(id.aL));
        this.hunterItems.add(new kp(id.aV, 1, 0));
        this.hunterItems.add(new kp(vz.ab));
        this.hunterItems.add(new kp(vz.ab, 1, -1));
        this.hunterItems.add(new kp(id.bz));
        this.hunterItems.add(new kp(id.bw));
        this.hunterItems.add(new kp(id.bA));
        this.hunterItems.add(new kp(id.aT));
        this.hunterItems.add(new kp(id.aU));
        this.builderItems.add(new kp(vz.aq));
        this.builderItems.add(new kp(vz.bm, 1, -1));
        this.builderItems.add(new kp(vz.t));
        this.builderItems.add(new kp(vz.al));
        this.builderItems.add(new kp(vz.x, 1, -1));
        this.builderItems.add(new kp(vz.bA));
        this.builderItems.add(new kp(vz.bB));
        this.builderItems.add(new kp(vz.ak));
        this.builderItems.add(new kp(vz.aH));
        this.builderItems.add(new kp(vz.at));
        this.builderItems.add(new kp(vz.aj));
        this.builderItems.add(new kp(vz.bw));
        this.builderItems.add(new kp(vz.bC));
        this.builderItems.add(new kp(vz.bx));
        this.builderItems.add(new kp(vz.M));
        this.builderItems.add(new kp(vz.bq));
        this.builderItems.add(new kp(vz.aZ));
        this.builderItems.add(new kp(vz.bv));
        this.builderItems.add(new kp(vz.bp));
    }

    @Override
    protected void registerRecipes() {
        Proxy.addRecipe(new kp(ForestryItem.apiaristBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), vz.ab, Character.valueOf('X'), id.J, Character.valueOf('V'), id.C, Character.valueOf('Y'), new kp(ForestryBlock.mill, 1, 3)});
        Proxy.addRecipe(new kp(ForestryItem.minerBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), vz.ab, Character.valueOf('X'), id.J, Character.valueOf('V'), id.n, Character.valueOf('Y'), vz.au});
        Proxy.addRecipe(new kp(ForestryItem.diggerBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), vz.ab, Character.valueOf('X'), id.J, Character.valueOf('V'), vz.t, Character.valueOf('Y'), vz.au});
        Proxy.addRecipe(new kp(ForestryItem.foresterBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), vz.ab, Character.valueOf('X'), id.J, Character.valueOf('V'), vz.J, Character.valueOf('Y'), vz.au});
        Proxy.addRecipe(new kp(ForestryItem.hunterBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), vz.ab, Character.valueOf('X'), id.J, Character.valueOf('V'), id.K, Character.valueOf('Y'), vz.au});
        Proxy.addRecipe(new kp(ForestryItem.adventurerBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), vz.ab, Character.valueOf('X'), id.J, Character.valueOf('V'), id.aW, Character.valueOf('Y'), vz.au});
        Proxy.addRecipe(new kp(ForestryItem.builderBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), vz.ab, Character.valueOf('X'), id.J, Character.valueOf('V'), id.aH, Character.valueOf('Y'), vz.au});
    }

    private void createBackpackArrays() {
        BackpackManager.backpackItems = new ArrayList[6];
        this.minerItems = new ArrayList();
        BackpackManager.backpackItems[0] = this.minerItems;
        this.diggerItems = new ArrayList();
        BackpackManager.backpackItems[1] = this.diggerItems;
        this.foresterItems = new ArrayList();
        BackpackManager.backpackItems[2] = this.foresterItems;
        this.hunterItems = new ArrayList();
        BackpackManager.backpackItems[3] = this.hunterItems;
        this.adventurerItems = new ArrayList();
        BackpackManager.backpackItems[4] = this.adventurerItems;
        this.builderItems = new ArrayList();
        BackpackManager.backpackItems[5] = this.builderItems;
    }

    @Override
    protected void registerCrates() {
    }
}

