/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import buildcraft.api.BuildCraftAPI;
import buildcraft.api.IPipe;
import buildcraft.api.ITriggerProvider;
import buildcraft.api.IronEngineFuel;
import buildcraft.api.LiquidData;
import buildcraft.api.LiquidSlot;
import buildcraft.api.PowerProvider;
import buildcraft.api.RefineryRecipe;
import forestry.api.core.ForestryAPI;
import forestry.api.core.GlobalManager;
import forestry.api.core.IAchievementHandler;
import forestry.api.core.IPlugin;
import forestry.api.core.IResupplyHandler;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidStack;
import forestry.core.ForestryCore;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.TileForestry;
import forestry.core.utils.EnergyConfiguration;
import forestry.core.utils.Orientations;
import forestry.core.utils.TankSlot;
import forge.Configuration;
import forge.IGuiHandler;
import forge.IPacketHandler;
import forge.IPickupHandler;
import forge.Property;
import java.util.LinkedList;
import java.util.Random;

public class PluginBuildCraft
implements IPlugin,
ITriggerProvider {
    public static PluginBuildCraft instance;
    public static Configuration config;
    public static boolean ignore;
    public static int engineId;
    public static int pipeId;
    public static id wrench;
    public static id stoneGear;
    public static id pipeWaterproof;
    public static vz oilStill;
    public static vz oilMoving;
    public static id fuel;

    public PluginBuildCraft() {
        if (instance == null) {
            instance = this;
        }
    }

    @Override
    public boolean isAvailable() {
        return ModLoader.isModLoaded((String)"mod_BuildCraftCore") && ModLoader.isModLoaded((String)"mod_BuildCraftTransport") || ModLoader.isModLoaded((String)"net.minecraft.src.mod_BuildCraftCore") && ModLoader.isModLoaded((String)"net.minecraft.src.mod_BuildCraftTransport");
    }

    @Override
    public void doInit() {
        config = Config.config;
        Property buildcraftignore = config.getOrCreateBooleanProperty("buildcraft.ignore", "general", false);
        buildcraftignore.comment = "set to true to ignore buildcraft";
        ignore = Boolean.parseBoolean(buildcraftignore.value);
        Property buildcraftengine = config.getOrCreateIntProperty("buildcraft.blockid.engine", "general", 161);
        buildcraftengine.comment = "necessary to have the arboretum not clear buildcraft engines.";
        engineId = Integer.parseInt(buildcraftengine.value);
        Property buildcraftpipe = config.getOrCreateIntProperty("buildcraft.blockid.pipe", "general", 166);
        buildcraftpipe.comment = "necessary to have the arboretum not clear buildcraft pipes.";
        pipeId = Integer.parseInt(buildcraftpipe.value);
        GlobalManager.holyBlockIds.add(engineId);
        GlobalManager.holyBlockIds.add(pipeId);
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidBiomass.bP, ForestryItem.liquidBiomass.bP, new kp(ForestryItem.bucketBiomass)));
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidBiomass.bP, ForestryItem.liquidBiomass.bP, ForestryItem.canBiomass));
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidBiomass.bP, ForestryItem.liquidBiomass.bP, ForestryItem.waxCapsuleBiomass));
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidBiomass.bP, ForestryItem.liquidBiomass.bP, ForestryItem.refractoryBiomass));
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidBiofuel.bP, ForestryItem.liquidBiofuel.bP, new kp(ForestryItem.bucketBiofuel)));
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidBiofuel.bP, ForestryItem.liquidBiofuel.bP, ForestryItem.waxCapsuleBiofuel));
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidBiofuel.bP, ForestryItem.liquidBiofuel.bP, ForestryItem.canBiofuel));
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidBiofuel.bP, ForestryItem.liquidBiofuel.bP, ForestryItem.refractoryBiofuel));
        BuildCraftAPI.liquids.add(new LiquidData(vz.B.bO, vz.A.bO, ForestryItem.canWater));
        BuildCraftAPI.liquids.add(new LiquidData(vz.B.bO, vz.A.bO, ForestryItem.waxCapsuleWater));
        BuildCraftAPI.liquids.add(new LiquidData(vz.B.bO, vz.A.bO, ForestryItem.refractoryWater));
        BuildCraftAPI.liquids.add(new LiquidData(vz.D.bO, vz.C.bO, ForestryItem.canLava));
        BuildCraftAPI.liquids.add(new LiquidData(vz.D.bO, vz.C.bO, ForestryItem.refractoryLava));
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidSeedOil.bP, ForestryItem.liquidSeedOil.bP, new kp(ForestryItem.canSeedOil)));
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidSeedOil.bP, ForestryItem.liquidSeedOil.bP, new kp(ForestryItem.waxCapsuleSeedOil)));
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidSeedOil.bP, ForestryItem.liquidSeedOil.bP, new kp(ForestryItem.refractorySeedOil)));
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidHoney.bP, ForestryItem.liquidHoney.bP, new kp(ForestryItem.canHoney)));
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidHoney.bP, ForestryItem.liquidHoney.bP, new kp(ForestryItem.waxCapsuleHoney)));
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidHoney.bP, ForestryItem.liquidHoney.bP, new kp(ForestryItem.refractoryHoney)));
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidJuice.bP, ForestryItem.liquidJuice.bP, new kp(ForestryItem.canJuice)));
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidJuice.bP, ForestryItem.liquidJuice.bP, new kp(ForestryItem.waxCapsuleJuice)));
        BuildCraftAPI.liquids.add(new LiquidData(ForestryItem.liquidJuice.bP, ForestryItem.liquidJuice.bP, new kp(ForestryItem.refractoryJuice)));
        BuildCraftAPI.ironEngineFuel.put(ForestryItem.liquidBiofuel.bP, new IronEngineFuel(ForestryItem.liquidBiofuel.bP, 5, 40000));
        RefineryRecipe biofuel = new RefineryRecipe(ForestryItem.liquidBiomass.bP, 4, 0, 0, 10, ForestryItem.liquidBiofuel.bP, 1, 1);
        BuildCraftAPI.registerRefineryRecipe(biofuel);
        BuildCraftAPI.registerTriggerProvider(this);
        BuildCraftAPI.liquids.add(new LiquidData(vz.D.bO, vz.C.bO, new kp(ForestryItem.canLava)));
        this.initWrench();
        this.initStoneGear();
        this.initWaterproof();
        this.initLiquids();
    }

    @Override
    public void postInit() {
    }

    private void initLiquids() {
        try {
            oilStill = (vz)Class.forName("BuildCraftEnergy").getField("oilStill").get(null);
            oilMoving = (vz)Class.forName("BuildCraftEnergy").getField("oilMoving").get(null);
            fuel = (id)Class.forName("BuildCraftEnergy").getField("fuel").get(null);
        }
        catch (Exception ex) {
            ModLoader.getLogger().fine("Oil or fuel not found.");
            return;
        }
        ForestryCore.injectWaxContainer(new LiquidContainer(new LiquidStack(oilStill, 1000), new kp(ForestryItem.waxCapsuleOil), new kp(ForestryItem.waxCapsule), false));
        ForestryCore.injectWaxContainer(new LiquidContainer(new LiquidStack(fuel, 1000), new kp(ForestryItem.waxCapsuleFuel), new kp(ForestryItem.waxCapsule), false));
        ForestryCore.injectRefractoryContainer(new LiquidContainer(new LiquidStack(oilStill, 1000), new kp(ForestryItem.refractoryOil), new kp(ForestryItem.refractoryEmpty), false));
        ForestryCore.injectRefractoryContainer(new LiquidContainer(new LiquidStack(fuel, 1000), new kp(ForestryItem.refractoryFuel), new kp(ForestryItem.refractoryEmpty), false));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(oilStill, 1000), new kp(ForestryItem.canOil), new kp(ForestryItem.canEmpty), false));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(fuel, 1000), new kp(ForestryItem.canFuel), new kp(ForestryItem.canEmpty), false));
        BuildCraftAPI.liquids.add(new LiquidData(PluginBuildCraft.oilStill.bO, PluginBuildCraft.oilMoving.bO, new kp(ForestryItem.canOil)));
        BuildCraftAPI.liquids.add(new LiquidData(PluginBuildCraft.fuel.bP, PluginBuildCraft.fuel.bP, new kp(ForestryItem.canFuel)));
        BuildCraftAPI.liquids.add(new LiquidData(PluginBuildCraft.oilStill.bO, PluginBuildCraft.oilMoving.bO, new kp(ForestryItem.waxCapsuleOil)));
        BuildCraftAPI.liquids.add(new LiquidData(PluginBuildCraft.fuel.bP, PluginBuildCraft.fuel.bP, new kp(ForestryItem.waxCapsuleFuel)));
        BuildCraftAPI.liquids.add(new LiquidData(PluginBuildCraft.oilStill.bO, PluginBuildCraft.oilMoving.bO, new kp(ForestryItem.refractoryOil)));
        BuildCraftAPI.liquids.add(new LiquidData(PluginBuildCraft.fuel.bP, PluginBuildCraft.fuel.bP, new kp(ForestryItem.refractoryFuel)));
    }

    private void initWrench() {
        try {
            wrench = (id)Class.forName("BuildCraftCore").getField("wrenchItem").get(null);
        }
        catch (Exception ex) {
            ModLoader.getLogger().fine("No BuildCraft wrench found.");
            return;
        }
        if (wrench != null) {
            ForestryAPI.registerWrench(new kp(wrench));
        }
    }

    private void initStoneGear() {
        try {
            stoneGear = (id)Class.forName("BuildCraftCore").getField("stoneGearItem").get(null);
        }
        catch (Exception ex) {
            ModLoader.getLogger().fine("No BuildCraft stone gear found.");
            return;
        }
    }

    private void initWaterproof() {
        try {
            pipeWaterproof = (id)Class.forName("BuildCraftTransport").getField("pipeWaterproof").get(null);
        }
        catch (Exception ex) {
            ModLoader.getLogger().fine("No BuildCraft pipe waterproof found.");
            return;
        }
        Proxy.addRecipe(new kp(pipeWaterproof), new Object[]{"#", Character.valueOf('#'), ForestryItem.beeswax});
    }

    public static Orientations convertBuildCraftOrientation(buildcraft.api.Orientations orient) {
        return Orientations.values()[orient.ordinal()];
    }

    public static buildcraft.api.Orientations convertBuildCraftOrientation(Orientations orient) {
        return buildcraft.api.Orientations.values()[orient.ordinal()];
    }

    public LiquidSlot convertToBCLiquidSlot(TankSlot slot) {
        if (slot == null) {
            return null;
        }
        return new LiquidSlot(slot.liquidId, slot.quantity, slot.capacity);
    }

    public LiquidSlot[] convertToBCLiquidSlots(TankSlot[] slots) {
        if (slots == null || slots.length <= 0) {
            return new LiquidSlot[0];
        }
        LiquidSlot[] result = new LiquidSlot[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            result[i] = this.convertToBCLiquidSlot(slots[i]);
        }
        return result;
    }

    public void configurePowerProvider(PowerProvider powerProvider, EnergyConfiguration energyConfig) {
        powerProvider.configure(energyConfig.latency, energyConfig.minEnergyReceived, energyConfig.maxEnergyReceived, energyConfig.minActivationEnergy, energyConfig.maxEnergy);
        powerProvider.configurePowerPerdition(energyConfig.powerLoss, energyConfig.powerLossRegularity);
    }

    public float invokeUseEnergyMethod(PowerProvider powerProvider, float min, float max, boolean doUse) {
        return powerProvider.useEnergy(min, max, doUse);
    }

    public void invokeReceiveEnergyMethod(PowerProvider powerProvider, float quantity) {
        powerProvider.receiveEnergy(quantity, buildcraft.api.Orientations.XNeg);
    }

    @Override
    public LinkedList getPipeTriggers(IPipe pipe) {
        return null;
    }

    @Override
    public LinkedList getNeighborTriggers(vz block, qj tile) {
        if (tile instanceof TileForestry) {
            return ((TileForestry)tile).getCustomTriggers();
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "BuildCraft3";
    }

    @Override
    public void preInit() {
    }

    @Override
    public void generateSurface(ge world, Random rand, int chunkX, int chunkZ) {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return null;
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return null;
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return null;
    }

    @Override
    public IAchievementHandler getAchievementHandler() {
        return null;
    }

    @Override
    public IResupplyHandler getResupplyHandler() {
        return null;
    }
}

