/*
 * Decompiled with CFR 0.152.
 */
package forestry.pipes;

import buildcraft.api.APIProxy;
import buildcraft.api.Orientations;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeLogic;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBee;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.core.network.GuiId;
import forestry.core.network.NetProxy;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketNBT;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketUpdate;
import forestry.pipes.EnumFilterType;
import forestry.pipes.PipeProxy;
import java.util.ArrayList;

public class PipeLogicPropolis
extends PipeLogic {
    private EnumFilterType[] typeFilter = new EnumFilterType[6];
    private IAllele[][][] genomeFilter = new IAllele[6][3][2];

    public PipeLogicPropolis() {
        for (int i = 0; i < this.typeFilter.length; ++i) {
            this.typeFilter[i] = EnumFilterType.CLOSED;
        }
    }

    public void readFromNBT(ph nbttagcompound) {
        int i;
        super.readFromNBT(nbttagcompound);
        for (i = 0; i < this.typeFilter.length; ++i) {
            this.typeFilter[i] = EnumFilterType.values()[nbttagcompound.d("TypeFilter" + i)];
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (nbttagcompound.c("GenomeFilterI" + i + "-" + j + "-" + 0)) {
                    this.genomeFilter[i][j][0] = AlleleManager.alleleList[nbttagcompound.f("GenomeFilterI" + i + "-" + j + "-" + 0)];
                }
                if (!nbttagcompound.c("GenomeFilterI" + i + "-" + j + "-" + 1)) continue;
                this.genomeFilter[i][j][1] = AlleleManager.alleleList[nbttagcompound.f("GenomeFilterI" + i + "-" + j + "-" + 1)];
            }
        }
    }

    public void writeToNBT(ph nbttagcompound) {
        int i;
        super.writeToNBT(nbttagcompound);
        for (i = 0; i < this.typeFilter.length; ++i) {
            nbttagcompound.a("TypeFilter" + i, (byte)this.typeFilter[i].ordinal());
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.genomeFilter[i][j][0] != null) {
                    nbttagcompound.a("GenomeFilterI" + i + "-" + j + "-" + 0, this.genomeFilter[i][j][0].getId());
                }
                if (this.genomeFilter[i][j][1] == null) continue;
                nbttagcompound.a("GenomeFilterI" + i + "-" + j + "-" + 1, this.genomeFilter[i][j][1].getId());
            }
        }
    }

    public boolean blockActivated(ih player) {
        if (APIProxy.isClient(this.worldObj)) {
            return true;
        }
        if (player.U() != null && player.U().c < vz.m.length && vz.m[player.U().c] instanceof BlockGenericPipe) {
            return false;
        }
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.PropolisPipeGUI.ordinal(), player.bi, this.container.l, this.container.m, this.container.n);
        return true;
    }

    public boolean isClosed(Orientations orientation) {
        return this.typeFilter[orientation.ordinal()] == EnumFilterType.CLOSED;
    }

    public boolean isIndiscriminate(Orientations orientation) {
        return this.typeFilter[orientation.ordinal()] == EnumFilterType.ANYTHING;
    }

    public boolean matchType(Orientations orientation, EnumFilterType type, IBee bee) {
        EnumFilterType filter = this.typeFilter[orientation.ordinal()];
        if (filter == EnumFilterType.BEE) {
            return type != EnumFilterType.ITEM && type != EnumFilterType.CLOSED && type != EnumFilterType.CLOSED;
        }
        if (bee != null) {
            if (filter == EnumFilterType.PURE_BREED) {
                return bee.isPureBred(EnumBeeChromosome.SPECIES);
            }
            if (filter == EnumFilterType.NOCTURNAL) {
                return bee.getGenome().getNocturnal();
            }
            if (filter == EnumFilterType.PURE_NOCTURNAL) {
                return bee.getGenome().getNocturnal() && bee.isPureBred(EnumBeeChromosome.NOCTURNAL);
            }
            if (filter == EnumFilterType.FLYER) {
                return bee.getGenome().getTolerantFlyer();
            }
            if (filter == EnumFilterType.PURE_FLYER) {
                return bee.getGenome().getTolerantFlyer() && bee.isPureBred(EnumBeeChromosome.TOLERANT_FLYER);
            }
            if (filter == EnumFilterType.CAVE) {
                return bee.getGenome().getCaveDwelling();
            }
            if (filter == EnumFilterType.PURE_CAVE) {
                return bee.getGenome().getCaveDwelling() && bee.isPureBred(EnumBeeChromosome.CAVE_DWELLING);
            }
        }
        return filter == type;
    }

    public boolean matchAllele(IAllele filter, int allele) {
        if (filter == null) {
            return true;
        }
        return filter.getId() == allele;
    }

    public ArrayList getGenomeFilters(Orientations orientation) {
        ArrayList<IAllele[]> filters = new ArrayList<IAllele[]>();
        for (int i = 0; i < 3; ++i) {
            if (this.genomeFilter[orientation.ordinal()][i] == null || this.genomeFilter[orientation.ordinal()][i][0] == null && this.genomeFilter[orientation.ordinal()][i][1] == null) continue;
            filters.add(this.genomeFilter[orientation.ordinal()][i]);
        }
        return filters;
    }

    public EnumFilterType getTypeFilter(Orientations orientation) {
        return this.typeFilter[orientation.ordinal()];
    }

    public void setTypeFilter(Orientations orientation, EnumFilterType type) {
        this.typeFilter[orientation.ordinal()] = type;
        if (PipeProxy.isRemote()) {
            this.sendTypeFilterChange(orientation, type);
        }
    }

    public IAlleleSpecies getSpeciesFilter(Orientations orientation, int pattern, int allele) {
        if (this.genomeFilter[orientation.ordinal()] == null) {
            return null;
        }
        if (this.genomeFilter[orientation.ordinal()].length <= pattern) {
            return null;
        }
        if (this.genomeFilter[orientation.ordinal()][pattern] == null) {
            return null;
        }
        if (this.genomeFilter[orientation.ordinal()][pattern].length <= allele) {
            return null;
        }
        return (IAlleleSpecies)this.genomeFilter[orientation.ordinal()][pattern][allele];
    }

    public void setSpeciesFilter(Orientations orientation, int pattern, int allele, IAllele species) {
        this.genomeFilter[orientation.ordinal()][pattern][allele] = species;
        if (PipeProxy.isRemote()) {
            this.sendGenomeFilterChange(orientation, pattern, allele, species);
        }
    }

    public void sendFilterSet(ih player) {
        ph nbttagcompound = new ph();
        this.writeToNBT(nbttagcompound);
        NetProxy.sendToPlayer(new PacketNBT(100, nbttagcompound), player);
    }

    public void handleTypeFilterChange(PacketPayload payload) {
        this.typeFilter[payload.intPayload[0]] = EnumFilterType.values()[payload.intPayload[1]];
    }

    public void handleGenomeFilterChange(PacketPayload payload) {
        this.genomeFilter[payload.intPayload[0]][payload.intPayload[1]][payload.intPayload[2]] = payload.intPayload[3] >= 0 ? AlleleManager.alleleList[payload.intPayload[3]] : null;
    }

    public void requestFilterSet() {
        NetProxy.sendToServer(new PacketCoordinates(120, this.container.l, this.container.m, this.container.n));
    }

    public void sendTypeFilterChange(Orientations orientation, EnumFilterType filter) {
        PacketPayload payload = new PacketPayload(2, 0, 0);
        payload.intPayload[0] = orientation.ordinal();
        payload.intPayload[1] = filter.ordinal();
        NetProxy.sendToServer(new PacketUpdate(140, this.container.l, this.container.m, this.container.n, payload));
    }

    public void sendGenomeFilterChange(Orientations orientation, int pattern, int allele, IAllele species) {
        PacketPayload payload = new PacketPayload(4, 0, 0);
        payload.intPayload[0] = orientation.ordinal();
        payload.intPayload[1] = pattern;
        payload.intPayload[2] = allele;
        payload.intPayload[3] = species != null ? species.getId() : -1;
        NetProxy.sendToServer(new PacketUpdate(130, this.container.l, this.container.m, this.container.n, payload));
    }

    public void handleFilterSet(PacketNBT packet) {
        this.readFromNBT(packet.getTagCompound());
    }
}

