/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.core.INBTTagable;
import forestry.core.config.ForestryItem;
import forestry.mail.EnumAddressee;
import forestry.mail.EnumDeliveryState;
import forestry.mail.EnumPostage;
import forestry.mail.ILetter;
import forestry.mail.IPostOffice;
import forestry.mail.IPostalState;
import forestry.mail.IStamps;
import forestry.mail.ItemLetter;
import forestry.mail.MailAddress;
import forestry.mail.POBox;
import forestry.mail.ProxyMail;
import forestry.mail.TradeStation;
import java.io.File;
import java.util.HashMap;

public class PostOffice
extends jd
implements IPostOffice,
INBTTagable {
    public static final String SAVE_NAME = "ForestryMail";
    public static PostOffice cachedPostOffice;
    public static HashMap cachedPOBoxes;
    public static HashMap cachedTradeStations;
    private int[] collectedPostage = new int[EnumPostage.values().length];

    public static boolean isValidPOBox(ge world, String username) {
        return username.matches("^[a-zA-Z0-9]+$");
    }

    public static POBox getPOBox(ge world, String username) {
        if (cachedPOBoxes.containsKey(username)) {
            return (POBox)((Object)cachedPOBoxes.get(username));
        }
        POBox pobox = (POBox)world.a(POBox.class, "POBox_" + username);
        if (pobox != null) {
            cachedPOBoxes.put(username, pobox);
        }
        return pobox;
    }

    public static POBox getOrCreatePOBox(ge world, String username) {
        POBox pobox = PostOffice.getPOBox(world, username);
        if (pobox == null) {
            pobox = new POBox(username, true);
            world.a("POBox_" + username, (jd)pobox);
            pobox.a();
            cachedPOBoxes.put(username, pobox);
            ProxyMail.setPOBoxInfo(world, username, pobox.getPOBoxInfo());
        }
        return pobox;
    }

    public static boolean isValidTradeMoniker(ge world, String moniker) {
        return moniker.matches("^[a-zA-Z0-9]+$");
    }

    public static boolean isAvailableTradeMoniker(ge world, String moniker) {
        return PostOffice.getTradeStation(world, moniker) == null;
    }

    public static TradeStation getTradeStation(ge world, String moniker) {
        if (cachedTradeStations.containsKey(moniker)) {
            return (TradeStation)cachedTradeStations.get(moniker);
        }
        TradeStation trade = (TradeStation)world.a(TradeStation.class, "TradePO_" + moniker);
        if (trade != null && trade.isValid()) {
            cachedTradeStations.put(moniker, trade);
            return trade;
        }
        return null;
    }

    public static TradeStation getOrCreateTradeStation(ge world, String owner, String moniker) {
        TradeStation trade = PostOffice.getTradeStation(world, moniker);
        if (trade == null) {
            trade = new TradeStation(owner, moniker, true);
            world.a("TradePO_" + moniker, (jd)trade);
            trade.a();
            cachedTradeStations.put(moniker, trade);
        }
        return trade;
    }

    public static void deleteTradeStation(ge world, String moniker) {
        TradeStation trade = PostOffice.getTradeStation(world, moniker);
        if (trade == null) {
            return;
        }
        trade.invalidate();
        cachedTradeStations.remove(moniker);
        File file = world.r().b(trade.a);
        file.delete();
    }

    public static IPostOffice getPostOffice(ge world) {
        if (cachedPostOffice != null) {
            return cachedPostOffice;
        }
        PostOffice office = (PostOffice)world.a(PostOffice.class, SAVE_NAME);
        if (office == null) {
            office = new PostOffice();
            world.a(SAVE_NAME, (jd)office);
        }
        cachedPostOffice = office;
        return office;
    }

    public PostOffice(String s) {
        super(s);
    }

    public PostOffice() {
        super(SAVE_NAME);
    }

    @Override
    public void a(ph nbttagcompound) {
        for (int i = 0; i < this.collectedPostage.length; ++i) {
            if (!nbttagcompound.c("CPS" + i)) continue;
            this.collectedPostage[i] = nbttagcompound.f("CPS" + i);
        }
    }

    @Override
    public void b(ph nbttagcompound) {
        for (int i = 0; i < this.collectedPostage.length; ++i) {
            nbttagcompound.a("CPS" + i, this.collectedPostage[i]);
        }
    }

    @Override
    public kp getAnyStamp(int max) {
        return this.getAnyStamp(EnumPostage.values(), max);
    }

    @Override
    public kp getAnyStamp(EnumPostage postage, int max) {
        return this.getAnyStamp(new EnumPostage[]{postage}, max);
    }

    @Override
    public kp getAnyStamp(EnumPostage[] postages, int max) {
        for (EnumPostage postage : postages) {
            int collected = 0;
            if (this.collectedPostage[postage.ordinal()] <= 0) continue;
            if (max >= this.collectedPostage[postage.ordinal()]) {
                collected = this.collectedPostage[postage.ordinal()];
                this.collectedPostage[postage.ordinal()] = 0;
            } else {
                collected = max;
                int n = postage.ordinal();
                this.collectedPostage[n] = this.collectedPostage[n] - max;
            }
            if (collected <= 0) continue;
            return new kp(ForestryItem.stamps, collected, postage.ordinal() - 1);
        }
        return null;
    }

    @Override
    public IPostalState lodgeLetter(ge world, kp itemstack, boolean doLodge) {
        ILetter letter = ItemLetter.getLetter(itemstack);
        if (letter.isProcessed()) {
            return EnumDeliveryState.ALREADY_MAILED;
        }
        if (!letter.isPostPaid()) {
            return EnumDeliveryState.NOT_POSTPAID;
        }
        if (!letter.isMailable()) {
            return EnumDeliveryState.NOT_MAILABLE;
        }
        IPostalState state = EnumDeliveryState.NOT_MAILABLE;
        for (MailAddress address : letter.getRecipients()) {
            if (address.isPlayer()) {
                state = this.storeInPOBox(world, address, itemstack, doLodge);
                continue;
            }
            if (address.getType() != EnumAddressee.TRADER) continue;
            state = this.handleTradeLetter(world, address, itemstack, doLodge);
        }
        if (!state.isOk()) {
            return state;
        }
        this.collectPostage(letter.getPostage());
        this.a();
        return EnumDeliveryState.OK;
    }

    private IPostalState handleTradeLetter(ge world, MailAddress address, kp letterstack, boolean doLodge) {
        IPostalState state = EnumDeliveryState.NOT_MAILABLE;
        TradeStation trade = PostOffice.getTradeStation(world, address.getIdentifier());
        if (trade == null) {
            return EnumDeliveryState.NO_MAILBOX;
        }
        state = trade.handleLetter(world, address, letterstack, doLodge);
        return state;
    }

    private EnumDeliveryState storeInPOBox(ge world, MailAddress address, kp letterstack, boolean doLodge) {
        if (!address.isPlayer()) {
            return EnumDeliveryState.NOT_MAILABLE;
        }
        POBox pobox = PostOffice.getPOBox(world, address.getIdentifier());
        if (pobox == null) {
            return EnumDeliveryState.NO_MAILBOX;
        }
        if (!pobox.storeLetter(letterstack.j())) {
            return EnumDeliveryState.MAILBOX_FULL;
        }
        ProxyMail.setPOBoxInfo(world, address.getIdentifier(), pobox.getPOBoxInfo());
        return EnumDeliveryState.OK;
    }

    @Override
    public void collectPostage(kp[] stamps) {
        for (kp stamp : stamps) {
            if (stamp == null || !(stamp.a() instanceof IStamps)) continue;
            EnumPostage postage = ((IStamps)stamp.a()).getPostage(stamp);
            int n = postage.ordinal();
            this.collectedPostage[n] = this.collectedPostage[n] + stamp.a;
        }
    }

    static {
        cachedPOBoxes = new HashMap();
        cachedTradeStations = new HashMap();
    }
}

